/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage;

import io.datarouter.instrumentation.trace.Traceparent;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.trace.storage.entity.Trace2Bundle;
import io.datarouter.trace.storage.entity.Trace2EntityKey;
import io.datarouter.trace.storage.span.Trace2Span;
import io.datarouter.trace.storage.span.Trace2SpanKey;
import io.datarouter.trace.storage.thread.Trace2Thread;
import io.datarouter.trace.storage.thread.Trace2ThreadKey;
import io.datarouter.trace.storage.trace.Trace2;
import io.datarouter.trace.storage.trace.Trace2Key;
import java.util.List;
import java.util.Optional;

public abstract class BaseTrace2Dao
extends BaseDao {
    private static final Config CONFIG = new Config().setIgnoreNullFields(Boolean.valueOf(true)).setPersistentPut(Boolean.valueOf(false));
    private final SortedMapStorage.SortedMapStorageNode<Trace2Key, Trace2, Trace2.Trace2Fielder> traceNode;
    private final SortedMapStorage.SortedMapStorageNode<Trace2ThreadKey, Trace2Thread, Trace2Thread.Trace2ThreadFielder> traceThreadNode;
    private final SortedMapStorage.SortedMapStorageNode<Trace2SpanKey, Trace2Span, Trace2Span.Trace2SpanFielder> traceSpanNode;

    public BaseTrace2Dao(Optional<String> tableNamePrefix, Datarouter datarouter, BaseDaoParams params, NodeFactory nodeFactory) {
        super(datarouter);
        this.traceNode = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(params.clientId, Trace2EntityKey::new, Trace2::new, Trace2.Trace2Fielder::new).withTableName((String)tableNamePrefix.map(prefix -> String.valueOf(prefix) + Trace2.class.getSimpleName()).orElse(null)).buildAndRegister();
        this.traceThreadNode = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(params.clientId, Trace2EntityKey::new, Trace2Thread::new, Trace2Thread.Trace2ThreadFielder::new).withTableName((String)tableNamePrefix.map(prefix -> String.valueOf(prefix) + Trace2Thread.class.getSimpleName()).orElse(null)).buildAndRegister();
        this.traceSpanNode = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(params.clientId, Trace2EntityKey::new, Trace2Span::new, Trace2Span.Trace2SpanFielder::new).withTableName((String)tableNamePrefix.map(prefix -> String.valueOf(prefix) + Trace2Span.class.getSimpleName()).orElse(null)).buildAndRegister();
    }

    public void putMultiTraceBundles(List<Trace2Thread> threadDatabeans, List<Trace2Span> spanDatabeans, List<Trace2> traceDatabean) {
        this.traceThreadNode.putMulti(threadDatabeans, CONFIG);
        this.traceSpanNode.putMulti(spanDatabeans, CONFIG);
        this.traceNode.putMulti(traceDatabean, CONFIG);
    }

    public Scanner<Trace2> scanWithPrefixAnyDelay(String traceId) {
        return this.traceNode.scanWithPrefix((PrimaryKey)new Trace2Key(traceId));
    }

    public Optional<Trace2Bundle> getEntity(Traceparent traceparent) {
        return this.traceNode.find((PrimaryKey)new Trace2Key(traceparent)).map(trace -> new Trace2Bundle(trace.getServiceName(), (Trace2)((Object)trace), this.traceThreadNode.scanWithPrefix((PrimaryKey)new Trace2ThreadKey(traceparent, null)).list(), this.traceSpanNode.scanWithPrefix((PrimaryKey)new Trace2SpanKey(traceparent, null, null)).list()));
    }
}

