/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.util.PrimaryKeyVacuum;
import io.datarouter.trace.storage.BaseDatarouterTraceDao;
import io.datarouter.trace.storage.entity.BaseTraceEntityKey;
import io.datarouter.trace.storage.entity.TraceEntityKey;
import io.datarouter.trace.storage.entity.UiTraceBundleDto;
import io.datarouter.trace.storage.span.TraceSpan;
import io.datarouter.trace.storage.span.TraceSpanKey;
import io.datarouter.trace.storage.thread.TraceThread;
import io.datarouter.trace.storage.thread.TraceThreadKey;
import io.datarouter.trace.storage.trace.Trace;
import io.datarouter.trace.storage.trace.TraceKey;
import io.datarouter.trace.storage.trace.TraceTool;
import io.datarouter.trace.web.AccessException;
import java.util.Collection;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterTraceDao
extends BaseDao
implements BaseDatarouterTraceDao {
    private final SortedMapStorage<TraceKey, Trace> traceNode;
    private final SortedMapStorage<TraceThreadKey, TraceThread> traceThreadNode;
    private final SortedMapStorage<TraceSpanKey, TraceSpan> traceSpanNode;

    @Inject
    public DatarouterTraceDao(Datarouter datarouter, DatarouterTraceDaoParams params, NodeFactory nodeFactory) {
        super(datarouter);
        this.traceNode = (SortedMapStorage)nodeFactory.create(params.clientId, TraceEntityKey::new, Trace::new, Trace.TraceFielder::new).buildAndRegister();
        this.traceThreadNode = (SortedMapStorage)nodeFactory.create(params.clientId, TraceEntityKey::new, TraceThread::new, TraceThread.TraceThreadFielder::new).buildAndRegister();
        this.traceSpanNode = (SortedMapStorage)nodeFactory.create(params.clientId, TraceEntityKey::new, TraceSpan::new, TraceSpan.TraceSpanFielder::new).buildAndRegister();
    }

    @Override
    public void putMulti(Collection<TraceThread> threadDatabeans, Collection<TraceSpan> spanDatabeans, Trace traceDatabean) {
        Config config = new Config().setIgnoreNullFields(Boolean.valueOf(true)).setPersistentPut(Boolean.valueOf(false));
        this.traceThreadNode.putMulti(threadDatabeans, config);
        this.traceSpanNode.putMulti(spanDatabeans, config);
        this.traceNode.put((Databean)traceDatabean, config);
    }

    @Override
    public UiTraceBundleDto getEntity(String traceId) throws AccessException {
        Trace trace = (Trace)this.traceNode.get((PrimaryKey)new TraceKey(traceId));
        if (trace == null) {
            throw TraceTool.makeException(traceId);
        }
        return new UiTraceBundleDto("", trace, this.traceThreadNode.scanWithPrefix((PrimaryKey)new TraceThreadKey(traceId, null)).list(), this.traceSpanNode.scanWithPrefix((PrimaryKey)new TraceSpanKey(traceId, null, null)).list());
    }

    public PrimaryKeyVacuum<TraceKey> makeTraceVacuum() {
        Predicate<TraceKey> isExpired = key -> this.isExpired((BaseTraceEntityKey<?>)((Object)((Object)key.getEntityKey())));
        return new PrimaryKeyVacuum.PrimaryKeyVacuumBuilder(this.traceNode.scanKeys().advanceWhile(isExpired), $ -> true, arg_0 -> this.traceNode.deleteMulti(arg_0)).build();
    }

    public PrimaryKeyVacuum<TraceSpanKey> makeTraceSpanVacuum() {
        Predicate<TraceSpanKey> isExpired = key -> this.isExpired((BaseTraceEntityKey<?>)((Object)((Object)key.getEntityKey())));
        return new PrimaryKeyVacuum.PrimaryKeyVacuumBuilder(this.traceSpanNode.scanKeys().advanceWhile(isExpired), $ -> true, arg_0 -> this.traceSpanNode.deleteMulti(arg_0)).build();
    }

    public PrimaryKeyVacuum<TraceThreadKey> makeTraceThreadVacuum() {
        Predicate<TraceThreadKey> isExpired = key -> this.isExpired((BaseTraceEntityKey<?>)((Object)((Object)key.getEntityKey())));
        return new PrimaryKeyVacuum.PrimaryKeyVacuumBuilder(this.traceThreadNode.scanKeys().advanceWhile(isExpired), $ -> true, arg_0 -> this.traceThreadNode.deleteMulti(arg_0)).build();
    }

    private boolean isExpired(BaseTraceEntityKey<?> entityKey) {
        return entityKey.getAge().compareTo(Trace.TTL) > 0;
    }

    public static class DatarouterTraceDaoParams
    extends BaseDaoParams {
        public DatarouterTraceDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

