/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage.entity;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.key.entity.base.BaseEntityKey;
import io.datarouter.util.UlidTool;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public abstract class BaseTraceEntityKey<EK extends BaseEntityKey<EK>>
extends BaseEntityKey<EK> {
    private String traceId;

    public List<Field<?>> getFields() {
        return List.of(new StringField(FieldKeys.traceId, this.traceId));
    }

    public BaseTraceEntityKey() {
    }

    public BaseTraceEntityKey(String traceId) {
        this.traceId = traceId;
    }

    public String getTraceEntityId() {
        return this.traceId;
    }

    public Instant getInstant() {
        return UlidTool.getInstant((String)this.traceId);
    }

    public Duration getAge() {
        return Duration.between(this.getInstant(), Instant.now());
    }

    public static class FieldKeys {
        public static final StringFieldKey traceId = new StringFieldKey("traceId");
    }
}

