/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage.span;

import io.datarouter.instrumentation.trace.TraceSpanDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.positive.UInt31Field;
import io.datarouter.model.field.imp.positive.UInt31FieldKey;
import io.datarouter.model.field.imp.positive.UInt63Field;
import io.datarouter.model.field.imp.positive.UInt63FieldKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.model.serialize.fielder.Fielder;
import io.datarouter.trace.storage.entity.BaseTraceEntityKey;
import io.datarouter.trace.storage.span.BaseTraceSpanKey;
import io.datarouter.trace.storage.thread.BaseTraceThreadKey;
import java.util.List;

public abstract class BaseTraceSpan<EK extends BaseTraceEntityKey<EK>, PK extends BaseTraceSpanKey<EK, PK>, TK extends BaseTraceThreadKey<EK, TK>, D extends BaseTraceSpan<EK, PK, TK, D>>
extends BaseDatabean<PK, D> {
    protected Integer parentSequence;
    protected String name;
    protected Long created;
    protected Long duration;
    protected String info;
    protected Long nanoStart;

    public BaseTraceSpan(PK key) {
        super(key);
    }

    public BaseTraceSpan(PK key, TraceSpanDto dto) {
        super(key);
        this.parentSequence = dto.getParentSequence();
        this.name = dto.getName();
        this.info = dto.getInfo();
        this.created = dto.getCreated();
        this.duration = dto.getDuration();
    }

    public TraceSpanDto toDto() {
        return new TraceSpanDto(((BaseTraceEntityKey)((Object)((BaseTraceSpanKey)this.getKey()).getEntityKey())).getTraceEntityId(), ((BaseTraceSpanKey)this.getKey()).getThreadId(), ((BaseTraceSpanKey)this.getKey()).getSequence(), this.getParentSequence(), this.getName(), this.getInfo(), this.getCreated(), this.getDuration());
    }

    public String toString() {
        return this.getKey() + "[" + this.name + "][" + this.info + "]";
    }

    public boolean isTopLevel() {
        return this.parentSequence == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Integer getParentSequence() {
        return this.parentSequence;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public abstract TK getThreadKey();

    public static class BaseTraceSpanFielder<EK extends BaseTraceEntityKey<EK>, PK extends BaseTraceSpanKey<EK, PK>, TK extends BaseTraceThreadKey<EK, TK>, D extends BaseTraceSpan<EK, PK, TK, D>>
    extends BaseDatabeanFielder<PK, D> {
        protected BaseTraceSpanFielder(Class<? extends Fielder<PK>> primaryKeyFielderClass) {
            super(primaryKeyFielderClass);
        }

        public List<Field<?>> getNonKeyFields(D traceSpan) {
            return List.of(new UInt31Field(FieldKeys.parentSequence, ((BaseTraceSpan)((Object)traceSpan)).getParentSequence()), new StringField(FieldKeys.name, ((BaseTraceSpan)((Object)traceSpan)).getName()), new StringField(FieldKeys.info, ((BaseTraceSpan)((Object)traceSpan)).getInfo()), new UInt63Field(FieldKeys.created, ((BaseTraceSpan)((Object)traceSpan)).getCreated()), new UInt63Field(FieldKeys.duration, ((BaseTraceSpan)((Object)traceSpan)).getDuration()));
        }
    }

    public static class FieldKeys {
        public static final UInt31FieldKey parentSequence = new UInt31FieldKey("parentSequence");
        public static final StringFieldKey name = new StringFieldKey("name").withSize(65535);
        public static final StringFieldKey info = new StringFieldKey("info");
        public static final UInt63FieldKey created = new UInt63FieldKey("created");
        public static final UInt63FieldKey duration = new UInt63FieldKey("duration");
    }
}

