/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage.span;

import io.datarouter.instrumentation.trace.Trace2SpanDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.positive.UInt31Field;
import io.datarouter.model.field.imp.positive.UInt31FieldKey;
import io.datarouter.model.field.imp.positive.UInt63Field;
import io.datarouter.model.field.imp.positive.UInt63FieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.model.serialize.fielder.FielderConfigValue;
import io.datarouter.trace.storage.span.Trace2SpanKey;
import io.datarouter.trace.storage.trace.Trace2;
import java.util.List;

public class Trace2Span
extends BaseDatabean<Trace2SpanKey, Trace2Span> {
    private Integer parentSequence;
    private String name;
    private Long created;
    private Long ended;
    private String info;

    public Trace2Span() {
        this(new Trace2SpanKey());
    }

    public Trace2Span(Trace2SpanKey key) {
        super((PrimaryKey)key);
    }

    public Trace2Span(Trace2SpanDto dto) {
        super((PrimaryKey)new Trace2SpanKey(dto.traceparent, dto.parentThreadId, dto.sequence));
        this.parentSequence = dto.parentSequence;
        this.name = dto.name;
        this.created = dto.created;
        this.ended = dto.ended;
        this.info = dto.info;
    }

    public Class<Trace2SpanKey> getKeyClass() {
        return Trace2SpanKey.class;
    }

    public boolean isTopLevel() {
        return this.parentSequence == null;
    }

    public Long getThreadId() {
        return ((Trace2SpanKey)this.getKey()).getThreadId();
    }

    public Integer getSequence() {
        return ((Trace2SpanKey)this.getKey()).getSequence();
    }

    public String getName() {
        return this.name;
    }

    public Long getCreated() {
        return this.created;
    }

    public Long getEnded() {
        return this.ended;
    }

    public Integer getParentSequence() {
        return this.parentSequence;
    }

    public String getInfo() {
        return this.info;
    }

    public String toString() {
        return this.getKey() + "[" + this.name + "][" + this.info + "]";
    }

    public static class FieldKeys {
        public static final UInt31FieldKey parentSequence = new UInt31FieldKey("parentSequence");
        public static final StringFieldKey name = new StringFieldKey("name").withSize(65535);
        public static final StringFieldKey info = new StringFieldKey("info");
        public static final UInt63FieldKey created = new UInt63FieldKey("created");
        public static final UInt63FieldKey ended = new UInt63FieldKey("ended");
    }

    public static class Trace2SpanFielder
    extends BaseDatabeanFielder<Trace2SpanKey, Trace2Span> {
        public Trace2SpanFielder() {
            super(Trace2SpanKey.class);
            this.addOption((FielderConfigValue)Trace2.TTL_FIELDER_CONFIG);
        }

        public List<Field<?>> getNonKeyFields(Trace2Span databean) {
            return List.of(new UInt31Field(FieldKeys.parentSequence, databean.parentSequence), new StringField(FieldKeys.name, databean.name), new StringField(FieldKeys.info, databean.info), new UInt63Field(FieldKeys.created, databean.created), new UInt63Field(FieldKeys.ended, databean.ended));
        }
    }
}

