/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage.thread;

import io.datarouter.instrumentation.trace.TraceThreadDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.positive.UInt31Field;
import io.datarouter.model.field.imp.positive.UInt31FieldKey;
import io.datarouter.model.field.imp.positive.UInt63Field;
import io.datarouter.model.field.imp.positive.UInt63FieldKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.model.serialize.fielder.Fielder;
import io.datarouter.trace.storage.entity.BaseTraceEntityKey;
import io.datarouter.trace.storage.thread.BaseTraceThreadKey;
import io.datarouter.util.string.StringTool;
import java.util.Date;
import java.util.List;

public abstract class BaseTraceThread<EK extends BaseTraceEntityKey<EK>, PK extends BaseTraceThreadKey<EK, PK>, D extends BaseTraceThread<EK, PK, D>>
extends BaseDatabean<PK, D> {
    protected Long parentId;
    protected String name;
    protected String info;
    protected String serverId;
    protected Long created;
    protected Long queuedDuration;
    protected Long runningDuration;
    protected Integer discardedSpanCount;
    protected String hostThreadName;

    public BaseTraceThread(PK key) {
        super(key);
    }

    public BaseTraceThread(PK key, TraceThreadDto dto) {
        super(key);
        this.parentId = dto.getParentId();
        this.name = dto.getName();
        this.info = StringTool.trimToSize((String)dto.getInfo(), (int)FieldKeys.info.getSize());
        this.serverId = dto.getServerId();
        this.created = dto.getCreated();
        this.queuedDuration = dto.getQueuedDuration();
        this.runningDuration = dto.getRunningDuration();
        this.discardedSpanCount = dto.getDiscardedSpanCount();
        this.hostThreadName = dto.getHostThreadName();
    }

    public TraceThreadDto toDto() {
        return new TraceThreadDto(((BaseTraceThreadKey)this.getKey()).getTraceId(), ((BaseTraceThreadKey)this.getKey()).getThreadId(), this.getParentId(), this.getName(), this.getInfo(), this.getServerId(), this.getCreated(), this.getQueuedDuration(), this.getRunningDuration(), this.getDiscardedSpanCount(), this.getHostThreadName());
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.name + "]";
    }

    public Date getTime() {
        return new Date(this.created);
    }

    public Long getThreadId() {
        return ((BaseTraceThreadKey)this.getKey()).getThreadId();
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getQueuedDuration() {
        return this.queuedDuration;
    }

    public void setQueuedDuration(Long queuedDuration) {
        this.queuedDuration = queuedDuration;
    }

    public Long getRunningDuration() {
        return this.runningDuration;
    }

    public Integer getDiscardedSpanCount() {
        return this.discardedSpanCount;
    }

    public void setRunningDuration(Long runningDuration) {
        this.runningDuration = runningDuration;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getHostThreadName() {
        return this.hostThreadName;
    }

    public static class BaseTraceThreadFielder<EK extends BaseTraceEntityKey<EK>, PK extends BaseTraceThreadKey<EK, PK>, D extends BaseTraceThread<EK, PK, D>>
    extends BaseDatabeanFielder<PK, D> {
        public BaseTraceThreadFielder(Class<? extends Fielder<PK>> primaryKeyFielderClass) {
            super(primaryKeyFielderClass);
        }

        public List<Field<?>> getNonKeyFields(D traceThread) {
            return List.of(new UInt63Field(FieldKeys.parentId, ((BaseTraceThread)((Object)traceThread)).getParentId()), new StringField(FieldKeys.name, ((BaseTraceThread)((Object)traceThread)).getName()), new StringField(FieldKeys.info, ((BaseTraceThread)((Object)traceThread)).getInfo()), new StringField(FieldKeys.serverId, ((BaseTraceThread)((Object)traceThread)).getServerId()), new UInt63Field(FieldKeys.created, ((BaseTraceThread)((Object)traceThread)).getCreated()), new UInt63Field(FieldKeys.queuedDuration, ((BaseTraceThread)((Object)traceThread)).getQueuedDuration()), new UInt63Field(FieldKeys.runningDuration, ((BaseTraceThread)((Object)traceThread)).getRunningDuration()), new UInt31Field(FieldKeys.discardedSpanCount, ((BaseTraceThread)((Object)traceThread)).getDiscardedSpanCount()), new StringField(FieldKeys.hostThreadName, ((BaseTraceThread)((Object)traceThread)).hostThreadName));
        }
    }

    public static class FieldKeys {
        public static final UInt63FieldKey parentId = new UInt63FieldKey("parentId");
        public static final StringFieldKey name = new StringFieldKey("name");
        public static final StringFieldKey info = new StringFieldKey("info");
        public static final StringFieldKey serverId = new StringFieldKey("serverId").withColumnName("serverId");
        public static final UInt63FieldKey created = new UInt63FieldKey("created");
        public static final UInt63FieldKey queuedDuration = new UInt63FieldKey("queuedDuration");
        public static final UInt63FieldKey runningDuration = new UInt63FieldKey("runningDuration");
        public static final UInt31FieldKey discardedSpanCount = new UInt31FieldKey("discardedSpanCount");
        public static final StringFieldKey hostThreadName = new StringFieldKey("hostThreadName");
    }
}

