/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage.thread;

import io.datarouter.instrumentation.trace.Trace2ThreadDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.positive.UInt31Field;
import io.datarouter.model.field.imp.positive.UInt31FieldKey;
import io.datarouter.model.field.imp.positive.UInt63Field;
import io.datarouter.model.field.imp.positive.UInt63FieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.model.serialize.fielder.FielderConfigValue;
import io.datarouter.trace.storage.thread.Trace2ThreadKey;
import io.datarouter.trace.storage.trace.Trace2;
import java.util.Date;
import java.util.List;

public class Trace2Thread
extends BaseDatabean<Trace2ThreadKey, Trace2Thread> {
    private Long parentThreadId;
    private String name;
    private String info;
    private String serverName;
    private Long created;
    private Long queuedEnded;
    private Long ended;
    private Integer discardedSpanCount;
    private String hostThreadName;
    private Integer totalSpanCount;

    public Trace2Thread() {
        this(new Trace2ThreadKey());
    }

    public Trace2Thread(Trace2ThreadKey key) {
        super((PrimaryKey)key);
    }

    public Trace2Thread(Trace2ThreadDto dto) {
        super((PrimaryKey)new Trace2ThreadKey(dto.traceparent, dto.threadId));
        this.parentThreadId = dto.parentThreadId;
        this.name = dto.name;
        this.info = dto.info;
        this.serverName = dto.serverName;
        this.created = dto.created;
        this.queuedEnded = dto.queuedEnded;
        this.ended = dto.ended;
        this.discardedSpanCount = dto.discardedSpanCount;
        this.hostThreadName = dto.hostThreadName;
        this.totalSpanCount = dto.totalSpanCount;
    }

    public Class<Trace2ThreadKey> getKeyClass() {
        return Trace2ThreadKey.class;
    }

    public Date getTime() {
        return new Date(this.created);
    }

    public Long getThreadId() {
        return ((Trace2ThreadKey)this.getKey()).getThreadId();
    }

    public String getServerName() {
        return this.serverName;
    }

    public Long getParentThreadId() {
        return this.parentThreadId;
    }

    public String getName() {
        return this.name;
    }

    public Long getCreated() {
        return this.created;
    }

    public Long getQueuedEnded() {
        return this.queuedEnded;
    }

    public Long getEnded() {
        return this.ended;
    }

    public Integer getDiscardedSpanCount() {
        return this.discardedSpanCount;
    }

    public String getInfo() {
        return this.info;
    }

    public String getHostThreadName() {
        return this.hostThreadName;
    }

    public Integer getTotalSpanCount() {
        return this.totalSpanCount;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.name + "]";
    }

    public static class FieldKeys {
        public static final UInt63FieldKey parentThreadId = new UInt63FieldKey("parentThreadId");
        public static final StringFieldKey name = new StringFieldKey("name");
        public static final StringFieldKey info = new StringFieldKey("info");
        public static final StringFieldKey serverName = new StringFieldKey("serverName");
        public static final UInt63FieldKey created = new UInt63FieldKey("created");
        public static final UInt63FieldKey queuedEnded = new UInt63FieldKey("queuedEnded");
        public static final UInt63FieldKey ended = new UInt63FieldKey("ended");
        public static final UInt31FieldKey discardedSpanCount = new UInt31FieldKey("discardedSpanCount");
        public static final StringFieldKey hostThreadName = new StringFieldKey("hostThreadName");
        public static final UInt31FieldKey totalSpanCount = new UInt31FieldKey("totalSpanCount");
    }

    public static class Trace2ThreadFielder
    extends BaseDatabeanFielder<Trace2ThreadKey, Trace2Thread> {
        public Trace2ThreadFielder() {
            super(Trace2ThreadKey.class);
            this.addOption((FielderConfigValue)Trace2.TTL_FIELDER_CONFIG);
        }

        public List<Field<?>> getNonKeyFields(Trace2Thread traceThread) {
            return List.of(new UInt63Field(FieldKeys.parentThreadId, traceThread.parentThreadId), new StringField(FieldKeys.name, traceThread.name), new StringField(FieldKeys.info, traceThread.info), new StringField(FieldKeys.serverName, traceThread.serverName), new UInt63Field(FieldKeys.created, traceThread.created), new UInt63Field(FieldKeys.queuedEnded, traceThread.queuedEnded), new UInt63Field(FieldKeys.ended, traceThread.ended), new UInt31Field(FieldKeys.discardedSpanCount, traceThread.discardedSpanCount), new StringField(FieldKeys.hostThreadName, traceThread.hostThreadName), new UInt31Field(FieldKeys.totalSpanCount, traceThread.totalSpanCount));
        }
    }
}

