/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage.trace;

import io.datarouter.instrumentation.trace.TraceDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.positive.UInt31Field;
import io.datarouter.model.field.imp.positive.UInt31FieldKey;
import io.datarouter.model.field.imp.positive.UInt63Field;
import io.datarouter.model.field.imp.positive.UInt63FieldKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.model.serialize.fielder.Fielder;
import io.datarouter.trace.storage.entity.BaseTraceEntityKey;
import io.datarouter.trace.storage.trace.BaseTraceKey;
import io.datarouter.util.string.StringTool;
import java.util.List;

public abstract class BaseTrace<EK extends BaseTraceEntityKey<EK>, PK extends BaseTraceKey<EK, PK>, D extends BaseTrace<EK, PK, D>>
extends BaseDatabean<PK, D> {
    protected String context;
    protected String type;
    protected String params;
    protected Long created;
    protected Long duration;
    protected Integer discardedThreadCount;

    public BaseTrace(PK key) {
        super(key);
    }

    public BaseTrace(PK key, TraceDto dto) {
        super(key);
        this.context = StringTool.trimToSize((String)dto.getContext(), (int)FieldKeys.context.getSize());
        this.type = StringTool.trimToSize((String)dto.getType(), (int)FieldKeys.type.getSize());
        this.params = StringTool.trimToSize((String)dto.getParams(), (int)FieldKeys.params.getSize());
        this.created = dto.getCreated();
        this.duration = dto.getDuration();
        this.discardedThreadCount = dto.getDiscardedThreadCount();
    }

    public TraceDto toDto() {
        return new TraceDto(this.getTraceId(), this.getContext(), this.getType(), this.getParams(), this.getCreated(), this.getDuration(), this.getDiscardedThreadCount());
    }

    public String getTraceId() {
        return ((BaseTraceEntityKey)((Object)((BaseTraceKey)this.getKey()).getEntityKey())).getTraceEntityId();
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Integer getDiscardedThreadCount() {
        return this.discardedThreadCount;
    }

    public void setDiscardedThreadCount(Integer discardedThreadCount) {
        this.discardedThreadCount = discardedThreadCount;
    }

    public static class BaseTraceFielder<EK extends BaseTraceEntityKey<EK>, PK extends BaseTraceKey<EK, PK>, D extends BaseTrace<EK, PK, D>>
    extends BaseDatabeanFielder<PK, D> {
        public BaseTraceFielder(Class<? extends Fielder<PK>> primaryKeyFielderClass) {
            super(primaryKeyFielderClass);
        }

        public List<Field<?>> getNonKeyFields(D databean) {
            return List.of(new StringField(FieldKeys.context, ((BaseTrace)((Object)databean)).getContext()), new StringField(FieldKeys.type, ((BaseTrace)((Object)databean)).getType()), new StringField(FieldKeys.params, ((BaseTrace)((Object)databean)).getParams()), new UInt63Field(FieldKeys.created, ((BaseTrace)((Object)databean)).getCreated()), new UInt63Field(FieldKeys.duration, ((BaseTrace)((Object)databean)).getDuration()), new UInt31Field(FieldKeys.discardedThreadCount, ((BaseTrace)((Object)databean)).getDiscardedThreadCount()));
        }
    }

    public static class FieldKeys {
        public static final StringFieldKey context = new StringFieldKey("context");
        public static final StringFieldKey type = new StringFieldKey("type");
        public static final StringFieldKey params = new StringFieldKey("params");
        public static final UInt63FieldKey created = new UInt63FieldKey("created");
        public static final UInt63FieldKey duration = new UInt63FieldKey("duration");
        public static final UInt31FieldKey discardedThreadCount = new UInt31FieldKey("discardedThreadCount");
    }
}

