/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage.trace;

import io.datarouter.instrumentation.trace.TraceDto;
import io.datarouter.model.serialize.fielder.FielderConfigValue;
import io.datarouter.model.serialize.fielder.TtlFielderConfig;
import io.datarouter.trace.storage.entity.TraceEntityKey;
import io.datarouter.trace.storage.trace.BaseTrace;
import io.datarouter.trace.storage.trace.TraceKey;
import java.time.Duration;

public class Trace
extends BaseTrace<TraceEntityKey, TraceKey, Trace> {
    public static final Duration TTL = Duration.ofDays(30L);
    public static final TtlFielderConfig TTL_FIELDER_CONFIG = new TtlFielderConfig(TTL);

    public Trace() {
        super(new TraceKey());
    }

    public Trace(String traceId) {
        super(new TraceKey(traceId));
    }

    public Trace(TraceDto dto) {
        super(new TraceKey(dto.getTraceId()), dto);
    }

    public Class<TraceKey> getKeyClass() {
        return TraceKey.class;
    }

    @Override
    public TraceDto toDto() {
        return new TraceDto(this.getTraceId(), this.getContext(), this.getType(), this.getParams(), this.getCreated(), this.getDuration(), this.getDiscardedThreadCount());
    }

    public static class TraceFielder
    extends BaseTrace.BaseTraceFielder<TraceEntityKey, TraceKey, Trace> {
        public TraceFielder() {
            super(TraceKey.class);
            this.addOption((FielderConfigValue)TTL_FIELDER_CONFIG);
        }
    }
}

