/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage.trace;

import io.datarouter.instrumentation.trace.Trace2Dto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.positive.UInt31Field;
import io.datarouter.model.field.imp.positive.UInt31FieldKey;
import io.datarouter.model.field.imp.positive.UInt63Field;
import io.datarouter.model.field.imp.positive.UInt63FieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.model.serialize.fielder.FielderConfigValue;
import io.datarouter.model.serialize.fielder.TtlFielderConfig;
import io.datarouter.trace.storage.trace.Trace2Key;
import java.time.Duration;
import java.util.List;

public class Trace2
extends BaseDatabean<Trace2Key, Trace2> {
    public static final Duration TTL = Duration.ofDays(30L);
    public static final TtlFielderConfig TTL_FIELDER_CONFIG = new TtlFielderConfig(TTL);
    public static final String DEFAULT_ACCOUNT_NAME = "default";
    private String initialParentId;
    private String context;
    private String type;
    private String params;
    private Long created;
    private Long ended;
    private String accountName;
    private String serviceName;
    private Integer discardedThreadCount;
    private Integer totalThreadCount;

    public Trace2() {
        this(new Trace2Key());
    }

    public Trace2(Trace2Key key) {
        super((PrimaryKey)key);
    }

    public Trace2(String accountName, Trace2Dto dto) {
        super((PrimaryKey)new Trace2Key(dto.traceparent));
        this.initialParentId = dto.initialParentId;
        this.context = dto.context;
        this.type = dto.type;
        this.params = dto.params;
        this.created = dto.created;
        this.ended = dto.ended;
        this.serviceName = dto.serviceName;
        this.accountName = accountName;
        this.discardedThreadCount = dto.discardedThreadCount;
        this.totalThreadCount = dto.totalThreadCount;
    }

    public Class<Trace2Key> getKeyClass() {
        return Trace2Key.class;
    }

    public String getTraceId() {
        return ((Trace2Key)this.getKey()).getEntityKey().getTrace2EntityId();
    }

    public String getParentId() {
        return ((Trace2Key)this.getKey()).getParentId();
    }

    public String getInitialParentId() {
        return this.initialParentId;
    }

    public String getParams() {
        return this.params;
    }

    public String getContext() {
        return this.context;
    }

    public String getType() {
        return this.type;
    }

    public Long getCreated() {
        return this.created;
    }

    public Long getEnded() {
        return this.ended;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public Integer getDiscardedThreadCount() {
        return this.discardedThreadCount;
    }

    public Integer getTotalThreadCount() {
        return this.totalThreadCount;
    }

    public static class FieldKeys {
        public static final StringFieldKey initialParentId = new StringFieldKey("initialParentId");
        public static final StringFieldKey context = new StringFieldKey("context");
        public static final StringFieldKey type = new StringFieldKey("type");
        public static final StringFieldKey params = new StringFieldKey("params");
        public static final UInt63FieldKey created = new UInt63FieldKey("created");
        public static final UInt63FieldKey ended = new UInt63FieldKey("ended");
        public static final StringFieldKey accountName = new StringFieldKey("accountName");
        public static final StringFieldKey serviceName = new StringFieldKey("serviceName");
        public static final UInt31FieldKey discardedThreadCount = new UInt31FieldKey("discardedThreadCount");
        public static final UInt31FieldKey totalThreadCount = new UInt31FieldKey("totalThreadCount");
    }

    public static class Trace2Fielder
    extends BaseDatabeanFielder<Trace2Key, Trace2> {
        public Trace2Fielder() {
            super(Trace2Key.class);
            this.addOption((FielderConfigValue)TTL_FIELDER_CONFIG);
        }

        public List<Field<?>> getNonKeyFields(Trace2 databean) {
            return List.of(new StringField(FieldKeys.initialParentId, databean.initialParentId), new StringField(FieldKeys.context, databean.context), new StringField(FieldKeys.type, databean.type), new StringField(FieldKeys.params, databean.params), new UInt63Field(FieldKeys.created, databean.created), new UInt63Field(FieldKeys.ended, databean.ended), new StringField(FieldKeys.accountName, databean.accountName), new StringField(FieldKeys.serviceName, databean.serviceName), new UInt31Field(FieldKeys.discardedThreadCount, databean.discardedThreadCount), new UInt31Field(FieldKeys.totalThreadCount, databean.totalThreadCount));
        }
    }
}

