/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.storage.trace;

import io.datarouter.trace.storage.entity.BaseTraceEntityKey;
import io.datarouter.trace.storage.span.BaseTraceSpan;
import io.datarouter.trace.storage.span.BaseTraceSpanKey;
import io.datarouter.trace.storage.thread.BaseTraceThreadKey;
import io.datarouter.trace.web.AccessException;
import io.datarouter.util.UlidTool;
import io.datarouter.util.duration.DatarouterDuration;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;

public class TraceTool {
    public static <EK extends BaseTraceEntityKey<EK>, PK extends BaseTraceSpanKey<EK, PK>, TK extends BaseTraceThreadKey<EK, TK>, D extends BaseTraceSpan<EK, PK, TK, D>> Long totalDurationOfNonChildren(Collection<D> spans) {
        return spans.stream().filter(BaseTraceSpan::isTopLevel).mapToLong(BaseTraceSpan::getDuration).sum();
    }

    public static AccessException makeException(String traceId) {
        Instant traceInstant;
        try {
            traceInstant = UlidTool.getInstant((String)traceId);
        }
        catch (RuntimeException e) {
            return new AccessException(e.getMessage());
        }
        Duration duration = Duration.between(traceInstant, Instant.now());
        String durationStr = new DatarouterDuration(duration).toString();
        return new AccessException("not found (" + durationStr + " old)");
    }
}

