/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.web;

import io.datarouter.instrumentation.trace.Trace2Dto;
import io.datarouter.instrumentation.trace.TraceDto;
import io.datarouter.instrumentation.trace.TraceThreadDto;
import io.datarouter.pathnode.PathNode;
import io.datarouter.scanner.Scanner;
import io.datarouter.trace.storage.entity.UiTraceBundleDto;
import io.datarouter.trace.storage.span.BaseTraceSpan;
import io.datarouter.trace.storage.thread.BaseTraceThread;
import io.datarouter.trace.storage.trace.BaseTrace;
import io.datarouter.trace.web.AccessException;
import io.datarouter.trace.web.TraceThreadGroup;
import io.datarouter.util.DateTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletRequest;

public abstract class BaseTraceHandler
extends BaseHandler {
    @Inject
    private CurrentUserSessionInfoService currentUserSessionInfoService;

    protected Mav initMav(String traceId) {
        return new Mav(this.getViewTraceJsp());
    }

    @BaseHandler.Handler(defaultHandler=true)
    protected Mav viewTrace(OptionalString id) {
        UiTraceBundleDto traceEnity;
        Optional traceId = id.map(this::trimId);
        Mav mav = this.initMav(traceId.orElse(null));
        if (traceId.isEmpty()) {
            return mav;
        }
        try {
            traceEnity = this.getTrace((String)traceId.get());
        }
        catch (AccessException e) {
            mav.put("errorMessage", (Object)e.getMessage());
            return mav;
        }
        mav.put("trace", (Object)this.toJspDto(traceEnity.trace, this.currentUserSessionInfoService.getZoneId((ServletRequest)this.request)));
        List threads = Scanner.of(traceEnity.threads).map(BaseTraceThread::toDto).list();
        if (threads.isEmpty()) {
            return new MessageMav("no threads found (yet)");
        }
        Integer discardedThreadCount = traceEnity.trace.getDiscardedThreadCount();
        Integer discardedSpanCount = this.getDiscardedSpanCountFromThreads(threads);
        TraceThreadGroup rootGroup = TraceThreadGroup.create(threads, this.makeFakeRootThread(traceEnity.trace.toDto()));
        List spans = Scanner.of(traceEnity.spans).map(BaseTraceSpan::toDto).list();
        rootGroup.setSpans(spans);
        mav.put("spans", (Object)spans);
        mav.put("numSpans", (Object)spans.size());
        mav.put("numDiscardedSpans", (Object)discardedSpanCount);
        mav.put("numDiscardedThreads", (Object)discardedThreadCount);
        mav.put("threadGroup", (Object)rootGroup);
        mav.put("threadGroupHtml", (Object)rootGroup.getHtml());
        return mav;
    }

    private String trimId(String traceId) {
        if (StringTool.containsCaseInsensitive((String)traceId, (String)"=")) {
            return StringTool.getStringAfterLastOccurrence((char)'=', (String)traceId);
        }
        return traceId;
    }

    private TraceThreadDto makeFakeRootThread(TraceDto trace) {
        return new TraceThreadDto(trace.getTraceId(), Long.valueOf(0L), null, "Fake root thread", null, null, trace.getCreatedMs(), Long.valueOf(0L), Long.valueOf(0L), Integer.valueOf(0), null);
    }

    private Integer getDiscardedSpanCountFromThreads(Collection<TraceThreadDto> threads) {
        return threads.stream().filter(thread -> thread.getDiscardedSpanCount() != null).mapToInt(TraceThreadDto::getDiscardedSpanCount).sum();
    }

    protected abstract PathNode getViewTraceJsp();

    protected abstract UiTraceBundleDto getTrace(String var1) throws AccessException;

    protected TraceJspDto toJspDto(BaseTrace<?, ?, ?> trace, ZoneId zoneId) {
        return new TraceJspDto(trace.getType(), trace.getParams(), trace.getCreated(), trace.getDuration(), zoneId);
    }

    public static class TraceJspDto {
        private final String type;
        private final String params;
        private final Long created;
        private final Long duration;
        private final ZoneId zoneId;

        public TraceJspDto(String type, String params, Long created, Long duration, ZoneId zoneId) {
            this.created = created;
            this.type = type;
            this.params = params;
            this.duration = duration;
            this.zoneId = zoneId;
        }

        public Long getDurationMs() {
            return Trace2Dto.convertToMsFromNsIfNecessary((long)this.duration, (long)this.created);
        }

        public Long getCreatedMs() {
            return Trace2Dto.convertToMsFromNsIfNecessary((long)this.created, (long)this.created);
        }

        public String getTime() {
            Date date = new Date(this.getCreatedMs());
            return DateTool.formatDateWithZone((Date)date, (ZoneId)this.zoneId);
        }

        public String getRequestString() {
            return String.valueOf(this.type) + Optional.ofNullable(this.params).map(params -> "?" + params).orElse("");
        }
    }
}

