/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.web;

import io.datarouter.instrumentation.trace.TraceSpanDto;
import io.datarouter.instrumentation.trace.TraceThreadDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.string.StringTool;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceThreadGroup {
    private static final Logger logger = LoggerFactory.getLogger(TraceThreadGroup.class);
    private TraceThreadDto thread;
    private TraceThreadGroup parent;
    private SortedSet<TraceThreadGroup> children = new TreeSet<TraceThreadGroup>(Comparator.comparing(ttg -> ttg.thread.getRunningDuration()).thenComparing(Comparator.comparing(ttg -> ttg.thread.getThreadId())));
    private SortedMap<TraceThreadDto, SortedSet<TraceSpanDto>> spansByThreadKey;

    public TraceThreadGroup(TraceThreadDto thread) {
        this.thread = thread;
    }

    public Long getGroupId() {
        return this.thread.getThreadId();
    }

    public void setSpans(Collection<TraceSpanDto> spans) {
        this.spansByThreadKey = this.getSpansByThreadKey(spans);
    }

    public boolean attemptToAddThread(TraceThreadDto newThread) {
        if (this.thread.getThreadId() == newThread.getParentId()) {
            TraceThreadGroup childGroup = new TraceThreadGroup(newThread);
            childGroup.parent = this;
            this.children.add(childGroup);
            return true;
        }
        for (TraceThreadGroup child : this.children) {
            if (child.attemptToAddThread(newThread)) {
                return true;
            }
            logger.warn("{}", (Object)newThread.getParentId());
        }
        return false;
    }

    public boolean isRoot() {
        return this.thread.getParentId() == null;
    }

    public int numNestedLevels() {
        TraceThreadGroup treeClimber = this;
        int branchesClimbed = 0;
        while (!treeClimber.isRoot()) {
            treeClimber = treeClimber.parent;
            ++branchesClimbed;
        }
        return branchesClimbed;
    }

    public List<TraceThreadDto> getOrderedThreads() {
        ArrayList<TraceThreadDto> outs = new ArrayList<TraceThreadDto>();
        this.appendGroup(outs, this);
        return outs;
    }

    private void appendGroup(List<TraceThreadDto> outs, TraceThreadGroup group) {
        outs.add(group.thread);
        for (TraceThreadGroup child : group.children) {
            this.appendGroup(outs, child);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringTool.repeat((String)"-", (int)this.numNestedLevels()));
        sb.append(this.thread.getName());
        sb.append(this.children);
        return sb.toString();
    }

    public String getHtml() {
        StringBuilder sb = new StringBuilder();
        this.appendThreadGroupHtml(sb, this, 0);
        return sb.toString();
    }

    public int getNumThreads() {
        return this.children.stream().mapToInt(TraceThreadGroup::getNumThreads).sum() + 1;
    }

    private void appendThreadGroupHtml(StringBuilder sb, TraceThreadGroup group, int leafNum) {
        this.appendLeafThreadHtml(sb, group.thread, leafNum);
        int childNumZeroBased = 0;
        for (TraceThreadGroup child : group.children) {
            this.appendThreadGroupHtml(sb, child, childNumZeroBased);
            ++childNumZeroBased;
        }
    }

    private void appendLeafThreadHtml(StringBuilder sb, TraceThreadDto thread, int leafNum) {
        sb.append("<table style=\"width: 100%;\" class=\"table border\">");
        ContainerTag tr = (ContainerTag)TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)(String.valueOf(leafNum) + ") " + thread.getName() + " " + thread.getHostThreadName())), TagCreator.td((String)(String.valueOf(NumberFormatter.addCommas((Number)thread.getTotalDurationMs())) + "ms")).withStyle("text-align: right;")}).withStyle("font-weight: bold;");
        sb.append(tr.render());
        if (StringTool.notEmpty((String)thread.getInfo())) {
            ContainerTag div = (ContainerTag)((ContainerTag)TagCreator.div((String)thread.getInfo()).withClass("threadInfo")).withStyle("margin:0px 0px 0px 40px; font-weight:normal;");
            sb.append(div.render());
        }
        Set spans = this.spansByThreadKey == null ? Collections.emptySet() : (Set)this.spansByThreadKey.getOrDefault(thread, new TreeSet());
        Map spanByParentSequenceId = Scanner.of(spans).groupBy(TraceSpanDto::getParentSequenceOrMinusOne);
        sb.append((CharSequence)TraceThreadGroup.buildSubSpans(new TimeDto(thread), (List)spanByParentSequenceId.get(-1), spanByParentSequenceId, 0));
        sb.append("</table>");
    }

    private static StringBuilder buildSubSpans(TimeDto parentSpan, List<TraceSpanDto> spans, Map<Integer, List<TraceSpanDto>> spanByParentSequenceId, int indentation) {
        StringBuilder sb = new StringBuilder();
        if (spans == null) {
            return sb;
        }
        if (parentSpan.queued > 0L) {
            ContainerTag tr = TagCreator.tr((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{TraceThreadGroup.makeFirstCell(parentSpan.queued, "in queue", indentation).toString(), TagCreator.td()})});
            sb.append(tr.render());
        }
        Long prevEnd = null;
        for (TraceSpanDto span : spans) {
            long interspanDuration;
            if (prevEnd == null) {
                prevEnd = parentSpan.created + parentSpan.queued;
            }
            if ((interspanDuration = span.getCreatedMs() - prevEnd) > 0L) {
                ContainerTag tr = (ContainerTag)TagCreator.tr((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{TraceThreadGroup.makeFirstCell(interspanDuration, "", indentation).toString(), TagCreator.td()})}).withStyle("background-color:#f9f9f9");
                sb.append(tr.render());
            }
            String info = Optional.ofNullable(span.getInfo()).orElse("");
            ContainerTag tr = TagCreator.tr((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{TraceThreadGroup.makeFirstCell(span.getDurationMs(), span.getName(), indentation).toString(), TagCreator.td((String)info)})});
            sb.append(tr.render());
            TimeDto dto = new TimeDto(span);
            sb.append((CharSequence)TraceThreadGroup.buildSubSpans(dto, spanByParentSequenceId.get(span.getSequence()), spanByParentSequenceId, indentation + 1));
            prevEnd = span.getCreatedMs() + span.getDurationMs();
        }
        long lastInterspanDuration = parentSpan.created + parentSpan.duration - prevEnd;
        if (lastInterspanDuration > 0L) {
            ContainerTag tr = (ContainerTag)TagCreator.tr((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{TraceThreadGroup.makeFirstCell(lastInterspanDuration, null, indentation).toString(), TagCreator.td()})}).withStyle("background-color:#f9f9f9");
            sb.append(tr.render());
        }
        return sb;
    }

    private static StringBuilder makeFirstCell(long durationMs, String name, int indentation) {
        StringBuilder sb = new StringBuilder().append("<td style=\"white-space: nowrap;\">");
        int i = 0;
        while (i < indentation) {
            ContainerTag span = (ContainerTag)TagCreator.span((DomContent[])new DomContent[]{TagCreator.rawHtml((String)"&nbsp")}).withStyle("border-right:solid 0px grey;margin-left:20px;margin-right:9px;display:inline-block;");
            sb.append(span.render());
            ++i;
        }
        ContainerTag span = (ContainerTag)TagCreator.span((String)(String.valueOf(NumberFormatter.addCommas((Number)durationMs)) + " ms")).withStyle("width:80px; display:inline-block;");
        return sb.append(span.render()).append(name).append("</td>");
    }

    public static TraceThreadGroup create(Collection<TraceThreadDto> threads, TraceThreadDto fakeThread) {
        TraceThreadGroup rootGroup = null;
        for (TraceThreadDto thread : threads) {
            if (rootGroup == null) {
                if (thread.getParentId() != null) {
                    thread = fakeThread;
                }
                rootGroup = new TraceThreadGroup(thread);
                continue;
            }
            rootGroup.attemptToAddThread(thread);
        }
        return rootGroup;
    }

    public SortedMap<TraceThreadDto, SortedSet<TraceSpanDto>> getSpansByThreadKey(Collection<TraceSpanDto> spans) {
        TreeMap<TraceThreadDto, SortedSet<TraceSpanDto>> out = new TreeMap<TraceThreadDto, SortedSet<TraceSpanDto>>(Comparator.comparing(TraceThreadDto::getThreadId));
        for (TraceSpanDto span : spans) {
            TraceThreadDto threadKey = new TraceThreadDto(span.getTraceId(), span.getThreadId(), null, null, null, null, null);
            if (out.get(threadKey) == null) {
                out.put(threadKey, new TreeSet<TraceSpanDto>(Comparator.comparing(TraceSpanDto::getSequence)));
            }
            ((SortedSet)out.get(threadKey)).add(span);
        }
        return out;
    }

    private static class TimeDto {
        private final long created;
        private final long queued;
        private final long duration;

        public TimeDto(TraceSpanDto span) {
            this.created = span.getCreatedMs();
            this.queued = 0L;
            this.duration = span.getDurationMs();
        }

        public TimeDto(TraceThreadDto thread) {
            this.created = thread.getCreatedMs();
            this.queued = thread.getQueuedDurationMs();
            this.duration = thread.getTotalDurationMs();
        }
    }
}

