/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance;

import io.datarouter.instrumentation.response.PublishingResponseDto;
import io.datarouter.instrumentation.webappinstance.WebappInstancePublisher;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.web.listener.DatarouterAppListener;
import io.datarouter.webappinstance.config.DatarouterWebappInstanceSettingRoot;
import io.datarouter.webappinstance.service.WebappInstanceService;
import io.datarouter.webappinstance.storage.webappinstance.DatarouterWebappInstanceDao;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstanceKey;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WebappInstanceAppListener
implements DatarouterAppListener {
    private static final Logger logger = LoggerFactory.getLogger(WebappInstanceAppListener.class);
    @Inject
    private DatarouterWebappInstanceDao dao;
    @Inject
    private WebappInstanceService service;
    @Inject
    private WebappInstancePublisher publisher;
    @Inject
    private DatarouterWebappInstanceSettingRoot settings;
    @Inject
    private ServerTypeDetector serverTypeDetector;

    public void onStartUp() {
        try {
            this.service.updateWebappInstanceTable();
        }
        catch (Exception e) {
            logger.info("on start up {}", (Object)e.getMessage());
        }
    }

    public void onShutDown() {
        WebappInstanceKey key = this.service.buildCurrentWebappInstanceKey();
        this.dao.delete(key);
        if (!((Boolean)this.settings.webappInstancePublisher.get()).booleanValue()) {
            logger.warn("WebappInstancePublisher is disabled on client");
            return;
        }
        try {
            logger.info("external webapp deregistration start");
            PublishingResponseDto response = this.publisher.delete(key.getWebappName(), key.getServerName());
            if (!response.success.booleanValue()) {
                logger.warn("error on webapp deregistration. message={}", (Object)response.message);
            } else {
                logger.warn("external webapp deregistration complete");
            }
        }
        catch (Exception e) {
            if (this.serverTypeDetector.mightBeDevelopment()) {
                logger.info("", (Throwable)e);
            }
            logger.warn("", (Throwable)e);
        }
    }
}

