/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance.job;

import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.job.BaseJob;
import io.datarouter.storage.config.DatarouterAdministratorEmailService;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.duration.DatarouterDuration;
import io.datarouter.util.time.DurationTool;
import io.datarouter.util.tuple.Twin;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.html.email.J2HtmlDatarouterEmailBuilder;
import io.datarouter.web.html.email.J2HtmlEmailTable;
import io.datarouter.webappinstance.config.DatarouterWebappInstancePaths;
import io.datarouter.webappinstance.config.DatarouterWebappInstanceSettingRoot;
import io.datarouter.webappinstance.service.WebappInstanceService;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstanceKey;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;

public class WebappInstanceAlertJob
extends BaseJob {
    @Inject
    private WebappInstanceService webappInstanceService;
    @Inject
    private DatarouterWebappInstanceSettingRoot settings;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterAdministratorEmailService additionalAdministratorEmailService;
    @Inject
    private DatarouterWebappInstancePaths paths;

    public void run(TaskTracker tracker) {
        WebappInstance webappInstance = this.webappInstanceService.buildCurrentWebappInstance();
        Date buildDate = webappInstance.getBuildDate();
        long staleRunningTimeMs = DurationTool.sinceDate((Date)buildDate).toMillis() - ((DatarouterDuration)this.settings.staleWebappInstanceThreshold.get()).toJavaDuration().toMillis();
        if (staleRunningTimeMs > 0L) {
            this.sendEmail(webappInstance);
        }
    }

    private void sendEmail(WebappInstance webappInstance) {
        String from = this.datarouterProperties.getAdministratorEmail();
        String to = this.additionalAdministratorEmailService.getAdministratorEmailAddressesCsv();
        String primaryHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.datarouter.webappInstances).build();
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject("Datarouter - Stale Webapp - " + ((WebappInstanceKey)webappInstance.getKey()).getServerName()).withTitle("Stale Webapp").withTitleHref(primaryHref).withContent(WebappInstanceAlertJob.makeContent(webappInstance));
        this.htmlEmailService.trySendJ2Html(from, to, emailBuilder);
    }

    private static ContainerTag makeContent(WebappInstance webappInstance) {
        List<Twin> rows = List.of(new Twin((Object)"webapp", (Object)((WebappInstanceKey)webappInstance.getKey()).getWebappName()), new Twin((Object)"build date", (Object)("" + webappInstance.getBuildDate())), new Twin((Object)"startup date", (Object)("" + webappInstance.getStartupDate())), new Twin((Object)"commitId", (Object)webappInstance.getCommitId()));
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> WebappInstanceAlertJob.makeDivBoldRight((String)row.getLeft()))).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn(null, row -> TagCreator.text((String)((String)row.getRight())))).build(rows);
    }

    private static DomContent makeDivBoldRight(String text) {
        return TagCreator.div((String)text).withStyle("font-weight:bold;text-align:right;");
    }
}

