/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance.service;

import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.cached.Cached;
import io.datarouter.web.app.WebappName;
import io.datarouter.webappinstance.storage.webappinstance.BaseWebappInstanceKey;
import io.datarouter.webappinstance.storage.webappinstance.DatarouterWebappInstanceDao;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CachedWebappInstancesOfThisServerType
extends Cached<List<WebappInstance>> {
    private static final Duration HEARTBEAT_WITHIN = Duration.ofMinutes(3L);
    private final DatarouterProperties datarouterProperties;
    private final WebappName webappName;
    private final DatarouterWebappInstanceDao webappInstanceDao;

    @Inject
    public CachedWebappInstancesOfThisServerType(DatarouterProperties datarouterProperties, WebappName webappName, DatarouterWebappInstanceDao webappInstanceDao) {
        super(20L, TimeUnit.SECONDS);
        this.datarouterProperties = datarouterProperties;
        this.webappName = webappName;
        this.webappInstanceDao = webappInstanceDao;
    }

    public List<String> getSortedServerNamesForThisWebApp() {
        return this.getSortedServerNamesForWebAppName(this.webappName.getName());
    }

    public List<String> getSortedServerNamesForWebAppName(String webappName) {
        return ((List)this.get()).stream().map(BaseDatabean::getKey).filter(key -> key.getWebappName().equals(webappName)).map(BaseWebappInstanceKey::getServerName).sorted().collect(Collectors.toList());
    }

    protected List<WebappInstance> reload() {
        return this.webappInstanceDao.getWebappInstancesOfServerType(this.datarouterProperties.getServerType(), HEARTBEAT_WITHIN);
    }
}

