/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance.service;

import io.datarouter.util.lang.ObjectTool;
import io.datarouter.web.exception.InvalidCredentialsException;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.GlobalRedirectMav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.user.authenticate.DatarouterTokenGenerator;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.webappinstance.config.DatarouterWebappInstancePaths;
import io.datarouter.webappinstance.storage.onetimelogintoken.DatarouterOneTimeLoginTokenDao;
import io.datarouter.webappinstance.storage.onetimelogintoken.OneTimeLoginToken;
import io.datarouter.webappinstance.storage.onetimelogintoken.OneTimeLoginTokenKey;
import io.datarouter.webappinstance.storage.webappinstance.DatarouterWebappInstanceDao;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstanceKey;
import java.time.Instant;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class OneTimeLoginService {
    @Inject
    private DatarouterOneTimeLoginTokenDao oneTimeLoginDao;
    @Inject
    private DatarouterWebappInstanceDao webappInstanceDao;
    @Inject
    private DatarouterWebappInstancePaths paths;

    public Mav createToken(Session session, String webappName, String serverName, Boolean shouldUseIp, HttpServletRequest request) {
        ObjectTool.requireNonNulls((Object[])new Object[]{session, session.getUserId()});
        WebappInstance target = this.webappInstanceDao.get(new WebappInstanceKey(webappName, serverName));
        if (target == null) {
            return new MessageMav("specified web app instance does not exist: " + serverName);
        }
        String token = DatarouterTokenGenerator.generateRandomToken();
        Instant deadline = Instant.now().plusSeconds(5L);
        this.oneTimeLoginDao.put(new OneTimeLoginToken(session.getUserId(), token, serverName, target.getServerPublicIp(), Date.from(deadline)));
        GlobalRedirectMav mav = new GlobalRedirectMav(this.buildRedirectUrl(request, target, shouldUseIp), true);
        mav.put("userId", (Object)session.getUserId());
        mav.put("token", (Object)token);
        return mav;
    }

    private String buildRedirectUrl(HttpServletRequest request, WebappInstance target, Boolean shouldUseIp) {
        return request.getScheme() + "://" + (shouldUseIp != false ? target.getServerPublicIp() : ((WebappInstanceKey)target.getKey()).getServerName()) + ":" + request.getServerPort() + target.getServletContextPath() + this.paths.datarouter.webappInstances.toSlashedString();
    }

    public void validateToken(Long userIdParam, String tokenParam, String requestServerName) {
        boolean requestServerNameValid;
        OneTimeLoginToken authenticatedToken = this.getAuthenticatedToken(userIdParam);
        if (!tokenParam.equals(authenticatedToken.getToken())) {
            throw new InvalidCredentialsException("invalid one time token for user " + userIdParam);
        }
        boolean bl = requestServerNameValid = requestServerName.equals(authenticatedToken.getTargetServerName()) || requestServerName.equals(authenticatedToken.getTargetServerIp());
        if (!requestServerNameValid) {
            throw new InvalidCredentialsException("targetServerName mismatch: authenticated targetServerName=" + authenticatedToken.getTargetServerName() + ", actual serverName=" + requestServerName + " for user " + userIdParam);
        }
    }

    private OneTimeLoginToken getAuthenticatedToken(Long userId) {
        OneTimeLoginTokenKey key = new OneTimeLoginTokenKey(userId);
        OneTimeLoginToken authenticatedToken = this.oneTimeLoginDao.get(key);
        if (authenticatedToken == null) {
            throw new InvalidCredentialsException("No authenticated token exists for user " + userId);
        }
        this.oneTimeLoginDao.delete(key);
        if (new Date().after(authenticatedToken.getDeadline())) {
            throw new InvalidCredentialsException("expired one time token for user " + userId);
        }
        return authenticatedToken;
    }
}

