/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance.service;

import io.datarouter.instrumentation.count.Counters;
import io.datarouter.instrumentation.webappinstance.WebappInstanceDto;
import io.datarouter.instrumentation.webappinstance.WebappInstancePublisher;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.SystemTool;
import io.datarouter.web.app.WebappName;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.monitoring.BuildProperties;
import io.datarouter.web.monitoring.GitProperties;
import io.datarouter.webappinstance.config.DatarouterWebappInstanceSettingRoot;
import io.datarouter.webappinstance.storage.webappinstance.DatarouterWebappInstanceDao;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstanceKey;
import io.datarouter.webappinstance.storage.webappinstancelog.DatarouterWebappInstanceLogDao;
import io.datarouter.webappinstance.storage.webappinstancelog.WebappInstanceLog;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;

@Singleton
public class WebappInstanceService {
    private final DatarouterWebappInstanceDao webappInstanceDao;
    private final DatarouterWebappInstanceLogDao webappInstanceLogDao;
    private final WebappName webappName;
    private final GitProperties gitProperties;
    private final BuildProperties buildProperties;
    private final DatarouterProperties datarouterProperties;
    private final ServletContextSupplier servletContext;
    private final DatarouterWebappInstanceSettingRoot settings;
    private final WebappInstancePublisher webappInstancePublisher;
    private final Date startTime;

    @Inject
    public WebappInstanceService(DatarouterWebappInstanceDao webappInstanceDao, DatarouterWebappInstanceLogDao webappInstanceLogDao, WebappName webappName, GitProperties gitProperties, BuildProperties buildProperties, DatarouterProperties datarouterProperties, ServletContextSupplier servletContext, WebappInstancePublisher webappInstancePublisher, DatarouterWebappInstanceSettingRoot settings) {
        this.webappInstanceDao = webappInstanceDao;
        this.webappInstanceLogDao = webappInstanceLogDao;
        this.webappName = webappName;
        this.gitProperties = gitProperties;
        this.buildProperties = buildProperties;
        this.datarouterProperties = datarouterProperties;
        this.servletContext = servletContext;
        this.webappInstancePublisher = webappInstancePublisher;
        this.settings = settings;
        this.startTime = new Date(ManagementFactory.getRuntimeMXBean().getStartTime());
    }

    public List<WebappInstance> getAll() {
        return this.webappInstanceDao.scan().list();
    }

    public WebappInstance updateWebappInstanceTable() {
        String buildId = this.buildProperties.getBuildId();
        String commitId = this.gitProperties.getIdAbbrev().orElse("unknown");
        Counters.inc((String)("App heartbeat " + this.datarouterProperties.getServerTypeString()));
        Counters.inc((String)("App heartbeat type-build " + this.datarouterProperties.getServerTypeString() + " " + buildId));
        Counters.inc((String)("App heartbeat type-commit " + this.datarouterProperties.getServerTypeString() + " " + commitId));
        Counters.inc((String)("App heartbeat build " + buildId));
        Counters.inc((String)("App heartbeat commit " + commitId));
        WebappInstance webappInstance = this.buildCurrentWebappInstance();
        this.webappInstanceDao.put(webappInstance);
        this.webappInstanceLogDao.put(new WebappInstanceLog(webappInstance));
        if (((Boolean)this.settings.webappInstancePublisher.get()).booleanValue()) {
            WebappInstanceDto dto = webappInstance.toDto();
            this.webappInstancePublisher.add(dto);
        }
        return webappInstance;
    }

    public WebappInstance buildCurrentWebappInstance() {
        return new WebappInstance(this.webappName.getName(), this.datarouterProperties.getServerName(), this.datarouterProperties.getServerTypeString(), ((ServletContext)this.servletContext.get()).getContextPath(), this.datarouterProperties.getServerPublicIp(), this.datarouterProperties.getServerPrivateIp(), this.startTime, Date.from(this.gitProperties.getBuildTime().orElse(GitProperties.UNKNOWN_DATE)), this.buildProperties.getBuildId(), this.gitProperties.getIdAbbrev().orElse("unknown"), SystemTool.getJavaVersion(), ((ServletContext)this.servletContext.get()).getServerInfo(), this.gitProperties.getBranch().orElse("unknown"));
    }

    public WebappInstanceKey buildCurrentWebappInstanceKey() {
        return new WebappInstanceKey(this.webappName.getName(), this.datarouterProperties.getServerName());
    }
}

