/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance.storage.webappinstance;

import io.datarouter.instrumentation.webappinstance.WebappInstanceDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.model.serialize.fielder.Fielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.webappinstance.storage.webappinstance.BaseWebappInstanceKey;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class BaseWebappInstance<PK extends BaseWebappInstanceKey<PK>, D extends BaseWebappInstance<PK, D>>
extends BaseDatabean<PK, D> {
    private String serverType;
    private String servletContextPath;
    private String serverPublicIp;
    private String serverPrivateIp;
    private Date refreshedLast;
    private Date startupDate;
    private Date buildDate;
    private String buildId;
    private String commitId;
    private String javaVersion;
    private String servletContainerVersion;
    private String gitBranch;

    public BaseWebappInstance(PK key) {
        super(key);
    }

    public BaseWebappInstance(PK key, String serverType, String servletContextPath, String serverPublicIp, String serverPrivateIp, Date refreshedLast, Date startupDate, Date buildDate, String buildId, String commitId, String javaVersion, String servletContainerVersion, String gitBranch) {
        super(key);
        this.serverType = serverType;
        this.servletContextPath = servletContextPath;
        this.serverPublicIp = serverPublicIp;
        this.serverPrivateIp = serverPrivateIp;
        this.refreshedLast = refreshedLast;
        this.startupDate = startupDate;
        this.buildDate = buildDate;
        this.buildId = buildId;
        this.commitId = commitId;
        this.javaVersion = javaVersion;
        this.servletContainerVersion = servletContainerVersion;
        this.gitBranch = gitBranch;
    }

    public BaseWebappInstance(PK key, WebappInstanceDto dto) {
        this(key, dto.serverType, dto.servletContextPath, dto.serverPublicIp, dto.serverPrivateIp, dto.refreshedLast, dto.startupDate, dto.buildDate, dto.buildId, dto.commitId, dto.javaVersion, dto.servletContainerVersion, dto.gitBranch);
    }

    public WebappInstanceDto toDto() {
        return new WebappInstanceDto(((BaseWebappInstanceKey)this.getKey()).getWebappName(), ((BaseWebappInstanceKey)this.getKey()).getServerName(), this.getServerType(), this.getServletContextPath(), this.getServerPublicIp(), this.getServerPrivateIp(), this.getRefreshedLast(), this.getStartupDate(), this.getBuildDate(), this.getBuildId(), this.getCommitId(), this.getJavaVersion(), this.getServletContainerVersion(), this.getGitBranch());
    }

    public static Set<String> getUniqueServerNames(Iterable<WebappInstance> ins) {
        return (Set)Scanner.of(ins).map(BaseDatabean::getKey).map(BaseWebappInstanceKey::getServerName).collect(HashSet::new);
    }

    public Duration getDurationSinceLastUpdatedMs() {
        long nowMs = System.currentTimeMillis();
        long refreshedLastOrNowMs = this.refreshedLast == null ? nowMs : this.refreshedLast.getTime();
        return Duration.ofMillis(nowMs - refreshedLastOrNowMs);
    }

    public Instant getRefreshedLastInstant() {
        return Optional.ofNullable(this.refreshedLast).map(Date::getTime).map(Instant::ofEpochMilli).orElse(null);
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getServletContextPath() {
        return this.servletContextPath;
    }

    public Date getRefreshedLast() {
        return this.refreshedLast;
    }

    public String getServerPublicIp() {
        return this.serverPublicIp;
    }

    public String getServerPrivateIp() {
        return this.serverPrivateIp;
    }

    public Date getStartupDate() {
        return this.startupDate;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getServletContainerVersion() {
        return this.servletContainerVersion;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }

    public static abstract class BaseWebappInstanceFielder<PK extends BaseWebappInstanceKey<PK>, D extends BaseWebappInstance<PK, D>>
    extends BaseDatabeanFielder<PK, D> {
        public BaseWebappInstanceFielder(Class<? extends Fielder<PK>> primaryKeyFielderClass) {
            super(primaryKeyFielderClass);
        }

        public List<Field<?>> getNonKeyFields(D databean) {
            return List.of(new StringField(FieldKeys.serverType, ((BaseWebappInstance)((Object)databean)).getServerType()), new StringField(FieldKeys.servletContextPath, ((BaseWebappInstance)((Object)databean)).getServletContextPath()), new StringField(FieldKeys.serverPublicIp, ((BaseWebappInstance)((Object)databean)).getServerPublicIp()), new StringField(FieldKeys.serverPrivateIp, ((BaseWebappInstance)((Object)databean)).getServerPrivateIp()), new DateField(FieldKeys.refreshedLast, ((BaseWebappInstance)((Object)databean)).getRefreshedLast()), new DateField(FieldKeys.startupDate, ((BaseWebappInstance)((Object)databean)).getStartupDate()), new DateField(FieldKeys.buildDate, ((BaseWebappInstance)((Object)databean)).getBuildDate()), new StringField(FieldKeys.buildId, ((BaseWebappInstance)((Object)databean)).getBuildId()), new StringField(FieldKeys.commitId, ((BaseWebappInstance)((Object)databean)).getCommitId()), new StringField(FieldKeys.javaVersion, ((BaseWebappInstance)((Object)databean)).getJavaVersion()), new StringField(FieldKeys.servletContainerVersion, ((BaseWebappInstance)((Object)databean)).getServletContainerVersion()));
        }
    }

    public static class FieldKeys {
        public static final StringFieldKey serverType = new StringFieldKey("serverType");
        public static final StringFieldKey servletContextPath = new StringFieldKey("servletContextPath");
        public static final StringFieldKey serverPublicIp = new StringFieldKey("serverPublicIp");
        public static final StringFieldKey serverPrivateIp = new StringFieldKey("serverPrivateIp");
        public static final DateFieldKey refreshedLast = new DateFieldKey("refreshedLast");
        public static final DateFieldKey startupDate = new DateFieldKey("startupDate");
        public static final DateFieldKey buildDate = new DateFieldKey("buildDate");
        public static final StringFieldKey buildId = new StringFieldKey("buildId");
        public static final StringFieldKey commitId = new StringFieldKey("commitId");
        public static final StringFieldKey javaVersion = new StringFieldKey("javaVersion");
        public static final StringFieldKey servletContainerVersion = new StringFieldKey("servletContainerVersion");
        public static final StringFieldKey gitBranch = new StringFieldKey("gitBranch");
    }
}

