/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance.storage.webappinstance;

import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.util.DatabeanVacuum;
import io.datarouter.webappinstance.storage.webappinstance.BaseWebappInstance;
import io.datarouter.webappinstance.storage.webappinstance.BaseWebappInstanceKey;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstanceKey;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterWebappInstanceDao
extends BaseDao {
    private final SortedMapStorage<WebappInstanceKey, WebappInstance> node;

    @Inject
    public DatarouterWebappInstanceDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterWebappInstanceDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage)nodeFactory.create(params.clientId, WebappInstance::new, WebappInstance.WebappInstanceFielder::new).withIsSystemTable(true).buildAndRegister();
    }

    public Scanner<WebappInstanceKey> scanKeys() {
        return this.node.scanKeys();
    }

    public Scanner<WebappInstance> scan() {
        return this.node.scan();
    }

    public Scanner<WebappInstance> scanWithPrefix(WebappInstanceKey key) {
        return this.node.scanWithPrefix((PrimaryKey)key);
    }

    public void put(WebappInstance webappInstance) {
        this.node.put((Databean)webappInstance);
    }

    public void delete(WebappInstanceKey key) {
        this.node.delete((PrimaryKey)key);
    }

    public WebappInstance get(WebappInstanceKey key) {
        return (WebappInstance)this.node.get((PrimaryKey)key);
    }

    public List<String> getWebappInstanceServerNamesForWebapp(String webappName) {
        return this.node.scanWithPrefix((PrimaryKey)new WebappInstanceKey(webappName, null)).map(BaseDatabean::getKey).map(BaseWebappInstanceKey::getServerName).list();
    }

    public List<WebappInstance> getWebappInstancesOfServerType(ServerType type, Duration heartbeatWithin) {
        return this.getWebappInstancesWithServerTypeString(type.getPersistentString(), heartbeatWithin);
    }

    public List<WebappInstance> getWebappInstancesWithServerTypeString(String typeString, Duration heartbeatWithin) {
        return this.node.scan().include(webappInstance -> typeString.equals(webappInstance.getServerType())).include(webappInstance -> webappInstance.getDurationSinceLastUpdatedMs().compareTo(heartbeatWithin) < 0).list();
    }

    public List<WebappInstance> getWebappInstancesByServerType(ServerType serverType) {
        String serverTypeString = serverType.getPersistentString();
        return this.node.scan().include(webappInstance -> serverTypeString.equals(webappInstance.getServerType())).list();
    }

    public Map<String, String> getServerTypeByServerName() {
        return this.node.scan().toMap(app -> ((WebappInstanceKey)app.getKey()).getServerName(), BaseWebappInstance::getServerType);
    }

    public DatabeanVacuum<WebappInstanceKey, WebappInstance> makeVacuum() {
        Instant deleteBefore = Instant.now().minus(Duration.ofMinutes(20L));
        Predicate<WebappInstance> shouldDelete = databean -> databean.getRefreshedLast() == null || databean.getRefreshedLastInstant().isBefore(deleteBefore);
        return new DatabeanVacuum.DatabeanVacuumBuilder(this.node.scan(), shouldDelete, arg_0 -> this.node.deleteMulti(arg_0)).build();
    }

    public static class DatarouterWebappInstanceDaoParams
    extends BaseDaoParams {
        public DatarouterWebappInstanceDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

