/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance.storage.webappinstancelog;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.key.primary.RegularPrimaryKey;
import io.datarouter.model.key.primary.base.BaseRegularPrimaryKey;
import io.datarouter.webappinstance.storage.webappinstance.BaseWebappInstance;
import io.datarouter.webappinstance.storage.webappinstance.BaseWebappInstanceKey;
import java.util.Date;
import java.util.List;

public abstract class BaseWebappInstanceLogKey<PK extends RegularPrimaryKey<PK>>
extends BaseRegularPrimaryKey<PK> {
    private String webappName;
    private String serverName;
    private Date startupDate;
    private Date buildDate;

    public BaseWebappInstanceLogKey() {
    }

    public BaseWebappInstanceLogKey(String webappName, String serverName, Date startupDate, Date buildDate) {
        this.webappName = webappName;
        this.serverName = serverName;
        this.startupDate = startupDate;
        this.buildDate = buildDate;
    }

    public BaseWebappInstanceLogKey(BaseWebappInstance<?, ?> instance) {
        this.serverName = ((BaseWebappInstanceKey)instance.getKey()).getServerName();
        this.webappName = ((BaseWebappInstanceKey)instance.getKey()).getWebappName();
        this.startupDate = instance.getStartupDate();
        this.buildDate = instance.getBuildDate();
    }

    public List<Field<?>> getFields() {
        return List.of(new StringField(BaseWebappInstanceKey.FieldKeys.webappName, this.webappName), new StringField(BaseWebappInstanceKey.FieldKeys.serverName, this.serverName), new DateField(BaseWebappInstance.FieldKeys.startupDate, this.startupDate), new DateField(BaseWebappInstance.FieldKeys.buildDate, this.buildDate));
    }

    public String getWebappName() {
        return this.webappName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Date getStartupDate() {
        return this.startupDate;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }
}

