/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance.web;

import io.datarouter.scanner.Scanner;
import io.datarouter.util.DateTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.webappinstance.config.DatarouterWebappInstanceFiles;
import io.datarouter.webappinstance.config.DatarouterWebappInstancePaths;
import io.datarouter.webappinstance.service.OneTimeLoginService;
import io.datarouter.webappinstance.storage.webappinstance.BaseWebappInstance;
import io.datarouter.webappinstance.storage.webappinstance.DatarouterWebappInstanceDao;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstance;
import io.datarouter.webappinstance.storage.webappinstance.WebappInstanceKey;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class WebappInstanceHandler
extends BaseHandler {
    public static final String P_USER_ID = "userId";
    public static final String P_TOKEN = "token";
    public static final String P_USE_IP = "useIp";
    @Inject
    private DatarouterWebappInstancePaths paths;
    @Inject
    private DatarouterWebappInstanceDao dao;
    @Inject
    private OneTimeLoginService oneTimeLoginService;
    @Inject
    private DatarouterWebappInstanceFiles files;

    @BaseHandler.Handler(defaultHandler=true)
    protected Mav view() {
        Mav mav = new Mav(this.files.jsp.admin.datarouter.webappInstances.webappInstanceJsp);
        List webappInstances = this.dao.scan().sorted(Comparator.comparing(webappInstance -> ((WebappInstanceKey)webappInstance.getKey()).getServerName())).list();
        if (webappInstances.isEmpty()) {
            return mav;
        }
        Map<String, String> mostPopularCommitIdByWebapp = webappInstances.stream().collect(Collectors.groupingBy(instance -> ((WebappInstanceKey)instance.getKey()).getWebappName(), Collectors.collectingAndThen(Collectors.toList(), instances -> this.getMostCommonValue((List<WebappInstance>)instances, BaseWebappInstance::getCommitId))));
        UsageStatsJspDto webappStats = new UsageStatsJspDto(webappInstances, instance -> ((WebappInstanceKey)instance.getKey()).getWebappName());
        UsageStatsJspDto buildIdStats = new UsageStatsJspDto(webappInstances, BaseWebappInstance::getBuildId);
        UsageStatsJspDto commitIdStats = new UsageStatsJspDto(webappInstances, BaseWebappInstance::getCommitId);
        UsageStatsJspDto publicIpStats = new UsageStatsJspDto(webappInstances, BaseWebappInstance::getServerPublicIp);
        UsageStatsJspDto buildDateStats = new UsageStatsJspDto(webappInstances, BaseWebappInstance::getBuildDate);
        UsageStatsJspDto javaVersionStats = new UsageStatsJspDto(webappInstances, BaseWebappInstance::getJavaVersion);
        UsageStatsJspDto lastUpdatedStats = new UsageStatsJspDto(webappInstances, BaseWebappInstance::getRefreshedLast);
        UsageStatsJspDto servletVersionStats = new UsageStatsJspDto(webappInstances, BaseWebappInstance::getServletContainerVersion);
        List dtos = Scanner.of((Iterable)webappInstances).map(instance -> new WebappInstanceJspDto((WebappInstance)((Object)instance), !buildIdStats.getMostCommon().equals(instance.getBuildId()), !((String)mostPopularCommitIdByWebapp.get(((WebappInstanceKey)instance.getKey()).getWebappName())).equals(instance.getCommitId()), !javaVersionStats.getMostCommon().equals(instance.getJavaVersion()), !servletVersionStats.getMostCommon().equals(instance.getServletContainerVersion()))).list();
        mav.put("webappInstances", (Object)dtos);
        mav.put("webappStats", (Object)webappStats);
        mav.put("buildIdStats", (Object)buildIdStats);
        mav.put("commitIdStats", (Object)commitIdStats);
        mav.put("publicIpStats", (Object)publicIpStats);
        mav.put("buildDateStats", (Object)buildDateStats);
        mav.put("javaVersionStats", (Object)javaVersionStats);
        mav.put("lastUpdatedStats", (Object)lastUpdatedStats);
        mav.put("servletVersionStats", (Object)servletVersionStats);
        mav.put("uri", (Object)this.request.getRequestURI());
        mav.put("logPath", (Object)this.paths.datarouter.webappInstanceLog.toSlashedString());
        return mav;
    }

    @BaseHandler.Handler
    protected Mav instanceLogin(String webappName, String serverName) {
        Session session = this.getSessionInfo().getRequiredSession();
        Boolean shouldUseIp = this.params.optionalBoolean(P_USE_IP).orElse(false);
        return this.oneTimeLoginService.createToken(session, webappName, serverName, shouldUseIp, this.request);
    }

    private <T> T getMostCommonValue(List<WebappInstance> objects, Function<WebappInstance, T> mapper) {
        return (T)objects.stream().collect(Collectors.groupingBy(mapper, Collectors.counting())).entrySet().stream().reduce((entry1, entry2) -> (Long)entry1.getValue() > (Long)entry2.getValue() ? entry1 : entry2).map(Map.Entry::getKey).get();
    }

    public static class UsageEntry {
        private final Object key;
        private final float usagePercentage;

        public UsageEntry(Object key, float usagePercentage) {
            this.key = key;
            this.usagePercentage = usagePercentage;
        }

        public Object getKey() {
            return this.key;
        }

        public String getUsagePercentagePrintable() {
            return String.format("%.1f", Float.valueOf(this.usagePercentage));
        }
    }

    public static class UsageStatsJspDto {
        private final List<UsageEntry> usage;
        private final int uniqueCount;
        private final boolean allCommon;
        private final Object mostCommon;

        public <T> UsageStatsJspDto(List<T> instances, Function<T, ?> mapper) {
            Map frequency = instances.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            this.uniqueCount = frequency.size();
            this.allCommon = this.uniqueCount <= 1;
            this.mostCommon = frequency.entrySet().stream().reduce((one, two) -> (Long)one.getValue() > (Long)two.getValue() ? one : two).map(Map.Entry::getKey).orElse(null);
            this.usage = frequency.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(entry -> new UsageEntry(entry.getKey(), (float)((Long)entry.getValue()).longValue() / (float)instances.size() * 100.0f)).collect(Collectors.toList());
        }

        public int getUniqueCount() {
            return this.uniqueCount;
        }

        public boolean getAllCommon() {
            return this.allCommon;
        }

        public Object getMostCommon() {
            return this.mostCommon;
        }

        public String getUsageBreakdownHtml() {
            ContainerTag ul = TagCreator.ul();
            for (UsageEntry entry : this.usage) {
                ul.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.strong((String)(String.valueOf(entry.getUsagePercentagePrintable()) + '%')), TagCreator.text((String)(" - " + entry.key))}));
            }
            return ul.render();
        }
    }

    public static class WebappInstanceJspDto {
        private static final int STALE_WEBAPP_INSTANCE_DAYS = 1;
        private static final int OLD_WEBAPP_INSTANCE_DAYS = 4;
        private final String webappName;
        private final String serverName;
        private final String serverType;
        private final String servletContextPath;
        private final String serverPublicIp;
        private final String serverPrivateIp;
        private final Date refreshedLast;
        private final Date startupDate;
        private final Date buildDate;
        private final String buildId;
        private final boolean highlightBuildId;
        private final String commitId;
        private final boolean highlightCommitId;
        private final String javaVersion;
        private final boolean highlightJavaVersion;
        private final String servletContainerVersion;
        private final boolean highlightServletContainerVersion;

        public WebappInstanceJspDto(WebappInstance databean, boolean highlightBuildId, boolean highlightCommitId, boolean highlightJavaVersion, boolean highlightServletContainerVersion) {
            this(((WebappInstanceKey)databean.getKey()).getWebappName(), ((WebappInstanceKey)databean.getKey()).getServerName(), databean.getServerType(), databean.getServletContextPath(), databean.getServerPublicIp(), databean.getServerPrivateIp(), databean.getRefreshedLast(), databean.getStartupDate(), databean.getBuildDate(), databean.getBuildId(), highlightBuildId, databean.getCommitId(), highlightCommitId, databean.getJavaVersion(), highlightJavaVersion, databean.getServletContainerVersion(), highlightServletContainerVersion);
        }

        protected WebappInstanceJspDto(String webappName, String serverName, String serverType, String servletContextPath, String serverPublicIp, String serverPrivateIp, Date refreshedLast, Date startupDate, Date buildDate, String buildId, boolean highlightBuildId, String commitId, boolean highlightCommitId, String javaVersion, boolean highlightJavaVersion, String servletContainerVersion, boolean highlightServletContainerVersion) {
            this.webappName = webappName;
            this.serverName = serverName;
            this.serverType = serverType;
            this.servletContextPath = servletContextPath;
            this.serverPublicIp = serverPublicIp;
            this.serverPrivateIp = serverPrivateIp;
            this.refreshedLast = refreshedLast;
            this.startupDate = startupDate;
            this.buildDate = buildDate;
            this.buildId = buildId;
            this.highlightBuildId = highlightBuildId;
            this.commitId = commitId;
            this.highlightCommitId = highlightCommitId;
            this.javaVersion = javaVersion;
            this.highlightJavaVersion = highlightJavaVersion;
            this.servletContainerVersion = servletContainerVersion;
            this.highlightServletContainerVersion = highlightServletContainerVersion;
        }

        public String getLastUpdatedTimeAgoPrintable() {
            if (this.refreshedLast == null) {
                return "inactive";
            }
            return DateTool.getAgoString((Instant)this.refreshedLast.toInstant());
        }

        public String getStartupDatePrintable() {
            return DateTool.getDateTime((Date)this.startupDate);
        }

        public String getBuildDatePrintable() {
            return DateTool.getDateTime((Date)this.buildDate);
        }

        public String getUpTimePrintable() {
            return DateTool.getAgoString((Instant)this.startupDate.toInstant());
        }

        public String getBuildTimeAgoPrintable() {
            return DateTool.getAgoString((Instant)this.buildDate.toInstant());
        }

        public Duration getDurationSinceLastUpdated() {
            long nowMs = System.currentTimeMillis();
            long refreshedLastOrNowMs = this.refreshedLast == null ? nowMs : this.refreshedLast.getTime();
            return Duration.ofMillis(nowMs - refreshedLastOrNowMs);
        }

        public String getWebappName() {
            return this.webappName;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getServerType() {
            return this.serverType;
        }

        public String getServletContextPath() {
            return this.servletContextPath;
        }

        public Date getRefreshedLast() {
            return this.refreshedLast;
        }

        public boolean getHighlightRefreshedLast() {
            if (this.refreshedLast == null) {
                return false;
            }
            double secondsSinceLastRefresh = DateTool.getSecondsBetween((Date)this.refreshedLast, (Date)new Date());
            return secondsSinceLastRefresh > 21.0;
        }

        public String getServerPublicIp() {
            return this.serverPublicIp;
        }

        public String getServerPrivateIp() {
            return this.serverPrivateIp;
        }

        public Date getStartupDate() {
            return this.startupDate;
        }

        public Date getBuildDate() {
            return this.buildDate;
        }

        public String getBuildId() {
            return this.buildId;
        }

        public boolean getHighlightBuildId() {
            return this.highlightBuildId;
        }

        public String getCommitId() {
            return this.commitId;
        }

        public boolean getHighlightCommitId() {
            return this.highlightCommitId;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public boolean getHighlightJavaVersion() {
            return this.highlightJavaVersion;
        }

        public String getServletContainerVersion() {
            return this.servletContainerVersion;
        }

        public boolean getHighlightServletContainerVersion() {
            return this.highlightServletContainerVersion;
        }

        public boolean getStaleWebappInstance() {
            return DateTool.getDaysBetween((Date)this.buildDate, (Date)new Date()) > 1.0;
        }

        public boolean getOldWebappInstance() {
            return DateTool.getDaysBetween((Date)this.buildDate, (Date)new Date()) > 4.0;
        }
    }
}

