/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.webappinstance.web;

import io.datarouter.util.DateTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.webappinstance.config.DatarouterWebappInstanceFiles;
import io.datarouter.webappinstance.storage.webappinstancelog.DatarouterWebappInstanceLogDao;
import io.datarouter.webappinstance.storage.webappinstancelog.WebappInstanceLog;
import io.datarouter.webappinstance.storage.webappinstancelog.WebappInstanceLogKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;

public class WebappInstanceLogHandler
extends BaseHandler {
    @Inject
    private DatarouterWebappInstanceLogDao dao;
    @Inject
    private DatarouterWebappInstanceFiles files;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav viewLog(String webappName, String serverName) {
        Mav mav = new Mav(this.files.jsp.admin.datarouter.webappInstances.webappInstanceLogJsp);
        WebappInstanceLogKey prefix = new WebappInstanceLogKey(webappName, serverName, null, null);
        List logs = this.dao.scanWithPrefix(prefix).sorted(Comparator.comparing(log -> ((WebappInstanceLogKey)log.getKey()).getStartupDate(), Collections.reverseOrder())).list();
        int logCount = logs.size();
        ArrayList<WebappInstanceLogJspDto> logJspDtos = new ArrayList<WebappInstanceLogJspDto>(logCount);
        int i = 0;
        while (i < logCount) {
            Date fallbackRefreshedLast = i == 0 ? new Date() : ((WebappInstanceLogKey)((WebappInstanceLog)((Object)logs.get(i - 1))).getKey()).getStartupDate();
            logJspDtos.add(new WebappInstanceLogJspDto((WebappInstanceLog)((Object)logs.get(i)), fallbackRefreshedLast));
            ++i;
        }
        mav.put("logs", logJspDtos);
        return mav;
    }

    public static class WebappInstanceLogJspDto {
        private static final int LATEST_WEBAPP_INSTANCES = 1;
        private final String webappName;
        private final String serverName;
        private final Date startupDate;
        private final Date refreshedLast;
        private final Date buildDate;
        private final String buildId;
        private final String commitId;
        private final String javaVersion;
        private final String servletContainerVersion;

        public WebappInstanceLogJspDto(WebappInstanceLog log, Date fallbackRefreshedLast) {
            this(((WebappInstanceLogKey)log.getKey()).getWebappName(), ((WebappInstanceLogKey)log.getKey()).getServerName(), ((WebappInstanceLogKey)log.getKey()).getStartupDate(), ((WebappInstanceLogKey)log.getKey()).getBuildDate(), log.getRefreshedLast() == null ? fallbackRefreshedLast : log.getRefreshedLast(), log.getBuildId(), log.getCommitId(), log.getJavaVersion(), log.getServletContainerVersion());
        }

        protected WebappInstanceLogJspDto(String webappName, String serverName, Date startupDate, Date buildDate, Date refreshedLast, String buildId, String commitId, String javaVersion, String servletContainerVersion) {
            this.webappName = webappName;
            this.serverName = serverName;
            this.startupDate = startupDate;
            this.buildDate = buildDate;
            this.refreshedLast = refreshedLast;
            this.buildId = buildId;
            this.commitId = commitId;
            this.javaVersion = javaVersion;
            this.servletContainerVersion = servletContainerVersion;
        }

        public String getWebappName() {
            return this.webappName;
        }

        public String getServerName() {
            return this.serverName;
        }

        public Date getStartupDate() {
            return this.startupDate;
        }

        public Date getBuildDate() {
            return this.buildDate;
        }

        public Date getRefreshedLast() {
            return this.refreshedLast;
        }

        public String getStartupDatePrintable() {
            return DateTool.getAgoString((Instant)this.startupDate.toInstant());
        }

        public String getBuildDatePrintable() {
            return DateTool.getAgoString((Instant)this.buildDate.toInstant());
        }

        public String getBuildId() {
            return this.buildId;
        }

        public String getCommitId() {
            return this.commitId;
        }

        public boolean getLatest() {
            return DateTool.getDaysBetween((Date)this.buildDate, (Date)new Date()) < 1.0;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public String getServletContainerVersion() {
            return this.servletContainerVersion;
        }
    }
}

