/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.annotation.Immutable;
import io.debezium.bindings.kafka.KafkaDebeziumSinkRecord;
import io.debezium.connector.jdbc.JdbcSinkRecord;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.sink.SinkConnectorConfig;
import io.debezium.sink.filter.FieldFilterFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;

@Immutable
public class JdbcKafkaSinkRecord
extends KafkaDebeziumSinkRecord
implements JdbcSinkRecord {
    private final SinkConnectorConfig.PrimaryKeyMode primaryKeyMode;
    private final Set<String> primaryKeyFields;
    private final FieldFilterFactory.FieldNameFilter fieldsFilter;
    private final DatabaseDialect dialect;
    private final List<String> keyFieldNames = new ArrayList<String>();
    private final List<String> nonKeyFieldNames = new ArrayList<String>();
    private final Map<String, JdbcSinkRecord.FieldDescriptor> allFields = new LinkedHashMap<String, JdbcSinkRecord.FieldDescriptor>();
    private static final String CONNECT_TOPIC = "__connect_topic";
    private static final String CONNECT_PARTITION = "__connect_partition";
    private static final String CONNECT_OFFSET = "__connect_offset";

    public JdbcKafkaSinkRecord(SinkRecord record, SinkConnectorConfig.PrimaryKeyMode primaryKeyMode, Set<String> primaryKeyFields, FieldFilterFactory.FieldNameFilter fieldsFilter, DatabaseDialect dialect) {
        super(record);
        boolean truncated;
        Objects.requireNonNull(primaryKeyMode, "The primary key mode must be provided.");
        Objects.requireNonNull(record, "The sink record must be provided.");
        this.primaryKeyMode = primaryKeyMode;
        this.primaryKeyFields = primaryKeyFields;
        this.fieldsFilter = fieldsFilter;
        this.dialect = dialect;
        boolean flattened = this.isFlattened();
        boolean bl = truncated = !flattened && this.isTruncate();
        if (!truncated) {
            this.readSinkRecordKeyData(flattened);
            this.readSinkRecordNonKeyData(flattened);
        }
    }

    public List<String> keyFieldNames() {
        return this.keyFieldNames;
    }

    @Override
    public List<String> getNonKeyFieldNames() {
        return this.nonKeyFieldNames;
    }

    @Override
    public Map<String, JdbcSinkRecord.FieldDescriptor> allFields() {
        return this.allFields;
    }

    private void readSinkRecordKeyData(boolean flattened) {
        switch (this.primaryKeyMode) {
            case NONE: {
                break;
            }
            case KAFKA: {
                this.applyKafkaCoordinatesAsPrimaryKey();
                break;
            }
            case RECORD_KEY: {
                this.applyRecordKeyAsPrimaryKey();
                break;
            }
            case RECORD_HEADER: {
                this.applyRecordHeaderAsPrimaryKey();
                break;
            }
            case RECORD_VALUE: {
                this.applyRecordValueAsPrimaryKey(flattened);
                break;
            }
            default: {
                throw new ConnectException("Unexpected primary key mode: " + String.valueOf(this.primaryKeyMode));
            }
        }
    }

    private void readSinkRecordNonKeyData(boolean flattened) {
        Schema valueSchema = this.valueSchema();
        if (valueSchema != null) {
            if (flattened) {
                this.applyNonKeyFields(this.topicName(), valueSchema);
            } else {
                Field after = valueSchema.field("after");
                if (after == null) {
                    throw new ConnectException("Received an unexpected message type that does not have an 'after' Debezium block");
                }
                this.applyNonKeyFields(this.topicName(), after.schema());
            }
        }
    }

    private void applyKafkaCoordinatesAsPrimaryKey() {
        this.keyFieldNames.add(CONNECT_TOPIC);
        this.allFields.put(CONNECT_TOPIC, new JdbcSinkRecord.FieldDescriptor(Schema.STRING_SCHEMA, CONNECT_TOPIC, true, this.dialect));
        this.keyFieldNames.add(CONNECT_PARTITION);
        this.allFields.put(CONNECT_PARTITION, new JdbcSinkRecord.FieldDescriptor(Schema.INT32_SCHEMA, CONNECT_PARTITION, true, this.dialect));
        this.keyFieldNames.add(CONNECT_OFFSET);
        this.allFields.put(CONNECT_OFFSET, new JdbcSinkRecord.FieldDescriptor(Schema.INT64_SCHEMA, CONNECT_OFFSET, true, this.dialect));
    }

    private void applyRecordKeyAsPrimaryKey() {
        Schema keySchema = this.keySchema();
        if (keySchema == null) {
            throw new ConnectException("Configured primary key mode 'record_key' cannot have null schema");
        }
        if (keySchema.type().isPrimitive()) {
            this.applyPrimitiveRecordKeyAsPrimaryKey(keySchema);
        } else if (Schema.Type.STRUCT.equals((Object)keySchema.type())) {
            this.applyRecordKeyAsPrimaryKey(this.topicName(), keySchema);
        } else {
            throw new ConnectException("An unsupported record key schema type detected: " + String.valueOf(keySchema.type()));
        }
    }

    private void applyRecordHeaderAsPrimaryKey() {
        if (this.originalKafkaRecord.headers() == null || this.originalKafkaRecord.headers().isEmpty()) {
            throw new ConnectException("Configured primary key mode 'record_header' cannot have null or empty schema");
        }
        SchemaBuilder headerSchemaBuilder = SchemaBuilder.struct();
        this.originalKafkaRecord.headers().forEach(header -> headerSchemaBuilder.field(header.key(), header.schema()));
        Schema headerSchema = headerSchemaBuilder.build();
        this.applyRecordKeyAsPrimaryKey(this.topicName(), headerSchema);
    }

    private void applyRecordValueAsPrimaryKey(boolean flattened) {
        Schema valueSchema = this.valueSchema();
        if (valueSchema == null) {
            throw new ConnectException("Configured primary key mode 'record_value' cannot have null schema");
        }
        Stream<Object> recordFields = flattened ? this.valueSchema().fields().stream() : ((Struct)this.value()).getStruct("after").schema().fields().stream();
        if (!this.primaryKeyFields.isEmpty()) {
            recordFields = recordFields.filter(field -> this.primaryKeyFields.contains(field.name()));
        }
        recordFields.forEach(field -> this.addKeyField(this.topicName(), (Field)field));
    }

    private void applyPrimitiveRecordKeyAsPrimaryKey(Schema keySchema) {
        if (this.primaryKeyFields.isEmpty()) {
            throw new ConnectException("The primary.key.fields configuration must be specified when using a primitive key.");
        }
        this.addKeyField(this.primaryKeyFields.iterator().next(), keySchema);
    }

    private void applyRecordKeyAsPrimaryKey(String topic, Schema keySchema) {
        for (Field field : keySchema.fields()) {
            if (!this.primaryKeyFields.isEmpty() && !this.primaryKeyFields.contains(field.name())) continue;
            this.addKeyField(topic, field);
        }
    }

    private void addKeyField(String topic, Field field) {
        if (this.fieldsFilter.matches(topic, field.name())) {
            this.addKeyField(field.name(), field.schema());
        }
    }

    private void addKeyField(String name, Schema schema) {
        JdbcSinkRecord.FieldDescriptor fieldDescriptor = new JdbcSinkRecord.FieldDescriptor(schema, name, true, this.dialect);
        this.keyFieldNames.add(fieldDescriptor.getName());
        this.allFields.put(fieldDescriptor.getName(), fieldDescriptor);
    }

    private void applyNonKeyFields(String topic, Schema schema) {
        for (Field field : schema.fields()) {
            if (this.keyFieldNames.contains(field.name()) || !this.fieldsFilter.matches(topic, field.name())) continue;
            this.applyNonKeyField(field.name(), field.schema());
        }
    }

    private void applyNonKeyField(String name, Schema schema) {
        JdbcSinkRecord.FieldDescriptor fieldDescriptor = new JdbcSinkRecord.FieldDescriptor(schema, name, false, this.dialect);
        this.nonKeyFieldNames.add(fieldDescriptor.getName());
        this.allFields.put(fieldDescriptor.getName(), fieldDescriptor);
    }
}

