/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.jdbc.JdbcSinkConnectorTask;
import io.debezium.connector.jdbc.Module;
import io.debezium.connector.jdbc.naming.ColumnNamingStrategy;
import io.debezium.connector.jdbc.naming.DefaultColumnNamingStrategy;
import io.debezium.connector.jdbc.naming.TemporaryBackwardCompatibleCollectionNamingStrategyProxy;
import io.debezium.sink.SinkConnectorConfig;
import io.debezium.sink.filter.FieldFilterFactory;
import io.debezium.sink.naming.CollectionNamingStrategy;
import io.debezium.util.Strings;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.errors.ConnectException;
import org.hibernate.c3p0.internal.C3P0ConnectionProvider;
import org.hibernate.tool.schema.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSinkConnectorConfig
implements SinkConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSinkConnectorTask.class);
    private static final String HIBERNATE_PREFIX = "hibernate.";
    public static final String CONNECTION_PROVIDER = "connection.provider";
    public static final String CONNECTION_URL = "connection.url";
    public static final String CONNECTION_USER = "connection.username";
    public static final String CONNECTION_PASSWORD = "connection.password";
    public static final String CONNECTION_POOL_MIN_SIZE = "connection.pool.min_size";
    public static final String CONNECTION_POOL_MAX_SIZE = "connection.pool.max_size";
    public static final String CONNECTION_POOL_ACQUIRE_INCREMENT = "connection.pool.acquire_increment";
    public static final String CONNECTION_POOL_TIMEOUT = "connection.pool.timeout";
    public static final String INSERT_MODE = "insert.mode";
    public static final String TRUNCATE_ENABLED = "truncate.enabled";
    public static final String PRIMARY_KEY_FIELDS = "primary.key.fields";
    public static final String SCHEMA_EVOLUTION = "schema.evolution";
    public static final String QUOTE_IDENTIFIERS = "quote.identifiers";
    public static final String COLUMN_NAMING_STRATEGY = "column.naming.strategy";
    public static final String POSTGRES_POSTGIS_SCHEMA = "dialect.postgres.postgis.schema";
    public static final String SQLSERVER_IDENTITY_INSERT = "dialect.sqlserver.identity.insert";
    public static final String USE_REDUCTION_BUFFER = "use.reduction.buffer";
    public static final String FLUSH_MAX_RETRIES = "flush.max.retries";
    public static final String FLUSH_RETRY_DELAY_MS = "flush.retry.delay.ms";
    public static final Field CONNECTION_PROVIDER_FIELD = Field.create((String)"connection.provider").withDisplayName("Connection provider").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)0)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDefault(C3P0ConnectionProvider.class.getName()).withDescription("Fully qualified class name of the connection provider, defaults to " + C3P0ConnectionProvider.class.getName());
    public static final Field CONNECTION_URL_FIELD = Field.create((String)"connection.url").withDisplayName("Hostname").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).required().withDescription("Valid JDBC URL");
    public static final Field CONNECTION_USER_FIELD = Field.create((String)"connection.username").withDisplayName("User").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).required().withDescription("Name of the database user to be used when connecting to the connection.");
    public static final Field CONNECTION_PASSWORD_FIELD = Field.create((String)"connection.password").withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)3)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).required().withDescription("Password of the database user to be used when connecting to the connection.");
    public static final Field CONNECTION_POOL_MIN_SIZE_FIELD = Field.create((String)"connection.pool.min_size").withDisplayName("Connection pool minimum size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5).withDescription("Minimum number of connection in the connection pool");
    public static final Field CONNECTION_POOL_MAX_SIZE_FIELD = Field.create((String)"connection.pool.max_size").withDisplayName("Connection pool maximum size").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(32).withDescription("Maximum number of connection in the connection pool");
    public static final Field CONNECTION_POOL_ACQUIRE_INCREMENT_FIELD = Field.create((String)"connection.pool.acquire_increment").withDisplayName("Connection pool acquire increment").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)6)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(32).withDescription("Connection pool acquire increment");
    public static final Field CONNECTION_POOL_TIMEOUT_FIELD = Field.create((String)"connection.pool.timeout").withDisplayName("Connection pool timeout").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)7)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(1800).withDescription("Connection pool timeout");
    public static final Field INSERT_MODE_FIELD = Field.create((String)"insert.mode").withDisplayName("The insertion mode to use").withEnum(InsertMode.class, (Enum)InsertMode.INSERT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{JdbcSinkConnectorConfig::validateInsertMode}).withDescription("The insertion mode to use. 'insert' - the default mode, uses standard SQL insert statements; 'upsert' - uses upsert semantics for the database if its supported and requires setting primary.key.mode and primary.key.fields;'update' - uses update semantics for the database if its supported.");
    public static final Field DELETE_ENABLED_FIELD = SinkConnectorConfig.DELETE_ENABLED_FIELD.withValidation(new Field.Validator[]{JdbcSinkConnectorConfig::validateDeleteEnabled});
    public static final Field PRIMARY_KEY_FIELDS_FIELD = Field.create((String)"primary.key.fields").withDisplayName("Comma-separated list of primary key field names").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)5)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("A comma-separated list of primary key field names. This is interpreted differently depending on primary.key.mode.");
    public static final Field SCHEMA_EVOLUTION_FIELD = Field.create((String)"schema.evolution").withDisplayName("Controls how schema evolution is handled by the sink connector").withEnum(SchemaEvolutionMode.class, (Enum)SchemaEvolutionMode.NONE).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)7)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls how schema evolution is handled by the sink connector");
    public static final Field QUOTE_IDENTIFIERS_FIELD = Field.create((String)"quote.identifiers").withDisplayName("Controls whether table, column, or other identifiers are quoted").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)8)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("When enabled, table, column, and other identifiers are quoted based on the database dialect. When disabled, only explicit cases where the dialect requires quoting will be used, such as names starting with an underscore.");
    public static final Field COLUMN_NAMING_STRATEGY_FIELD = Field.create((String)"column.naming.strategy").withDisplayName("Name of the strategy class that implements the ColumnNamingStrategy interface").withType(ConfigDef.Type.CLASS).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDefault(DefaultColumnNamingStrategy.class.getName()).withDescription("Name of the strategy class that implements the ColumnNamingStrategy interface.");
    public static final Field POSTGRES_POSTGIS_SCHEMA_FIELD = Field.create((String)"dialect.postgres.postgis.schema").withDisplayName("Name of the schema where postgis extension is installed").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)3)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDefault("public").withDescription("Name of the schema where postgis extension is installed. Default is public");
    public static final Field SQLSERVER_IDENTITY_INSERT_FIELD = Field.create((String)"dialect.sqlserver.identity.insert").withDisplayName("Allowing to insert explicit value for identity column in table for SQLSERVER.").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Allowing to insert explicit value for identity column in table for SQLSERVER.");
    public static final Field FLUSH_MAX_RETRIES_FIELD = Field.create((String)"flush.max.retries").withDisplayName("Max retry count").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5).withDescription("Max retry count when fail to flush. In case of retriable exceptions, the flush will be retried for the defined max retry count. Default is 5.");
    public static final Field FLUSH_RETRY_DELAY_MS_FIELD = Field.create((String)"flush.retry.delay.ms").withDisplayName("Delay to retry flush").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)6)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(1000L).withDescription("Delay to retry when fail to flush");
    public static final Field USE_REDUCTION_BUFFER_FIELD = Field.create((String)"use.reduction.buffer").withDisplayName("Specifies whether to use the reduction buffer.").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withDescription("A reduction buffer consolidates the execution of SQL statements by primary key to reduce the SQL load on the target database. When set to false (the default), each incoming event is applied as a logical SQL change. When set to true, incoming events that refer to the same row will be reduced to a single logical change based on the most recent row state.");
    protected static final ConfigDefinition CONFIG_DEFINITION = ConfigDefinition.editor().connector(new Field[]{CONNECTION_URL_FIELD, CONNECTION_USER_FIELD, CONNECTION_PASSWORD_FIELD, CONNECTION_POOL_MIN_SIZE_FIELD, CONNECTION_POOL_MAX_SIZE_FIELD, CONNECTION_POOL_ACQUIRE_INCREMENT_FIELD, CONNECTION_POOL_TIMEOUT_FIELD, INSERT_MODE_FIELD, DELETE_ENABLED_FIELD, TRUNCATE_ENABLED_FIELD, COLLECTION_NAME_FORMAT_FIELD, PRIMARY_KEY_MODE_FIELD, PRIMARY_KEY_FIELDS_FIELD, SCHEMA_EVOLUTION_FIELD, QUOTE_IDENTIFIERS_FIELD, COLLECTION_NAMING_STRATEGY_FIELD, COLUMN_NAMING_STRATEGY_FIELD, USE_TIME_ZONE_FIELD, POSTGRES_POSTGIS_SCHEMA_FIELD, SQLSERVER_IDENTITY_INSERT_FIELD, BATCH_SIZE_FIELD, FIELD_INCLUDE_LIST_FIELD, FIELD_EXCLUDE_LIST_FIELD, FLUSH_MAX_RETRIES_FIELD, FLUSH_RETRY_DELAY_MS_FIELD}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final Configuration config;
    private final InsertMode insertMode;
    private final boolean deleteEnabled;
    private final boolean truncateEnabled;
    private final String collectionNameFormat;
    private final SinkConnectorConfig.PrimaryKeyMode primaryKeyMode;
    private final Set<String> primaryKeyFields;
    private final SchemaEvolutionMode schemaEvolutionMode;
    private final boolean quoteIdentifiers;
    private final CollectionNamingStrategy collectionNamingStrategy;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final String databaseTimezone;
    private final String postgresPostgisSchema;
    private final boolean sqlServerIdentityInsert;
    private final int flushMaxRetries;
    private final long flushRetryDelayMs;
    private final FieldFilterFactory.FieldNameFilter fieldsFilter;
    private final int batchSize;
    private final boolean useReductionBuffer;

    public JdbcSinkConnectorConfig(Map<String, String> props) {
        this.config = Configuration.from(props);
        this.insertMode = InsertMode.parse(this.config.getString(INSERT_MODE));
        this.deleteEnabled = this.config.getBoolean(DELETE_ENABLED_FIELD);
        this.truncateEnabled = this.config.getBoolean(TRUNCATE_ENABLED_FIELD);
        this.collectionNameFormat = this.config.getString(COLLECTION_NAME_FORMAT_FIELD);
        this.primaryKeyMode = SinkConnectorConfig.PrimaryKeyMode.parse((String)this.config.getString(PRIMARY_KEY_MODE_FIELD));
        this.primaryKeyFields = Strings.setOf((String)this.config.getString(PRIMARY_KEY_FIELDS_FIELD), String::new);
        this.schemaEvolutionMode = SchemaEvolutionMode.parse(this.config.getString(SCHEMA_EVOLUTION));
        this.quoteIdentifiers = this.config.getBoolean(QUOTE_IDENTIFIERS_FIELD);
        this.collectionNamingStrategy = new TemporaryBackwardCompatibleCollectionNamingStrategyProxy((CollectionNamingStrategy)this.config.getInstance(COLLECTION_NAMING_STRATEGY_FIELD, CollectionNamingStrategy.class), this);
        this.columnNamingStrategy = (ColumnNamingStrategy)this.config.getInstance(COLUMN_NAMING_STRATEGY_FIELD, ColumnNamingStrategy.class);
        this.databaseTimezone = this.config.getString(USE_TIME_ZONE_FIELD);
        this.postgresPostgisSchema = this.config.getString(POSTGRES_POSTGIS_SCHEMA_FIELD);
        this.sqlServerIdentityInsert = this.config.getBoolean(SQLSERVER_IDENTITY_INSERT_FIELD);
        this.batchSize = this.config.getInteger(BATCH_SIZE_FIELD);
        this.useReductionBuffer = this.config.getBoolean(USE_REDUCTION_BUFFER_FIELD);
        this.flushMaxRetries = this.config.getInteger(FLUSH_MAX_RETRIES_FIELD);
        this.flushRetryDelayMs = this.config.getLong(FLUSH_RETRY_DELAY_MS_FIELD);
        String fieldIncludeList = this.config.getString(FIELD_INCLUDE_LIST_FIELD);
        String fieldExcludeList = this.config.getString(FIELD_EXCLUDE_LIST_FIELD);
        this.fieldsFilter = FieldFilterFactory.createFieldFilter((String)fieldIncludeList, (String)fieldExcludeList);
    }

    public void validate() {
        if (!this.config.validateAndRecord((Iterable)ALL_FIELDS, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + this.getClass().getSimpleName() + "; check the logs for details");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting {} with configuration:", (Object)this.getClass().getSimpleName());
            this.config.withMaskedPasswords().forEach((propName, propValue) -> LOGGER.info("   {} = {}", propName, propValue));
        }
        String columnExcludeList = this.config.getString("field.exclude.list");
        String columnIncludeList = this.config.getString("field.include.list");
        if (!Strings.isNullOrEmpty((String)columnExcludeList) && !Strings.isNullOrEmpty((String)columnIncludeList)) {
            throw new ConnectException("Cannot define both column.exclude.list and column.include.list. Please specify only one.");
        }
    }

    public boolean validateAndRecord(Iterable<Field> fields, Consumer<String> problems) {
        return this.config.validateAndRecord(fields, problems);
    }

    protected static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public InsertMode getInsertMode() {
        return this.insertMode;
    }

    public boolean isDeleteEnabled() {
        return this.deleteEnabled;
    }

    public boolean isTruncateEnabled() {
        return this.truncateEnabled;
    }

    public String getCollectionNameFormat() {
        return this.collectionNameFormat;
    }

    public SinkConnectorConfig.PrimaryKeyMode getPrimaryKeyMode() {
        return this.primaryKeyMode;
    }

    public Set<String> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public SchemaEvolutionMode getSchemaEvolutionMode() {
        return this.schemaEvolutionMode;
    }

    public boolean isQuoteIdentifiers() {
        return this.quoteIdentifiers;
    }

    public boolean isSqlServerIdentityInsert() {
        return this.sqlServerIdentityInsert;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isUseReductionBuffer() {
        return this.useReductionBuffer;
    }

    public CollectionNamingStrategy getCollectionNamingStrategy() {
        return this.collectionNamingStrategy;
    }

    public FieldFilterFactory.FieldNameFilter getFieldFilter() {
        return this.fieldsFilter;
    }

    public ColumnNamingStrategy getColumnNamingStrategy() {
        return this.columnNamingStrategy;
    }

    public String useTimeZone() {
        return this.databaseTimezone;
    }

    public String getPostgresPostgisSchema() {
        return this.postgresPostgisSchema;
    }

    public int getFlushMaxRetries() {
        return this.flushMaxRetries;
    }

    public long getFlushRetryDelayMs() {
        return this.flushRetryDelayMs;
    }

    public org.hibernate.cfg.Configuration getHibernateConfiguration() {
        org.hibernate.cfg.Configuration hibernateConfig = new org.hibernate.cfg.Configuration();
        hibernateConfig.setProperty("hibernate.connection.provider_class", this.config.getString(CONNECTION_PROVIDER_FIELD));
        hibernateConfig.setProperty("jakarta.persistence.jdbc.url", this.config.getString(CONNECTION_URL_FIELD));
        hibernateConfig.setProperty("jakarta.persistence.jdbc.user", this.config.getString(CONNECTION_USER_FIELD));
        hibernateConfig.setProperty("jakarta.persistence.jdbc.password", this.config.getString(CONNECTION_PASSWORD_FIELD));
        hibernateConfig.setProperty("hibernate.c3p0.min_size", this.config.getString(CONNECTION_POOL_MIN_SIZE_FIELD));
        hibernateConfig.setProperty("hibernate.c3p0.max_size", this.config.getString(CONNECTION_POOL_MAX_SIZE_FIELD));
        hibernateConfig.setProperty("hibernate.c3p0.acquire_increment", this.config.getString(CONNECTION_POOL_ACQUIRE_INCREMENT_FIELD));
        hibernateConfig.setProperty("hibernate.globally_quoted_identifiers", Boolean.toString(this.config.getBoolean(QUOTE_IDENTIFIERS_FIELD)));
        hibernateConfig.setProperty("hibernate.jdbc.time_zone", this.useTimeZone());
        if (LOGGER.isDebugEnabled()) {
            hibernateConfig.setProperty("hibernate.show_sql", Boolean.toString(true));
        }
        this.config.subset(HIBERNATE_PREFIX, false).forEach((arg_0, arg_1) -> ((org.hibernate.cfg.Configuration)hibernateConfig).setProperty(arg_0, arg_1));
        hibernateConfig.setProperty("hibernate.hbm2ddl.auto", Action.NONE.getExternalJpaName());
        return hibernateConfig;
    }

    public String getConnectorName() {
        return Module.name();
    }

    private static int validateInsertMode(Configuration config, Field field, Field.ValidationOutput problems) {
        InsertMode insertMode = InsertMode.parse(config.getString(field));
        if (InsertMode.UPSERT.equals((Object)insertMode)) {
            if (!config.hasKey("primary.key.mode") && !config.hasKey(PRIMARY_KEY_FIELDS)) {
                LOGGER.error("When using UPSERT, please define '{}' and '{}'.", (Object)"primary.key.mode", (Object)PRIMARY_KEY_FIELDS);
                return 1;
            }
            if (!config.hasKey("primary.key.mode")) {
                LOGGER.error("When using UPSERT, please define '{}'.", (Object)"primary.key.mode");
                return 1;
            }
        }
        return 0;
    }

    private static int validateDeleteEnabled(Configuration config, Field field, Field.ValidationOutput problems) {
        SinkConnectorConfig.PrimaryKeyMode primaryKeyMode;
        if (config.getBoolean(field) && !SinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.equals((Object)(primaryKeyMode = SinkConnectorConfig.PrimaryKeyMode.parse((String)config.getString("primary.key.mode"))))) {
            LOGGER.error("When '{}' is set to 'true', the '{}' option must be set to '{}'.", new Object[]{"delete.enabled", "primary.key.mode", SinkConnectorConfig.PrimaryKeyMode.RECORD_KEY.getValue()});
            return 1;
        }
        return 0;
    }

    public static enum InsertMode implements EnumeratedValue
    {
        INSERT("insert"),
        UPSERT("upsert"),
        UPDATE("update");

        private final String mode;

        private InsertMode(String mode) {
            this.mode = mode;
        }

        public static InsertMode parse(String value) {
            for (InsertMode option : InsertMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return INSERT;
        }

        public String getValue() {
            return this.mode;
        }
    }

    public static enum SchemaEvolutionMode implements EnumeratedValue
    {
        NONE("none"),
        BASIC("basic");

        private final String mode;

        private SchemaEvolutionMode(String mode) {
            this.mode = mode;
        }

        public static SchemaEvolutionMode parse(String value) {
            for (SchemaEvolutionMode option : SchemaEvolutionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return NONE;
        }

        public String getValue() {
            return this.mode;
        }
    }
}

