/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.annotation.Immutable;
import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.Type;
import io.debezium.connector.jdbc.util.SchemaUtils;
import io.debezium.sink.DebeziumSinkRecord;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public interface JdbcSinkRecord
extends DebeziumSinkRecord {
    public List<String> getNonKeyFieldNames();

    public Map<String, FieldDescriptor> allFields();

    @Immutable
    public static class FieldDescriptor {
        private static final Logger LOGGER = LoggerFactory.getLogger(FieldDescriptor.class);
        private final Schema schema;
        private final String name;
        private final String columnName;
        private final boolean isKey;
        private final Type type;
        private final String typeName;
        private String queryBinding;

        protected FieldDescriptor(Schema schema, String name, boolean isKey, DatabaseDialect dialect) {
            this.schema = schema;
            this.isKey = isKey;
            this.type = dialect.getSchemaType(schema);
            this.typeName = this.type.getTypeName(dialect, schema, isKey);
            this.name = name;
            this.columnName = SchemaUtils.getSourceColumnName(schema).orElse(name);
            LOGGER.trace("Field [{}] with schema [{}]", (Object)this.name, (Object)schema.type());
            LOGGER.trace("    Type      : {}", (Object)this.type.getClass().getName());
            LOGGER.trace("    Type Name : {}", (Object)this.typeName);
            LOGGER.trace("    Optional  : {}", (Object)schema.isOptional());
            if (schema.parameters() != null && !schema.parameters().isEmpty()) {
                LOGGER.trace("    Parameters: {}", (Object)schema.parameters());
            }
            if (schema.defaultValue() != null) {
                LOGGER.trace("    Def. Value: {}", schema.defaultValue());
            }
        }

        public Schema getSchema() {
            return this.schema;
        }

        public String getName() {
            return this.name;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isKey() {
            return this.isKey;
        }

        public Type getType() {
            return this.type;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getQueryBinding(ColumnDescriptor column, Object value) {
            if (this.queryBinding == null) {
                this.queryBinding = this.type.getQueryBinding(column, this.schema, value);
            }
            return this.queryBinding;
        }

        public List<ValueBindDescriptor> bind(int startIndex, Object value) {
            return this.type.bind(startIndex, this.schema, value);
        }

        public String toString() {
            return "FieldDescriptor{schema=" + String.valueOf(this.schema) + ", name='" + this.name + "', key=" + this.isKey + ", typeName='" + this.typeName + "', type=" + String.valueOf(this.type) + ", columnName='" + this.columnName + "'}";
        }
    }
}

