/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.Buffer;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.JdbcSinkRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;

public class RecordBuffer
implements Buffer {
    private final JdbcSinkConnectorConfig connectorConfig;
    private Schema keySchema;
    private Schema valueSchema;
    private final ArrayList<JdbcSinkRecord> records = new ArrayList();

    public RecordBuffer(JdbcSinkConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    @Override
    public List<JdbcSinkRecord> add(JdbcSinkRecord record) {
        List<Object> flushed = new ArrayList();
        boolean isSchemaChanged = false;
        if (this.records.isEmpty()) {
            this.keySchema = record.keySchema();
            this.valueSchema = record.valueSchema();
        }
        if (!Objects.equals(this.keySchema, record.keySchema()) || !Objects.equals(this.valueSchema, record.valueSchema())) {
            this.keySchema = record.keySchema();
            this.valueSchema = record.valueSchema();
            flushed = this.flush();
            isSchemaChanged = true;
        }
        this.records.add(record);
        if (isSchemaChanged) {
            return flushed;
        }
        if (this.records.size() >= this.connectorConfig.getBatchSize()) {
            flushed = this.flush();
        }
        return flushed;
    }

    @Override
    public List<JdbcSinkRecord> flush() {
        ArrayList<JdbcSinkRecord> flushed = new ArrayList<JdbcSinkRecord>(this.records);
        this.records.clear();
        return flushed;
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }
}

