/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc;

import io.debezium.connector.jdbc.Buffer;
import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.JdbcSinkRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

public class ReducedRecordBuffer
implements Buffer {
    private final JdbcSinkConnectorConfig connectorConfig;
    private Schema keySchema;
    private Schema valueSchema;
    private final Map<Struct, JdbcSinkRecord> records = new HashMap<Struct, JdbcSinkRecord>();

    public ReducedRecordBuffer(JdbcSinkConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    @Override
    public List<JdbcSinkRecord> add(JdbcSinkRecord record) {
        Struct keyStruct;
        List<Object> flushed = new ArrayList();
        boolean isSchemaChanged = false;
        if (this.records.isEmpty()) {
            this.keySchema = record.keySchema();
            this.valueSchema = record.valueSchema();
        }
        if (!Objects.equals(this.keySchema, record.keySchema()) || !Objects.equals(this.valueSchema, record.valueSchema())) {
            this.keySchema = record.keySchema();
            this.valueSchema = record.valueSchema();
            flushed = this.flush();
            isSchemaChanged = true;
        }
        if ((keyStruct = record.getKeyStruct(this.connectorConfig.getPrimaryKeyMode())) == null) {
            throw new ConnectException("No struct-based primary key defined for record key/value, reduction buffer require struct based primary key");
        }
        this.records.put(keyStruct, record);
        if (isSchemaChanged) {
            return flushed;
        }
        if (this.records.size() >= this.connectorConfig.getBatchSize()) {
            flushed = this.flush();
        }
        return flushed;
    }

    @Override
    public List<JdbcSinkRecord> flush() {
        ArrayList<JdbcSinkRecord> flushed = new ArrayList<JdbcSinkRecord>(this.records.values());
        this.records.clear();
        return flushed;
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }
}

