/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.mysql;

import io.debezium.connector.jdbc.JdbcSinkConnectorConfig;
import io.debezium.connector.jdbc.JdbcSinkRecord;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.DatabaseDialectProvider;
import io.debezium.connector.jdbc.dialect.SqlStatementBuilder;
import io.debezium.connector.jdbc.dialect.mysql.MySqlDatabaseDialect;
import io.debezium.connector.jdbc.relational.TableDescriptor;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MariaDBDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDbDatabaseDialect
extends MySqlDatabaseDialect {
    private static final Logger LOGGER = LoggerFactory.getLogger(MariaDbDatabaseDialect.class);

    private MariaDbDatabaseDialect(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
        super(config, sessionFactory);
    }

    @Override
    public String getUpsertStatement(TableDescriptor table, JdbcSinkRecord record) {
        SqlStatementBuilder builder = new SqlStatementBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getQualifiedTableName(table.getId()));
        builder.append(" (");
        builder.appendLists(", ", record.keyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnNameFromField((String)name, record));
        builder.append(") VALUES (");
        builder.appendLists(", ", record.keyFieldNames(), record.getNonKeyFieldNames(), name -> this.columnQueryBindingFromField((String)name, table, record));
        builder.append(") ");
        List<String> updateColumnNames = record.getNonKeyFieldNames().isEmpty() ? record.keyFieldNames() : record.getNonKeyFieldNames();
        builder.append("ON DUPLICATE KEY UPDATE ");
        builder.appendList(",", updateColumnNames, name -> {
            String columnName = this.columnNameFromField((String)name, record);
            return columnName + "=VALUES(" + columnName + ")";
        });
        return builder.build();
    }

    public static class MariaDbDatabaseDialectProvider
    implements DatabaseDialectProvider {
        @Override
        public boolean supports(Dialect dialect) {
            return dialect instanceof MariaDBDialect;
        }

        @Override
        public Class<?> name() {
            return MariaDbDatabaseDialect.class;
        }

        @Override
        public DatabaseDialect instantiate(JdbcSinkConnectorConfig config, SessionFactory sessionFactory) {
            LOGGER.info("MariaDB Dialect instantiated.");
            return new MariaDbDatabaseDialect(config, sessionFactory);
        }
    }
}

