/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.dialect.postgres;

import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.dialect.postgres.HstoreConverter;
import io.debezium.connector.jdbc.relational.ColumnDescriptor;
import io.debezium.connector.jdbc.type.AbstractType;
import java.util.List;
import org.apache.kafka.connect.data.Schema;

class JsonType
extends AbstractType {
    public static final JsonType INSTANCE = new JsonType();

    JsonType() {
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.Json"};
    }

    @Override
    public String getQueryBinding(ColumnDescriptor column, Schema schema, Object value) {
        if (this.isHstore(schema)) {
            return "cast(? as hstore)";
        }
        return String.format("cast(? as %s)", this.isJsonb(schema) ? "jsonb" : "json");
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        return this.resolveType(schema);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (this.isHstore(schema)) {
            value = HstoreConverter.jsonToString((String)value);
        }
        return super.bind(index, schema, value);
    }

    private String resolveType(Schema schema) {
        return this.isHstore(schema) ? "hstore" : (this.isJsonb(schema) ? "jsonb" : "json");
    }

    private boolean isJsonb(Schema schema) {
        return "JSONB".equals(this.getSourceColumnType(schema).orElse("JSON"));
    }

    private boolean isHstore(Schema schema) {
        return "HSTORE".equals(this.getSourceColumnType(schema).orElse("JSON"));
    }
}

