/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.jdbc.type.debezium;

import io.debezium.connector.jdbc.ValueBindDescriptor;
import io.debezium.connector.jdbc.dialect.DatabaseDialect;
import io.debezium.connector.jdbc.type.AbstractType;
import io.debezium.data.VariableScaleDecimal;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

public class VariableScaleDecimalType
extends AbstractType {
    public static final VariableScaleDecimalType INSTANCE = new VariableScaleDecimalType();

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{"io.debezium.data.VariableScaleDecimal"};
    }

    @Override
    public String getTypeName(DatabaseDialect dialect, Schema schema, boolean key) {
        return dialect.getTypeName(8);
    }

    @Override
    public List<ValueBindDescriptor> bind(int index, Schema schema, Object value) {
        if (value == null) {
            return List.of(new ValueBindDescriptor(index, null));
        }
        if (value instanceof Struct) {
            Optional bigDecimalValue = VariableScaleDecimal.toLogical((Struct)((Struct)value)).getDecimalValue();
            return List.of(new ValueBindDescriptor(index, bigDecimalValue.orElseThrow()));
        }
        throw new ConnectException(String.format("Unexpected %s value '%s' with type '%s'", this.getClass().getSimpleName(), value, value.getClass().getName()));
    }
}

