/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DataType;
import io.debezium.relational.ddl.DataTypeParser;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import io.debezium.text.TokenStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

@NotThreadSafe
public class MySqlDdlParser
extends DdlParser {
    private static final String SERVER_CHARSET_NAME = "character_set_server";
    private final MySqlSystemVariables systemVariables = new MySqlSystemVariables();
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();

    public MySqlDdlParser() {
        super(";");
    }

    public MySqlDdlParser(boolean includeViews) {
        super(";", includeViews);
    }

    protected MySqlSystemVariables systemVariables() {
        return this.systemVariables;
    }

    protected void initializeDataTypes(DataTypeParser dataTypes) {
        dataTypes.register(-7, "BIT[(L)]");
        dataTypes.register(5, "TINYINT[(L)] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(5, "SMALLINT[(L)] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(4, "MEDIUMINT[(L)] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(4, "INT[(L)] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(4, "INTEGER[(L)] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(-5, "BIGINT[(L)] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(7, "REAL[(M[,D])] [UNSIGNED] [ZEROFILL]");
        dataTypes.register(8, "DOUBLE[(M[,D])] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(8, "DOUBLE PRECISION[(M[,D])] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(6, "FLOAT[(M[,D])] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(3, "DECIMAL[(M[,D])] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(3, "FIXED[(M[,D])] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(3, "DEC[(M[,D])] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(2, "NUMERIC[(M[,D])] [UNSIGNED|SIGNED] [ZEROFILL]");
        dataTypes.register(16, "BOOLEAN");
        dataTypes.register(16, "BOOL");
        dataTypes.register(91, "DATE");
        dataTypes.register(92, "TIME[(L)]");
        dataTypes.register(2014, "TIMESTAMP[(L)]");
        dataTypes.register(93, "DATETIME[(L)]");
        dataTypes.register(4, "YEAR[(2|4)]");
        dataTypes.register(-2, "CHAR[(L)] BINARY");
        dataTypes.register(-3, "VARCHAR(L) BINARY");
        dataTypes.register(-2, "BINARY[(L)]");
        dataTypes.register(12, "VARCHAR(L)");
        dataTypes.register(-9, "NVARCHAR(L)");
        dataTypes.register(-9, "NATIONAL VARCHAR(L)");
        dataTypes.register(-9, "NCHAR VARCHAR(L)");
        dataTypes.register(-9, "NATIONAL CHARACTER VARYING(L)");
        dataTypes.register(-9, "NATIONAL CHAR VARYING(L)");
        dataTypes.register(1, "CHAR[(L)]");
        dataTypes.register(-15, "NCHAR[(L)]");
        dataTypes.register(-15, "NATIONAL CHARACTER(L)");
        dataTypes.register(-3, "VARBINARY(L)");
        dataTypes.register(2004, "TINYBLOB");
        dataTypes.register(2004, "BLOB");
        dataTypes.register(2004, "MEDIUMBLOB");
        dataTypes.register(2004, "LONGBLOB");
        dataTypes.register(2004, "TINYTEXT BINARY");
        dataTypes.register(2004, "TEXT BINARY");
        dataTypes.register(2004, "MEDIUMTEXT BINARY");
        dataTypes.register(2004, "LONGTEXT BINARY");
        dataTypes.register(12, "TINYTEXT");
        dataTypes.register(12, "TEXT[(L)]");
        dataTypes.register(12, "MEDIUMTEXT");
        dataTypes.register(12, "LONGTEXT");
        dataTypes.register(1, "ENUM(...)");
        dataTypes.register(1, "SET(...)");
        dataTypes.register(1111, "JSON");
        dataTypes.register(1111, "GEOMETRY");
        dataTypes.register(1111, "POINT");
        dataTypes.register(1111, "LINESTRING");
        dataTypes.register(1111, "POLYGON");
        dataTypes.register(1111, "MULTIPOINT");
        dataTypes.register(1111, "MULTILINESTRING");
        dataTypes.register(1111, "MULTIPOLYGON");
        dataTypes.register(1111, "GEOMETRYCOLLECTION");
    }

    protected void initializeKeywords(DdlParser.TokenSet keywords) {
    }

    protected void initializeStatementStarts(DdlParser.TokenSet statementStartTokens) {
        statementStartTokens.add("CREATE", new String[]{"ALTER", "DROP", "GRANT", "REVOKE", "FLUSH", "TRUNCATE", "COMMIT", "USE", "SAVEPOINT", "ROLLBACK", "ANALYZE", "OPTIMIZE", "REPAIR", "DELETE", "INSERT"});
    }

    protected void parseNextStatement(TokenStream.Marker marker) {
        if (this.tokens.matches(32)) {
            this.parseComment(marker);
        } else if (this.tokens.matches("CREATE")) {
            this.parseCreate(marker);
        } else if (this.tokens.matches("ALTER")) {
            this.parseAlter(marker);
        } else if (this.tokens.matches("DROP")) {
            this.parseDrop(marker);
        } else if (this.tokens.matches("RENAME")) {
            this.parseRename(marker);
        } else if (this.tokens.matches("USE")) {
            this.parseUse(marker);
        } else if (this.tokens.matches("SET")) {
            this.parseSet(marker);
        } else if (this.tokens.matches("INSERT")) {
            this.consumeStatement();
        } else if (this.tokens.matches("DELETE")) {
            this.consumeStatement();
        } else {
            this.parseUnknownStatement(marker);
        }
    }

    protected void parseSet(TokenStream.Marker start) {
        this.tokens.consume("SET");
        AtomicReference<MySqlSystemVariables.Scope> scope = new AtomicReference<MySqlSystemVariables.Scope>();
        this.parseSetVariable(start, scope);
        while (this.tokens.canConsume(',')) {
            this.parseSetVariable(start, scope);
        }
        this.consumeRemainingStatement(start);
        this.debugParsed(start);
    }

    protected void parseSetVariable(TokenStream.Marker start, AtomicReference<MySqlSystemVariables.Scope> scope) {
        if (this.tokens.canConsume("GLOBAL") || this.tokens.canConsume("@@GLOBAL", new String[]{"."})) {
            scope.set(MySqlSystemVariables.Scope.GLOBAL);
        } else if (this.tokens.canConsume("SESSION") || this.tokens.canConsume("@@SESSION", new String[]{"."})) {
            scope.set(MySqlSystemVariables.Scope.SESSION);
        } else if (this.tokens.canConsume("LOCAL") || this.tokens.canConsume("@@LOCAL", new String[]{"."})) {
            scope.set(MySqlSystemVariables.Scope.LOCAL);
        }
        if (!this.tokens.canConsume("PASSWORD") && !this.tokens.canConsume("TRANSACTION", new String[]{"ISOLATION", "LEVEL"})) {
            if (this.tokens.canConsume("CHARACTER", new String[]{"SET"}) || this.tokens.canConsume("CHARSET")) {
                String charsetName = this.tokens.consume();
                if ("DEFAULT".equalsIgnoreCase(charsetName)) {
                    charsetName = this.currentDatabaseCharset();
                }
                this.systemVariables.setVariable(scope.get(), "character_set_client", charsetName);
                this.systemVariables.setVariable(scope.get(), "character_set_results", charsetName);
            } else if (this.tokens.canConsume("NAMES")) {
                String charsetName = this.tokens.consume();
                if ("DEFAULT".equalsIgnoreCase(charsetName)) {
                    charsetName = this.currentDatabaseCharset();
                }
                this.systemVariables.setVariable(scope.get(), "character_set_client", charsetName);
                this.systemVariables.setVariable(scope.get(), "character_set_results", charsetName);
                this.systemVariables.setVariable(scope.get(), "character_set_connection", charsetName);
                if (this.tokens.canConsume("COLLATION")) {
                    this.tokens.consume();
                }
            } else {
                String variableName = this.parseVariableName();
                this.tokens.canConsume(":");
                this.tokens.consume("=");
                String value = this.parseVariableValue();
                if (!variableName.startsWith("@")) {
                    String currentDatabaseName;
                    this.systemVariables.setVariable(scope.get(), variableName, value);
                    if ("character_set_database".equalsIgnoreCase(variableName) && (currentDatabaseName = this.currentSchema()) != null) {
                        this.charsetNameForDatabase.put(currentDatabaseName, value);
                    }
                    this.signalEvent((DdlParserListener.Event)new DdlParserListener.SetVariableEvent(variableName, value, this.statement(start)));
                }
            }
        }
    }

    protected String parseVariableName() {
        String variableName = this.tokens.consume();
        while (this.tokens.canConsume("-")) {
            variableName = variableName + "-" + this.tokens.consume();
        }
        return variableName;
    }

    protected String parseVariableValue() {
        if (this.tokens.canConsumeAnyOf(",", new String[]{";"})) {
            return "";
        }
        TokenStream.Marker start = this.tokens.mark();
        this.tokens.consumeUntilEndOrOneOf(new String[]{",", ";"});
        String value = this.tokens.getContentFrom(start);
        if (value.startsWith("'") && value.endsWith("'")) {
            value = value.length() <= 2 ? "" : value.substring(1, value.length() - 2);
        }
        return value;
    }

    protected void parseCreate(TokenStream.Marker marker) {
        this.tokens.consume("CREATE");
        if (this.tokens.matches("TABLE") || this.tokens.matches("TEMPORARY", new String[]{"TABLE"})) {
            this.parseCreateTable(marker);
        } else if (this.tokens.matches("VIEW")) {
            this.parseCreateView(marker);
        } else if (this.tokens.matchesAnyOf("DATABASE", new String[]{"SCHEMA"})) {
            this.parseCreateDatabase(marker);
        } else if (this.tokens.matchesAnyOf("EVENT", new String[0])) {
            this.parseCreateEvent(marker);
        } else if (this.tokens.matchesAnyOf("FUNCTION", new String[]{"PROCEDURE"})) {
            this.parseCreateProcedure(marker);
        } else if (this.tokens.matchesAnyOf("UNIQUE", new String[]{"FULLTEXT", "SPATIAL", "INDEX"})) {
            this.parseCreateIndex(marker);
        } else if (this.tokens.matchesAnyOf("SERVER", new String[0])) {
            this.parseCreateUnknown(marker);
        } else if (this.tokens.matchesAnyOf("TABLESPACE", new String[0])) {
            this.parseCreateUnknown(marker);
        } else if (this.tokens.matchesAnyOf("TRIGGER", new String[0])) {
            this.parseCreateTrigger(marker);
        } else {
            this.sequentially(this::parseCreateView, this::parseCreateProcedure, this::parseCreateTrigger, this::parseCreateEvent, this::parseCreateUnknown);
        }
    }

    protected void parseCreateDatabase(TokenStream.Marker start) {
        this.tokens.consumeAnyOf(new String[]{"DATABASE", "SCHEMA"});
        this.tokens.canConsume("IF", new String[]{"NOT", "EXISTS"});
        String dbName = this.tokens.consume();
        this.parseDatabaseOptions(start, dbName);
        this.consumeRemainingStatement(start);
        this.signalCreateDatabase(dbName, start);
        this.debugParsed(start);
    }

    protected void parseAlterDatabase(TokenStream.Marker start) {
        this.tokens.consumeAnyOf(new String[]{"DATABASE", "SCHEMA"});
        String dbName = this.tokens.consume();
        this.parseDatabaseOptions(start, dbName);
        this.consumeRemainingStatement(start);
        this.signalAlterDatabase(dbName, null, start);
        this.debugParsed(start);
    }

    protected void parseDropDatabase(TokenStream.Marker start) {
        this.tokens.consumeAnyOf(new String[]{"DATABASE", "SCHEMA"});
        this.tokens.canConsume("IF", new String[]{"EXISTS"});
        String dbName = this.tokens.consume();
        this.signalDropDatabase(dbName, start);
        this.debugParsed(start);
    }

    protected void parseDatabaseOptions(TokenStream.Marker start, String dbName) {
        this.tokens.canConsume("DEFAULT");
        if (this.tokens.canConsume("CHARACTER", new String[]{"SET"}) || this.tokens.canConsume("CHARSET")) {
            this.tokens.canConsume("=");
            String charsetName = this.tokens.consume();
            if ("DEFAULT".equalsIgnoreCase(charsetName)) {
                charsetName = this.systemVariables.getVariable(SERVER_CHARSET_NAME);
            }
            this.charsetNameForDatabase.put(dbName, charsetName);
        }
        if (this.tokens.canConsume("COLLATE")) {
            this.tokens.canConsume("=");
            this.tokens.consume();
        }
    }

    protected void parseCreateTable(TokenStream.Marker start) {
        this.tokens.canConsume("TEMPORARY");
        this.tokens.consume("TABLE");
        boolean onlyIfNotExists = this.tokens.canConsume("IF", new String[]{"NOT", "EXISTS"});
        TableId tableId = this.parseQualifiedTableName(start);
        if (this.tokens.canConsume("LIKE")) {
            TableId originalId = this.parseQualifiedTableName(start);
            Table original = this.databaseTables.forTable(originalId);
            if (original != null) {
                this.databaseTables.overwriteTable(tableId, original.columns(), original.primaryKeyColumnNames(), original.defaultCharsetName());
            }
            this.consumeRemainingStatement(start);
            this.signalCreateTable(tableId, start);
            this.debugParsed(start);
            return;
        }
        if (onlyIfNotExists && this.databaseTables.forTable(tableId) != null) {
            this.consumeRemainingStatement(start);
            this.signalCreateTable(tableId, start);
            this.debugParsed(start);
            return;
        }
        TableEditor table = this.databaseTables.editOrCreateTable(tableId);
        if (this.tokens.matches('(')) {
            this.parseCreateDefinitionList(start, table);
        }
        this.parseTableOptions(start, table);
        if (this.tokens.matches("PARTITION")) {
            this.parsePartitionOptions(start, table);
        }
        if (this.tokens.canConsume("AS") || this.tokens.canConsume("IGNORE", new String[]{"AS"}) || this.tokens.canConsume("REPLACE", new String[]{"AS"})) {
            this.parseAsSelectStatement(start, table);
        }
        if (!table.hasDefaultCharsetName()) {
            table.setDefaultCharsetName(this.currentDatabaseCharset());
        }
        this.databaseTables.overwriteTable(table.create());
        this.signalCreateTable(tableId, start);
        this.debugParsed(start);
    }

    protected void parseTableOptions(TokenStream.Marker start, TableEditor table) {
        while (this.parseTableOption(start, table)) {
        }
    }

    protected boolean parseTableOption(TokenStream.Marker start, TableEditor table) {
        if (this.tokens.canConsume("AUTO_INCREMENT")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsumeAnyOf("CHECKSUM", new String[]{"ENGINE", "AVG_ROW_LENGTH", "MAX_ROWS", "MIN_ROWS", "ROW_FORMAT", "DELAY_KEY_WRITE", "INSERT_METHOD", "KEY_BLOCK_SIZE", "PACK_KEYS", "STATS_AUTO_RECALC", "STATS_PERSISTENT", "STATS_SAMPLE_PAGES", "PAGE_CHECKSUM"})) {
            this.tokens.canConsume('=');
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsume("DEFAULT", new String[]{"CHARACTER", "SET"}) || this.tokens.canConsume("CHARACTER", new String[]{"SET"}) || this.tokens.canConsume("DEFAULT", new String[]{"CHARSET"}) || this.tokens.canConsume("CHARSET")) {
            this.tokens.canConsume('=');
            String charsetName = this.tokens.consume();
            if ("DEFAULT".equalsIgnoreCase(charsetName)) {
                charsetName = this.currentDatabaseCharset();
            }
            table.setDefaultCharsetName(charsetName);
            return true;
        }
        if (this.tokens.canConsume("DEFAULT", new String[]{"COLLATE"}) || this.tokens.canConsume("COLLATE")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsumeAnyOf("COMMENT", new String[]{"COMPRESSION", "CONNECTION", "ENCRYPTION", "PASSWORD"})) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
            return true;
        }
        if (this.tokens.canConsume("DATA", new String[]{"DIRECTORY"}) || this.tokens.canConsume("INDEX", new String[]{"DIRECTORY"})) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
            return true;
        }
        if (this.tokens.canConsume("TABLESPACE")) {
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsumeAnyOf("STORAGE", new String[]{"ENGINE"})) {
            this.tokens.consume();
            return true;
        }
        if (this.tokens.canConsume("UNION")) {
            this.tokens.canConsume('=');
            this.tokens.consume('(');
            this.tokens.consume();
            while (this.tokens.canConsume(',')) {
                this.tokens.consume();
            }
            this.tokens.consume(')');
            return true;
        }
        return false;
    }

    protected void parsePartitionOptions(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("PARTITION", new String[]{"BY"});
        if (this.tokens.canConsume("LINEAR", new String[]{"HASH"}) || this.tokens.canConsume("HASH")) {
            this.consumeExpression(start);
        } else if (this.tokens.canConsume("LINEAR", new String[]{"KEY"}) || this.tokens.canConsume("KEY")) {
            if (this.tokens.canConsume("ALGORITHM")) {
                this.tokens.consume("=");
                this.tokens.consumeAnyOf(new String[]{"1", "2"});
            }
            this.parseColumnNameList(start);
        } else if (this.tokens.canConsumeAnyOf("RANGE", new String[]{"LIST"})) {
            if (this.tokens.canConsume("COLUMNS")) {
                this.parseColumnNameList(start);
            } else {
                this.consumeExpression(start);
            }
        }
        if (this.tokens.canConsume("PARTITIONS")) {
            this.tokens.consume();
        }
        if (this.tokens.canConsume("SUBPARTITION", new String[]{"BY"})) {
            if (this.tokens.canConsume("LINEAR", new String[]{"HASH"}) || this.tokens.canConsume("HASH")) {
                this.consumeExpression(start);
            } else if (this.tokens.canConsume("LINEAR", new String[]{"KEY"}) || this.tokens.canConsume("KEY")) {
                if (this.tokens.canConsume("ALGORITHM")) {
                    this.tokens.consume("=");
                    this.tokens.consumeAnyOf(new String[]{"1", "2"});
                }
                this.parseColumnNameList(start);
            }
            if (this.tokens.canConsume("SUBPARTITIONS")) {
                this.tokens.consume();
            }
        }
        if (this.tokens.canConsume('(')) {
            do {
                this.parsePartitionDefinition(start, table);
            } while (this.tokens.canConsume(','));
            this.tokens.consume(')');
        }
    }

    protected void parsePartitionDefinition(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("PARTITION");
        this.tokens.consume();
        if (this.tokens.canConsume("VALUES")) {
            if (this.tokens.canConsume("LESS", new String[]{"THAN"})) {
                if (!this.tokens.canConsume("MAXVALUE")) {
                    this.consumeExpression(start);
                }
            } else {
                this.tokens.consume("IN");
                this.consumeValueList(start);
            }
        } else if (this.tokens.canConsume("STORAGE", new String[]{"ENGINE"}) || this.tokens.canConsume("ENGINE")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        } else if (this.tokens.canConsumeAnyOf("COMMENT", new String[0])) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
        } else if (this.tokens.canConsumeAnyOf("DATA", new String[]{"INDEX"}) && this.tokens.canConsume("DIRECTORY")) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
        } else if (this.tokens.canConsumeAnyOf("MAX_ROWS", new String[]{"MIN_ROWS", "TABLESPACE"})) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        } else if (this.tokens.canConsume('(')) {
            do {
                this.parseSubpartitionDefinition(start, table);
            } while (this.tokens.canConsume(','));
            this.tokens.consume(')');
        }
    }

    protected void parseSubpartitionDefinition(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("SUBPARTITION");
        this.tokens.consume();
        if (this.tokens.canConsume("STORAGE", new String[]{"ENGINE"}) || this.tokens.canConsume("ENGINE")) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        } else if (this.tokens.canConsumeAnyOf("COMMENT", new String[0])) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
        } else if (this.tokens.canConsumeAnyOf("DATA", new String[]{"INDEX"}) && this.tokens.canConsume("DIRECTORY")) {
            this.tokens.canConsume('=');
            this.consumeQuotedString();
        } else if (this.tokens.canConsumeAnyOf("MAX_ROWS", new String[]{"MIN_ROWS", "TABLESPACE"})) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        }
    }

    protected void parseAsSelectStatement(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume("SELECT");
        this.consumeRemainingStatement(start);
    }

    protected void parseCreateDefinitionList(TokenStream.Marker start, TableEditor table) {
        this.tokens.consume('(');
        this.parseCreateDefinition(start, table, false);
        while (this.tokens.canConsume(',')) {
            this.parseCreateDefinition(start, table, false);
        }
        this.tokens.consume(')');
    }

    protected void parseCreateDefinition(TokenStream.Marker start, TableEditor table, boolean isAlterStatement) {
        Collection errors = null;
        boolean quoted = this.isNextTokenQuotedIdentifier();
        TokenStream.Marker defnStart = this.tokens.mark();
        if (!quoted) {
            if (this.tokens.canConsume("CHECK")) {
                this.consumeExpression(start);
                return;
            }
            if (this.tokens.canConsume("CONSTRAINT", new String[]{"any value", "PRIMARY", "KEY"}) || this.tokens.canConsume("CONSTRAINT", new String[]{"PRIMARY", "KEY"}) || this.tokens.canConsume("PRIMARY", new String[]{"KEY"})) {
                try {
                    if (this.tokens.canConsume("USING")) {
                        this.parseIndexType(start);
                    }
                    if (!this.tokens.matches('(')) {
                        this.tokens.consume();
                    }
                    List<String> pkColumnNames = this.parseIndexColumnNames(start);
                    table.setPrimaryKeyNames(pkColumnNames);
                    this.parseIndexOptions(start);
                    pkColumnNames.forEach(name -> {
                        Column c = table.columnWithName(name);
                        if (c != null && c.isOptional()) {
                            table.addColumn(c.edit().optional(false).create());
                        }
                    });
                    return;
                }
                catch (ParsingException e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
                catch (MultipleParsingExceptions e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
            }
            if (this.tokens.canConsume("CONSTRAINT", new String[]{"any value", "UNIQUE"}) || this.tokens.canConsume("UNIQUE")) {
                this.tokens.canConsumeAnyOf("KEY", new String[]{"INDEX"});
                try {
                    if (!this.tokens.matches('(')) {
                        if (!this.tokens.matches("USING")) {
                            this.tokens.consume();
                        }
                        if (this.tokens.matches("USING")) {
                            this.parseIndexType(start);
                        }
                    }
                    List<String> uniqueKeyColumnNames = this.parseIndexColumnNames(start);
                    if (table.primaryKeyColumnNames().isEmpty()) {
                        table.setPrimaryKeyNames(uniqueKeyColumnNames);
                    }
                    this.parseIndexOptions(start);
                    return;
                }
                catch (ParsingException e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
                catch (MultipleParsingExceptions e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
            }
            if (this.tokens.canConsume("CONSTRAINT", new String[]{"any value", "FOREIGN", "KEY"}) || this.tokens.canConsume("FOREIGN", new String[]{"KEY"})) {
                try {
                    if (!this.tokens.matches('(')) {
                        this.tokens.consume();
                    }
                    this.parseIndexColumnNames(start);
                    if (this.tokens.matches("REFERENCES")) {
                        this.parseReferenceDefinition(start);
                    }
                    return;
                }
                catch (ParsingException e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
                catch (MultipleParsingExceptions e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
            }
            if (this.tokens.canConsumeAnyOf("INDEX", new String[]{"KEY"})) {
                try {
                    if (!this.tokens.matches('(')) {
                        if (!this.tokens.matches("USING")) {
                            this.tokens.consume();
                        }
                        if (this.tokens.matches("USING")) {
                            this.parseIndexType(start);
                        }
                    }
                    this.parseIndexColumnNames(start);
                    this.parseIndexOptions(start);
                    return;
                }
                catch (ParsingException e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
                catch (MultipleParsingExceptions e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
            }
            if (this.tokens.canConsumeAnyOf("FULLTEXT", new String[]{"SPATIAL"})) {
                try {
                    this.tokens.canConsumeAnyOf("INDEX", new String[]{"KEY"});
                    if (!this.tokens.matches('(')) {
                        this.tokens.consume();
                    }
                    this.parseIndexColumnNames(start);
                    this.parseIndexOptions(start);
                    return;
                }
                catch (ParsingException e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
                catch (MultipleParsingExceptions e) {
                    errors = this.accumulateParsingFailure(e, errors);
                    this.tokens.rewind(defnStart);
                }
            }
        }
        try {
            if (isAlterStatement && !quoted) {
                this.tokens.canConsume("COLUMN");
            }
            String columnName = this.parseColumnName();
            this.parseCreateColumn(start, table, columnName, null);
        }
        catch (ParsingException e) {
            if (errors != null) {
                errors = this.accumulateParsingFailure(e, errors);
                throw new MultipleParsingExceptions(errors);
            }
            throw e;
        }
        catch (MultipleParsingExceptions e) {
            if (errors != null) {
                errors = this.accumulateParsingFailure(e, errors);
                throw new MultipleParsingExceptions(errors);
            }
            throw e;
        }
    }

    protected Column parseCreateColumn(TokenStream.Marker start, TableEditor table, String columnName, String newColumnName) {
        Column existingColumn = table.columnWithName(columnName);
        ColumnEditor column = existingColumn != null ? existingColumn.edit() : Column.editor().name(columnName);
        AtomicBoolean isPrimaryKey = new AtomicBoolean(false);
        this.parseColumnDefinition(start, columnName, this.tokens, table, column, isPrimaryKey);
        Column newColumnDefn = column.create();
        table.addColumns(new Column[]{newColumnDefn});
        if (isPrimaryKey.get()) {
            table.setPrimaryKeyNames(new String[]{newColumnDefn.name()});
        }
        if (newColumnName != null && !newColumnName.equalsIgnoreCase(columnName)) {
            table.renameColumn(columnName, newColumnName);
            columnName = newColumnName;
        }
        if (this.tokens.canConsume("FIRST")) {
            table.reorderColumn(columnName, null);
        } else if (this.tokens.canConsume("AFTER")) {
            table.reorderColumn(columnName, this.tokens.consume());
        }
        return table.columnWithName(newColumnDefn.name());
    }

    public static List<String> parseSetAndEnumOptions(String typeExpression) {
        ArrayList<String> options = new ArrayList<String>();
        TokenStream tokens = new TokenStream(typeExpression, (TokenStream.Tokenizer)TokenStream.basicTokenizer((boolean)false), false);
        tokens.start();
        if (tokens.canConsumeAnyOf("ENUM", new String[]{"SET"}) && tokens.canConsume('(')) {
            if (tokens.matchesAnyOf(16, new int[]{8})) {
                options.add(MySqlDdlParser.withoutQuotes(tokens.consume()));
                while (tokens.canConsume(',')) {
                    if (!tokens.matchesAnyOf(16, new int[]{8})) continue;
                    options.add(MySqlDdlParser.withoutQuotes(tokens.consume()));
                }
            }
            tokens.consume(')');
        }
        return options;
    }

    protected static String withoutQuotes(String possiblyQuoted) {
        if (possiblyQuoted.length() < 2) {
            return possiblyQuoted;
        }
        if (possiblyQuoted.startsWith("'") && possiblyQuoted.endsWith("'")) {
            return possiblyQuoted.substring(1, possiblyQuoted.length() - 1);
        }
        if (possiblyQuoted.startsWith("\"") && possiblyQuoted.endsWith("\"")) {
            return possiblyQuoted.substring(1, possiblyQuoted.length() - 1);
        }
        return possiblyQuoted;
    }

    protected void parseColumnDefinition(TokenStream.Marker start, String columnName, TokenStream tokens, TableEditor table, ColumnEditor column, AtomicBoolean isPrimaryKey) {
        String charsetName;
        String dataTypeName;
        ArrayList errors = new ArrayList();
        TokenStream.Marker dataTypeStart = tokens.mark();
        DataType dataType = this.dataTypeParser.parse(tokens, errors::addAll);
        if (dataType == null && (dataTypeName = this.parseDomainName(start)) != null) {
            dataType = DataType.userDefinedType((String)dataTypeName);
        }
        if (dataType == null) {
            this.parsingFailed(dataTypeStart.position(), errors, "Unable to read the data type");
            return;
        }
        column.jdbcType(dataType.jdbcType());
        column.type(dataType.name(), dataType.expression());
        if ("ENUM".equals(dataType.name())) {
            column.length(1);
        } else if ("SET".equals(dataType.name())) {
            List<String> options = MySqlDdlParser.parseSetAndEnumOptions(dataType.expression());
            column.length(Math.max(0, options.size() * 2 - 1));
        } else {
            if (dataType.length() > -1L) {
                column.length((int)dataType.length());
            }
            if (dataType.scale() > -1) {
                column.scale(dataType.scale());
            }
        }
        if (-15 == dataType.jdbcType() || -9 == dataType.jdbcType()) {
            column.charsetName("utf8");
        }
        if ((tokens.canConsume("CHARSET") || tokens.canConsume("CHARACTER", new String[]{"SET"})) && !"DEFAULT".equalsIgnoreCase(charsetName = tokens.consume())) {
            column.charsetName(charsetName);
        }
        if (tokens.canConsume("COLLATE")) {
            tokens.consume();
        }
        if (tokens.canConsume("AS") || tokens.canConsume("GENERATED", new String[]{"ALWAYS", "AS"})) {
            this.consumeExpression(start);
            tokens.canConsumeAnyOf("VIRTUAL", new String[]{"STORED"});
            if (tokens.canConsume("UNIQUE")) {
                tokens.canConsume("KEY");
            }
            if (tokens.canConsume("COMMENT")) {
                this.consumeQuotedString();
            }
            tokens.canConsume("NOT", new String[]{"NULL"});
            tokens.canConsume("NULL");
            tokens.canConsume("PRIMARY", new String[]{"KEY"});
            tokens.canConsume("KEY");
        } else {
            while (tokens.matchesAnyOf("NOT", new String[]{"NULL", "DEFAULT", "AUTO_INCREMENT", "UNIQUE", "PRIMARY", "KEY", "COMMENT", "REFERENCES", "COLUMN_FORMAT", "ON", "COLLATE"})) {
                if (tokens.canConsume("NOT", new String[]{"NULL"})) {
                    column.optional(false);
                } else if (tokens.canConsume("NULL")) {
                    column.optional(true);
                }
                if (tokens.matches("DEFAULT")) {
                    this.parseDefaultClause(start);
                }
                if (tokens.matches("ON", new String[]{"UPDATE"}) || tokens.matches("ON", new String[]{"DELETE"})) {
                    this.parseOnUpdateOrDelete(tokens.mark());
                    column.autoIncremented(true);
                }
                if (tokens.canConsume("AUTO_INCREMENT")) {
                    column.autoIncremented(true);
                    column.generated(true);
                }
                if ((tokens.canConsume("UNIQUE", new String[]{"KEY"}) || tokens.canConsume("UNIQUE")) && table.primaryKeyColumnNames().isEmpty() && !column.isOptional()) {
                    isPrimaryKey.set(true);
                }
                if (tokens.canConsume("PRIMARY", new String[]{"KEY"}) || tokens.canConsume("KEY")) {
                    column.optional(false);
                    isPrimaryKey.set(true);
                }
                if (tokens.canConsume("COMMENT")) {
                    this.consumeQuotedString();
                }
                if (tokens.canConsume("COLUMN_FORMAT")) {
                    tokens.consumeAnyOf(new String[]{"FIXED", "DYNAMIC", "DEFAULT"});
                }
                if (tokens.matches("REFERENCES")) {
                    this.parseReferenceDefinition(start);
                }
                if (!tokens.canConsume("COLLATE")) continue;
                tokens.consume();
            }
        }
    }

    protected String parseDomainName(TokenStream.Marker start) {
        return this.parseSchemaQualifiedName(start);
    }

    protected List<String> parseIndexColumnNames(TokenStream.Marker start) {
        ArrayList<String> names = new ArrayList<String>();
        this.tokens.consume('(');
        this.parseIndexColumnName(names::add);
        while (this.tokens.canConsume(',')) {
            this.parseIndexColumnName(names::add);
        }
        this.tokens.consume(')');
        return names;
    }

    private void parseIndexColumnName(Consumer<String> name) {
        name.accept(this.parseColumnName());
        if (this.tokens.canConsume('(')) {
            this.tokens.consume();
            this.tokens.consume(')');
        }
        this.tokens.canConsumeAnyOf("ASC", new String[]{"DESC"});
    }

    protected void parseIndexType(TokenStream.Marker start) {
        this.tokens.consume("USING");
        this.tokens.consumeAnyOf(new String[]{"BTREE", "HASH"});
    }

    protected void parseIndexOptions(TokenStream.Marker start) {
        while (true) {
            if (this.tokens.matches("USING")) {
                this.parseIndexType(start);
                continue;
            }
            if (this.tokens.canConsume("COMMENT")) {
                this.consumeQuotedString();
                continue;
            }
            if (this.tokens.canConsume("KEY_BLOCK_SIZE")) {
                this.tokens.consume("=");
                this.tokens.consume();
                continue;
            }
            if (!this.tokens.canConsume("WITH", new String[]{"PARSER"})) break;
            this.tokens.consume();
        }
    }

    protected void parseReferenceDefinition(TokenStream.Marker start) {
        this.tokens.consume("REFERENCES");
        this.parseSchemaQualifiedName(start);
        if (this.tokens.matches('(')) {
            this.parseColumnNameList(start);
        }
        if (this.tokens.canConsume("MATCH")) {
            this.tokens.consumeAnyOf(new String[]{"FULL", "PARTIAL", "SIMPLE"});
        }
        if (this.tokens.canConsume("ON", new String[]{"DELETE"})) {
            this.parseReferenceOption(start);
        }
        if (this.tokens.canConsume("ON", new String[]{"UPDATE"})) {
            this.parseReferenceOption(start);
        }
        if (this.tokens.canConsume("ON", new String[]{"DELETE"})) {
            this.parseReferenceOption(start);
        }
    }

    protected void parseReferenceOption(TokenStream.Marker start) {
        if (!(this.tokens.canConsume("RESTRICT") || this.tokens.canConsume("CASCADE") || this.tokens.canConsume("SET", new String[]{"NULL"}))) {
            this.tokens.canConsume("NO", new String[]{"ACTION"});
        }
    }

    protected void parseCreateView(TokenStream.Marker start) {
        this.tokens.canConsume("OR", new String[]{"REPLACE"});
        if (this.tokens.canConsume("ALGORITHM")) {
            this.tokens.consume('=');
            this.tokens.consumeAnyOf(new String[]{"UNDEFINED", "MERGE", "TEMPTABLE"});
        }
        this.parseDefiner(this.tokens.mark());
        if (this.tokens.canConsume("SQL", new String[]{"SECURITY"})) {
            this.tokens.consumeAnyOf(new String[]{"DEFINER", "INVOKER"});
        }
        this.tokens.consume("VIEW");
        TableId tableId = this.parseQualifiedTableName(start);
        if (this.skipViews) {
            this.consumeRemainingStatement(start);
            this.signalCreateView(tableId, start);
            this.debugSkipped(start);
            return;
        }
        TableEditor table = this.databaseTables.editOrCreateTable(tableId);
        if (this.tokens.matches('(')) {
            List<String> columnNames = this.parseColumnNameList(start);
            columnNames.forEach(name -> table.addColumn(Column.editor().name(name).create()));
        }
        this.tokens.canConsume("AS");
        if (this.tokens.canConsume("SELECT")) {
            Map selectedColumnsByAlias = this.parseColumnsInSelectClause(start);
            if (table.columns().isEmpty()) {
                selectedColumnsByAlias.forEach((columnName, fromTableColumn) -> {
                    if (fromTableColumn != null && columnName != null) {
                        table.addColumn(fromTableColumn.edit().name(columnName).create());
                    }
                });
            } else {
                ArrayList changedColumns = new ArrayList();
                table.columns().forEach(column -> {
                    Column selectedColumn = (Column)selectedColumnsByAlias.get(column.name());
                    if (selectedColumn != null) {
                        changedColumns.add(column.edit().jdbcType(selectedColumn.jdbcType()).type(selectedColumn.typeName(), selectedColumn.typeExpression()).length(selectedColumn.length()).scale(selectedColumn.scale()).autoIncremented(selectedColumn.isAutoIncremented()).generated(selectedColumn.isGenerated()).optional(selectedColumn.isOptional()).create());
                    }
                });
                changedColumns.forEach(arg_0 -> ((TableEditor)table).addColumn(arg_0));
            }
            Map fromTables = this.parseSelectFromClause(start);
            if (fromTables.size() == 1) {
                Table fromTable = (Table)fromTables.values().stream().findFirst().get();
                List fromTablePkColumnNames = fromTable.columnNames();
                ArrayList viewPkColumnNames = new ArrayList();
                selectedColumnsByAlias.forEach((viewColumnName, fromTableColumn) -> {
                    if (fromTablePkColumnNames.contains(fromTableColumn.name())) {
                        viewPkColumnNames.add(viewColumnName);
                    }
                });
                if (viewPkColumnNames.size() == fromTablePkColumnNames.size()) {
                    table.setPrimaryKeyNames(viewPkColumnNames);
                }
            }
        }
        this.consumeRemainingStatement(start);
        this.databaseTables.overwriteTable(table.create());
        this.signalCreateView(tableId, start);
        this.debugParsed(start);
    }

    protected void parseCreateIndex(TokenStream.Marker start) {
        TableEditor table;
        boolean unique = this.tokens.canConsume("UNIQUE");
        this.tokens.canConsumeAnyOf("FULLTEXT", new String[]{"SPATIAL"});
        this.tokens.consume("INDEX");
        String indexName = this.tokens.consume();
        if (this.tokens.matches("USING")) {
            this.parseIndexType(start);
        }
        TableId tableId = null;
        if (this.tokens.canConsume("ON")) {
            tableId = this.parseQualifiedTableName(start);
        }
        if (unique && tableId != null && (table = this.databaseTables.editTable(tableId)) != null && !table.hasPrimaryKey()) {
            List<String> names = this.parseIndexColumnNames(start);
            if (table.columns().stream().allMatch(Column::isRequired)) {
                this.databaseTables.overwriteTable(table.setPrimaryKeyNames(names).create());
            }
        }
        this.consumeRemainingStatement(start);
        this.signalCreateIndex(indexName, tableId, start);
        this.debugParsed(start);
    }

    protected void parseDefiner(TokenStream.Marker start) {
        if (this.tokens.canConsume("DEFINER")) {
            this.tokens.consume('=');
            this.tokens.consume();
            if (this.tokens.canConsume("@")) {
                this.tokens.consume();
            } else {
                String next = this.tokens.peek();
                if (next.startsWith("@")) {
                    this.tokens.consume();
                }
            }
        }
    }

    protected void parseCreateProcedure(TokenStream.Marker start) {
        this.parseDefiner(this.tokens.mark());
        this.tokens.consumeAnyOf(new String[]{"FUNCTION", "PROCEDURE"});
        this.tokens.consume();
        this.consumeRemainingStatement(start);
    }

    protected void parseCreateTrigger(TokenStream.Marker start) {
        this.parseDefiner(this.tokens.mark());
        this.tokens.consume("TRIGGER");
        this.tokens.consume();
        this.consumeRemainingStatement(start);
    }

    protected void parseCreateEvent(TokenStream.Marker start) {
        this.parseDefiner(this.tokens.mark());
        this.tokens.consume("EVENT");
        this.tokens.consume();
        this.consumeRemainingStatement(start);
    }

    protected void parseCreateUnknown(TokenStream.Marker start) {
        this.consumeRemainingStatement(start);
    }

    protected void parseAlter(TokenStream.Marker marker) {
        this.tokens.consume("ALTER");
        if (this.tokens.matches("TABLE") || this.tokens.matches("IGNORE", new String[]{"TABLE"})) {
            this.parseAlterTable(marker);
            this.debugParsed(marker);
        } else if (this.tokens.matchesAnyOf("DATABASE", new String[]{"SCHEMA"})) {
            this.parseAlterDatabase(marker);
        } else {
            this.parseAlterUnknown(marker);
        }
    }

    protected void parseAlterTable(TokenStream.Marker start) {
        this.tokens.canConsume("IGNORE");
        this.tokens.consume("TABLE");
        TableId tableId = this.parseQualifiedTableName(start);
        TableEditor table = this.databaseTables.editTable(tableId);
        TableId oldTableId = null;
        if (table != null) {
            Table renamed;
            AtomicReference<Object> newTableName = new AtomicReference<Object>(null);
            if (!this.tokens.matches(this.terminator()) && !this.tokens.matches("PARTITION")) {
                this.parseAlterSpecificationList(start, table, newTableName::set);
            }
            if (this.tokens.matches("PARTITION")) {
                this.parsePartitionOptions(start, table);
            }
            this.databaseTables.overwriteTable(table.create());
            if (newTableName.get() != null && (renamed = this.databaseTables.renameTable(tableId, (TableId)newTableName.get())) != null) {
                oldTableId = tableId;
                tableId = renamed.id();
            }
        } else {
            TokenStream.Marker marker = this.tokens.mark();
            try {
                table = TableEditor.noOp((TableId)tableId);
                if (!this.tokens.matches(this.terminator()) && !this.tokens.matches("PARTITION")) {
                    this.parseAlterSpecificationList(start, table, str -> {});
                }
                if (this.tokens.matches("PARTITION")) {
                    this.parsePartitionOptions(start, table);
                }
                this.parseTableOptions(start, table);
            }
            catch (ParsingException e) {
                this.tokens.rewind(marker);
                this.consumeRemainingStatement(start);
            }
        }
        this.signalAlterTable(tableId, oldTableId, start);
    }

    protected void parseAlterSpecificationList(TokenStream.Marker start, TableEditor table, Consumer<TableId> newTableName) {
        this.parseAlterSpecification(start, table, newTableName);
        while (this.tokens.canConsume(',')) {
            this.parseAlterSpecification(start, table, newTableName);
        }
    }

    protected void parseAlterSpecification(TokenStream.Marker start, TableEditor table, Consumer<TableId> newTableName) {
        this.parseTableOptions(start, table);
        if (this.tokens.canConsume("ADD")) {
            if (this.tokens.matches("COLUMN", new String[]{"("}) || this.tokens.matches('(')) {
                this.tokens.canConsume("COLUMN");
                this.parseCreateDefinitionList(start, table);
            } else if (this.tokens.canConsume("PARTITION", new String[]{"("})) {
                this.parsePartitionDefinition(start, table);
                this.tokens.consume(')');
            } else {
                this.parseCreateDefinition(start, table, true);
            }
        } else if (this.tokens.canConsume("DROP")) {
            if (this.tokens.canConsume("PRIMARY", new String[]{"KEY"})) {
                table.setPrimaryKeyNames(new String[0]);
            } else if (this.tokens.canConsume("FOREIGN", new String[]{"KEY"})) {
                this.tokens.consume();
            } else if (this.tokens.canConsumeAnyOf("INDEX", new String[]{"KEY"})) {
                this.tokens.consume();
            } else if (this.tokens.canConsume("PARTITION")) {
                this.parsePartitionNames(start);
            } else {
                if (!this.isNextTokenQuotedIdentifier()) {
                    this.tokens.canConsume("COLUMN");
                }
                String columnName = this.parseColumnName();
                table.removeColumn(columnName);
                this.tokens.canConsume("RESTRICT");
            }
        } else if (this.tokens.canConsume("ALTER")) {
            if (!this.isNextTokenQuotedIdentifier()) {
                this.tokens.canConsume("COLUMN");
            }
            this.tokens.consume();
            if (!this.tokens.canConsume("DROP", new String[]{"DEFAULT"})) {
                this.tokens.consume("SET");
                this.parseDefaultClause(start);
            }
        } else if (this.tokens.canConsume("CHANGE")) {
            if (!this.isNextTokenQuotedIdentifier()) {
                this.tokens.canConsume("COLUMN");
            }
            String oldName = this.parseColumnName();
            String newName = this.parseColumnName();
            this.parseCreateColumn(start, table, oldName, newName);
        } else if (this.tokens.canConsume("MODIFY")) {
            if (!this.isNextTokenQuotedIdentifier()) {
                this.tokens.canConsume("COLUMN");
            }
            String columnName = this.parseColumnName();
            this.parseCreateColumn(start, table, columnName, null);
        } else if (this.tokens.canConsumeAnyOf("ALGORITHM", new String[]{"LOCK"})) {
            this.tokens.canConsume('=');
            this.tokens.consume();
        } else if (!this.tokens.canConsume("DISABLE", new String[]{"KEYS"}) && !this.tokens.canConsume("ENABLE", new String[]{"KEYS"})) {
            if (this.tokens.canConsume("RENAME", new String[]{"INDEX"}) || this.tokens.canConsume("RENAME", new String[]{"KEY"})) {
                this.tokens.consume();
                this.tokens.consume("TO");
                this.tokens.consume();
            } else if (this.tokens.canConsume("RENAME")) {
                this.tokens.canConsumeAnyOf("AS", new String[]{"TO"});
                TableId newTableId = this.parseQualifiedTableName(start);
                newTableName.accept(newTableId);
            } else if (this.tokens.canConsume("ORDER", new String[]{"BY"})) {
                this.consumeCommaSeparatedValueList(start);
            } else if (this.tokens.canConsume("CONVERT", new String[]{"TO", "CHARACTER", "SET"}) || this.tokens.canConsume("CONVERT", new String[]{"TO", "CHARSET"})) {
                this.tokens.consume();
                if (this.tokens.canConsume("COLLATE")) {
                    this.tokens.consume();
                }
            } else if (this.tokens.canConsume("CHARACTER", new String[]{"SET"}) || this.tokens.canConsume("CHARSET") || this.tokens.canConsume("DEFAULT", new String[]{"CHARACTER", "SET"}) || this.tokens.canConsume("DEFAULT", new String[]{"CHARSET"})) {
                this.tokens.canConsume('=');
                String charsetName = this.tokens.consume();
                table.setDefaultCharsetName(charsetName);
                if (this.tokens.canConsume("COLLATE")) {
                    this.tokens.canConsume('=');
                    this.tokens.consume();
                }
            } else if (!(this.tokens.canConsume("DISCARD", new String[]{"TABLESPACE"}) || this.tokens.canConsume("IMPORT", new String[]{"TABLESPACE"}) || this.tokens.canConsume("FORCE") || this.tokens.canConsume("WITH", new String[]{"VALIDATION"}) || this.tokens.canConsume("WITHOUT", new String[]{"VALIDATION"}))) {
                if (this.tokens.canConsume("DISCARD", new String[]{"PARTITION"}) || this.tokens.canConsume("IMPORT", new String[]{"PARTITION"})) {
                    if (!this.tokens.canConsume("ALL")) {
                        this.tokens.consume();
                    }
                    this.tokens.consume("TABLESPACE");
                } else if (this.tokens.canConsume("COALLESCE", new String[]{"PARTITION"})) {
                    this.tokens.consume();
                } else if (this.tokens.canConsume("REORGANIZE", new String[]{"PARTITION"})) {
                    this.parsePartitionNames(start);
                    this.tokens.consume("INTO", new String[]{"("});
                    do {
                        this.parsePartitionDefinition(start, table);
                    } while (this.tokens.canConsume(','));
                    this.tokens.consume(')');
                } else if (this.tokens.canConsume("EXCHANGE", new String[]{"PARTITION"})) {
                    this.tokens.consume();
                    this.tokens.consume("WITH", new String[]{"TABLE"});
                    this.parseSchemaQualifiedName(start);
                    if (this.tokens.canConsumeAnyOf("WITH", new String[]{"WITHOUT"})) {
                        this.tokens.consume("VALIDATION");
                    }
                } else if (this.tokens.matches("any value", new String[]{"PARTITION"})) {
                    this.tokens.consumeAnyOf(new String[]{"TRUNCATE", "CHECK", "ANALYZE", "OPTIMIZE", "REBUILD", "REPAIR"});
                    this.tokens.consume("PARTITION");
                    if (!this.tokens.canConsume("ALL")) {
                        this.parsePartitionNames(start);
                    }
                } else if (this.tokens.canConsume("REMOVE", new String[]{"PARTITIONING"}) || this.tokens.canConsume("UPGRADE", new String[]{"PARTITIONING"})) {
                    // empty if block
                }
            }
        }
    }

    protected void parseAlterUnknown(TokenStream.Marker start) {
        this.consumeRemainingStatement(start);
        this.debugSkipped(start);
    }

    protected void parseDrop(TokenStream.Marker marker) {
        this.tokens.consume("DROP");
        if (this.tokens.matches("TABLE") || this.tokens.matches("TEMPORARY", new String[]{"TABLE"})) {
            this.parseDropTable(marker);
        } else if (this.tokens.matches("VIEW")) {
            this.parseDropView(marker);
        } else if (this.tokens.matches("INDEX")) {
            this.parseDropIndex(marker);
        } else if (this.tokens.matchesAnyOf("DATABASE", new String[]{"SCHEMA"})) {
            this.parseDropDatabase(marker);
        } else {
            this.parseDropUnknown(marker);
        }
    }

    protected void parseDropTable(TokenStream.Marker start) {
        this.tokens.canConsume("TEMPORARY");
        this.tokens.consume("TABLE");
        this.tokens.canConsume("IF", new String[]{"EXISTS"});
        String statementPrefix = this.statement(start);
        List ids = this.parseQualifiedTableNames(start);
        boolean restrict = this.tokens.canConsume("RESTRICT");
        boolean cascade = this.tokens.canConsume("CASCADE");
        ids.forEach(tableId -> {
            this.databaseTables.removeTable(tableId);
            this.signalDropTable((TableId)tableId, statementPrefix + tableId + (restrict ? " RESTRICT" : (cascade ? " CASCADE" : "")));
        });
        this.debugParsed(start);
    }

    protected void parseDropView(TokenStream.Marker start) {
        if (this.skipViews) {
            this.consumeRemainingStatement(start);
            this.debugSkipped(start);
            return;
        }
        this.tokens.consume("VIEW");
        this.tokens.canConsume("IF", new String[]{"EXISTS"});
        String statementPrefix = this.statement(start);
        List ids = this.parseQualifiedTableNames(start);
        boolean restrict = this.tokens.canConsume("RESTRICT");
        boolean cascade = this.tokens.canConsume("CASCADE");
        ids.forEach(tableId -> {
            this.databaseTables.removeTable(tableId);
            this.signalDropView((TableId)tableId, statementPrefix + tableId + (restrict ? " RESTRICT" : (cascade ? " CASCADE" : "")));
        });
        this.debugParsed(start);
    }

    protected void parseDropIndex(TokenStream.Marker start) {
        this.tokens.consume("INDEX");
        String indexName = this.tokens.consume();
        this.tokens.consume("ON");
        TableId tableId = this.parseQualifiedTableName(start);
        this.consumeRemainingStatement(start);
        this.signalDropIndex(indexName, tableId, start);
        this.debugParsed(start);
    }

    protected void parseDropUnknown(TokenStream.Marker start) {
        this.consumeRemainingStatement(start);
        this.debugSkipped(start);
    }

    protected void parseRename(TokenStream.Marker start) {
        this.tokens.consume("RENAME");
        if (this.tokens.canConsume("TABLE")) {
            this.parseRenameTable(start);
            while (this.tokens.canConsume(',')) {
                this.parseRenameTable(start);
            }
        } else if (this.tokens.canConsumeAnyOf("DATABASE", new String[]{"SCHEMA", "USER"})) {
            this.consumeRemainingStatement(start);
        }
    }

    protected void parseRenameTable(TokenStream.Marker start) {
        TableId from = this.parseQualifiedTableName(start);
        this.tokens.consume("TO");
        TableId to = this.parseQualifiedTableName(start);
        this.databaseTables.renameTable(from, to);
        this.signalAlterTable(from, to, "RENAME TABLE " + from + " TO " + to);
    }

    protected void parseUse(TokenStream.Marker marker) {
        this.tokens.consume("USE");
        String dbName = this.tokens.consume();
        this.setCurrentSchema(dbName);
        String charsetForDb = (String)this.charsetNameForDatabase.get(dbName);
        this.systemVariables.setVariable(MySqlSystemVariables.Scope.GLOBAL, "character_set_database", charsetForDb);
    }

    protected String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable(SERVER_CHARSET_NAME);
        }
        return charsetName;
    }

    protected List<String> parseColumnNameList(TokenStream.Marker start) {
        ArrayList<String> names = new ArrayList<String>();
        this.tokens.consume('(');
        names.add(this.parseColumnName());
        while (this.tokens.canConsume(',')) {
            names.add(this.parseColumnName());
        }
        this.tokens.consume(')');
        return names;
    }

    protected String parseColumnName() {
        boolean quoted = this.isNextTokenQuotedIdentifier();
        String name = this.tokens.consume();
        if (!quoted && name.matches("[0-9]+")) {
            this.parsingFailed(this.tokens.previousPosition(), "Unquoted column names may not contain only digits");
            return null;
        }
        return name;
    }

    protected void parsePartitionNames(TokenStream.Marker start) {
        this.consumeCommaSeparatedValueList(start);
    }

    protected void consumeCommaSeparatedValueList(TokenStream.Marker start) {
        this.tokens.consume();
        while (this.tokens.canConsume(',')) {
            this.tokens.consume();
        }
    }

    protected void consumeValueList(TokenStream.Marker start) {
        this.tokens.consume('(');
        this.consumeCommaSeparatedValueList(start);
        this.tokens.consume(')');
    }

    protected void consumeExpression(TokenStream.Marker start) {
        this.tokens.consume("(");
        this.tokens.consumeThrough(')', '(');
    }

    protected void consumeBeginStatement(TokenStream.Marker start) {
        String label;
        this.tokens.consume("BEGIN");
        LinkedList<String> labels = new LinkedList<String>();
        labels.addFirst(this.getPrecedingBlockLabel());
        int expectedPlainEnds = 0;
        while (this.tokens.hasNext()) {
            if (this.tokens.matchesWord("BEGIN")) {
                this.consumeBeginStatement(this.tokens.mark());
            }
            if (this.tokens.canConsumeWords("IF", new String[]{"EXISTS"})) continue;
            if (this.tokens.canConsumeWords("CASE", new String[]{"WHEN"})) {
                ++expectedPlainEnds;
                continue;
            }
            if (this.tokens.matchesAnyWordOf("REPEAT", new String[]{"LOOP", "WHILE"})) {
                label = this.getPrecedingBlockLabel();
                this.tokens.consume();
                labels.addFirst(label);
                continue;
            }
            if (this.tokens.canConsumeWord("END")) {
                if (this.tokens.matchesAnyOf("REPEAT", new String[]{"LOOP", "WHILE"})) {
                    this.tokens.consume();
                    label = (String)labels.remove();
                    if (label == null) continue;
                    this.tokens.canConsume(label);
                    continue;
                }
                if (this.tokens.matchesAnyWordOf("IF", new String[]{"CASE"})) {
                    this.tokens.consume();
                    continue;
                }
                if (expectedPlainEnds <= 0) break;
                --expectedPlainEnds;
                continue;
            }
            this.tokens.consume();
        }
        assert (labels.size() == 1);
        label = (String)labels.remove();
        if (label != null) {
            this.tokens.canConsume(label);
        }
    }

    protected String getPrecedingBlockLabel() {
        if (this.tokens.previousToken(1).matches(':')) {
            return this.tokens.previousToken(2).value();
        }
        return null;
    }

    protected void sequentially(Consumer<TokenStream.Marker> ... functions) {
        if (functions == null || functions.length == 0) {
            return;
        }
        ArrayList<ParsingException> errors = new ArrayList<ParsingException>();
        TokenStream.Marker marker = this.tokens.mark();
        for (Consumer<TokenStream.Marker> function : functions) {
            try {
                function.accept(marker);
                return;
            }
            catch (ParsingException e) {
                errors.add(e);
                this.tokens.rewind(marker);
            }
        }
        this.parsingFailed(marker.position(), errors, "One or more errors trying to parse statement");
    }

    protected void parseDefaultClause(TokenStream.Marker start) {
        this.tokens.consume("DEFAULT");
        if (this.isNextTokenQuotedIdentifier()) {
            this.parseLiteral(start);
        } else if (this.tokens.matchesAnyOf("CURRENT_TIMESTAMP", new String[]{"NOW"})) {
            this.parseCurrentTimestampOrNow();
            this.parseOnUpdateOrDelete(this.tokens.mark());
        } else if (!this.tokens.canConsume("NULL")) {
            this.parseLiteral(start);
        }
    }

    protected void parseOnUpdateOrDelete(TokenStream.Marker start) {
        if (this.tokens.canConsume("ON") && this.tokens.canConsumeAnyOf("UPDATE", new String[]{"DELETE"})) {
            this.parseCurrentTimestampOrNow();
        }
    }

    private void parseCurrentTimestampOrNow() {
        this.tokens.consumeAnyOf(new String[]{"CURRENT_TIMESTAMP", "NOW"});
        if (this.tokens.canConsume('(') && !this.tokens.canConsume(')')) {
            this.tokens.consumeInteger();
            this.tokens.consume(')');
        }
    }
}

