/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.Configurator;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.text.ParsingException;
import io.debezium.util.IoUtil;
import io.debezium.util.SchemaNameAdjuster;
import io.debezium.util.Testing;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlSchemaTest {
    private static final Path TEST_FILE_PATH = Testing.Files.createTestingPath((String)"dbHistory.log");
    private static final String SERVER_NAME = "testServer";
    private Configurator build;
    private MySqlSchema mysql;
    private SourceInfo source;

    @Before
    public void beforeEach() {
        Testing.Files.delete((Path)TEST_FILE_PATH);
        this.build = new Configurator();
        this.mysql = null;
        this.source = new SourceInfo();
    }

    @After
    public void afterEach() {
        if (this.mysql != null) {
            try {
                this.mysql.shutdown();
            }
            finally {
                this.mysql = null;
            }
        }
    }

    @Test
    public void shouldApplyDdlStatementsAndRecover() throws InterruptedException {
        this.mysql = this.build.storeDatabaseHistoryInFile(TEST_FILE_PATH).serverName(SERVER_NAME).createSchemas();
        this.mysql.start();
        this.source.setBinlogStartPoint("binlog-001", 400L);
        this.mysql.applyDdl(this.source, "db1", "SET character_set_server=utf8mb4", this::printStatements);
        this.mysql.applyDdl(this.source, "db1", this.readFile("ddl/mysql-products.ddl"), this::printStatements);
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertHistoryRecorded();
    }

    @Test
    public void shouldIgnoreUnparseableDdlAndRecover() throws InterruptedException {
        this.mysql = this.build.with(DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, true).storeDatabaseHistoryInFile(TEST_FILE_PATH).serverName(SERVER_NAME).createSchemas();
        this.mysql.start();
        this.source.setBinlogStartPoint("binlog-001", 400L);
        this.mysql.applyDdl(this.source, "db1", "SET character_set_server=utf8mb4", this::printStatements);
        this.mysql.applyDdl(this.source, "db1", "xxxCREATE TABLE mytable\n" + this.readFile("ddl/mysql-products.ddl"), this::printStatements);
        this.mysql.applyDdl(this.source, "db1", this.readFile("ddl/mysql-products.ddl"), this::printStatements);
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertHistoryRecorded();
    }

    @Test(expected=ParsingException.class)
    public void shouldFailOnUnparseableDdl() throws InterruptedException {
        this.mysql = this.build.storeDatabaseHistoryInFile(TEST_FILE_PATH).serverName(SERVER_NAME).createSchemas();
        this.mysql.start();
        this.source.setBinlogStartPoint("binlog-001", 400L);
        this.mysql.applyDdl(this.source, "db1", "SET character_set_server=utf8mb4", this::printStatements);
        this.mysql.applyDdl(this.source, "db1", "xxxCREATE TABLE mytable\n" + this.readFile("ddl/mysql-products.ddl"), this::printStatements);
    }

    @Test
    public void shouldLoadSystemAndNonSystemTablesAndConsumeOnlyFilteredDatabases() throws InterruptedException {
        this.mysql = this.build.storeDatabaseHistoryInFile(TEST_FILE_PATH).serverName(SERVER_NAME).includeDatabases("connector_test").excludeBuiltInTables().createSchemas();
        this.mysql.start();
        this.source.setBinlogStartPoint("binlog-001", 400L);
        this.mysql.applyDdl(this.source, "mysql", "SET character_set_server=utf8mb4", this::printStatements);
        this.mysql.applyDdl(this.source, "mysql", this.readFile("ddl/mysql-test-init-5.7.ddl"), this::printStatements);
        this.source.setBinlogStartPoint("binlog-001", 1000L);
        this.mysql.applyDdl(this.source, "db1", this.readFile("ddl/mysql-products.ddl"), this::printStatements);
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertTableExcluded("mysql.columns_priv");
        this.assertNoTablesExistForDatabase("mysql");
        this.assertHistoryRecorded();
    }

    @Test
    public void shouldLoadSystemAndNonSystemTablesAndConsumeAllDatabases() throws InterruptedException {
        this.mysql = this.build.storeDatabaseHistoryInFile(TEST_FILE_PATH).serverName(SERVER_NAME).includeDatabases("connector_test,mysql").includeBuiltInTables().createSchemas();
        this.mysql.start();
        this.source.setBinlogStartPoint("binlog-001", 400L);
        this.mysql.applyDdl(this.source, "mysql", "SET character_set_server=utf8mb4", this::printStatements);
        this.mysql.applyDdl(this.source, "mysql", this.readFile("ddl/mysql-test-init-5.7.ddl"), this::printStatements);
        this.source.setBinlogStartPoint("binlog-001", 1000L);
        this.mysql.applyDdl(this.source, "db1", this.readFile("ddl/mysql-products.ddl"), this::printStatements);
        this.assertTableIncluded("connector_test.products");
        this.assertTableIncluded("connector_test.products_on_hand");
        this.assertTableIncluded("connector_test.customers");
        this.assertTableIncluded("connector_test.orders");
        this.assertTableIncluded("mysql.columns_priv");
        this.assertTablesExistForDatabase("mysql");
        this.assertHistoryRecorded();
    }

    protected void assertTableIncluded(String fullyQualifiedTableName) {
        TableId tableId = TableId.parse((String)fullyQualifiedTableName);
        TableSchema tableSchema = this.mysql.schemaFor(tableId);
        Assertions.assertThat((Object)tableSchema).isNotNull();
        Assertions.assertThat((String)tableSchema.keySchema().name()).isEqualTo((Object)SchemaNameAdjuster.validFullname((String)("testServer." + fullyQualifiedTableName + ".Key")));
        Assertions.assertThat((String)tableSchema.valueSchema().name()).isEqualTo((Object)SchemaNameAdjuster.validFullname((String)("testServer." + fullyQualifiedTableName + ".Value")));
    }

    protected void assertTableExcluded(String fullyQualifiedTableName) {
        TableId tableId = TableId.parse((String)fullyQualifiedTableName);
        Assertions.assertThat((Object)this.mysql.schemaFor(tableId)).isNull();
    }

    protected void assertNoTablesExistForDatabase(String dbName) {
        Assertions.assertThat((long)this.mysql.tableIds().stream().filter(id -> id.catalog().equals(dbName)).count()).isEqualTo(0L);
    }

    protected void assertTablesExistForDatabase(String dbName) {
        Assertions.assertThat((long)this.mysql.tableIds().stream().filter(id -> id.catalog().equals(dbName)).count()).isGreaterThan(0L);
    }

    protected void assertHistoryRecorded() {
        MySqlSchema duplicate = this.build.storeDatabaseHistoryInFile(TEST_FILE_PATH).createSchemas();
        duplicate.loadHistory(this.source);
        Assertions.assertThat((Collection)duplicate.tableIds()).isEqualTo((Object)this.mysql.tableIds());
        for (int i = 0; i != 2; ++i) {
            duplicate.tableIds().forEach(tableId -> {
                TableSchema dupSchema = duplicate.schemaFor(tableId);
                TableSchema schema = this.mysql.schemaFor(tableId);
                Assertions.assertThat((Object)schema).isEqualTo((Object)dupSchema);
                Table dupTable = duplicate.tableFor(tableId);
                Table table = this.mysql.tableFor(tableId);
                Assertions.assertThat((Object)table).isEqualTo((Object)dupTable);
            });
            this.mysql.tableIds().forEach(tableId -> {
                TableSchema dupSchema = duplicate.schemaFor(tableId);
                TableSchema schema = this.mysql.schemaFor(tableId);
                Assertions.assertThat((Object)schema).isEqualTo((Object)dupSchema);
                Table dupTable = duplicate.tableFor(tableId);
                Table table = this.mysql.tableFor(tableId);
                Assertions.assertThat((Object)table).isEqualTo((Object)dupTable);
            });
            duplicate.refreshSchemas();
        }
    }

    protected void printStatements(String dbName, String ddlStatements) {
        Testing.print((Object)("Running DDL for '" + dbName + "': " + ddlStatements));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readFile(String classpathResource) {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(classpathResource);){
            Assertions.assertThat((Object)stream).isNotNull();
            String string = IoUtil.read((InputStream)stream);
            return string;
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to read '" + classpathResource + "'"));
            assert (false) : "should never get here";
            return null;
        }
    }
}

