/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.embedded.OffsetCommitPolicy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class OffsetCommitPolicyTest {
    @Test
    public void shouldAlwaysCommit() {
        OffsetCommitPolicy policy = OffsetCommitPolicy.always();
        Assertions.assertThat((boolean)policy.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isTrue();
        Assertions.assertThat((boolean)policy.performCommit(10000L, 1000L, TimeUnit.DAYS)).isTrue();
    }

    @Test
    public void shouldCommitPeriodically() {
        OffsetCommitPolicy policy = OffsetCommitPolicy.periodic((long)10L, (TimeUnit)TimeUnit.HOURS);
        Assertions.assertThat((boolean)policy.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)policy.performCommit(10000L, 9L, TimeUnit.HOURS)).isFalse();
        Assertions.assertThat((boolean)policy.performCommit(0L, 10L, TimeUnit.HOURS)).isTrue();
    }

    @Test
    public void shouldCombineTwoPolicies() {
        AtomicBoolean commitFirst = new AtomicBoolean(false);
        AtomicBoolean commitSecond = new AtomicBoolean(false);
        OffsetCommitPolicy policy1 = (num, time, unit) -> commitFirst.get();
        OffsetCommitPolicy policy2 = (num, time, unit) -> commitSecond.get();
        OffsetCommitPolicy both1 = policy1.and(policy2);
        OffsetCommitPolicy both2 = policy2.and(policy1);
        OffsetCommitPolicy either1 = policy1.or(policy2);
        OffsetCommitPolicy either2 = policy2.or(policy1);
        Assertions.assertThat((boolean)both1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)both2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)either1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)either2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        commitFirst.set(true);
        Assertions.assertThat((boolean)both1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)both2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)either1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isTrue();
        Assertions.assertThat((boolean)either2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isTrue();
        commitSecond.set(true);
        Assertions.assertThat((boolean)both1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isTrue();
        Assertions.assertThat((boolean)both2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isTrue();
        Assertions.assertThat((boolean)either1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isTrue();
        Assertions.assertThat((boolean)either2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isTrue();
        commitFirst.set(false);
        Assertions.assertThat((boolean)both1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)both2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)either1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isTrue();
        Assertions.assertThat((boolean)either2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isTrue();
        commitSecond.set(false);
        Assertions.assertThat((boolean)both1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)both2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)either1.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
        Assertions.assertThat((boolean)either2.performCommit(0L, 0L, TimeUnit.NANOSECONDS)).isFalse();
    }

    @Test
    public void shouldCombineOnePolicyWithNull() {
        AtomicBoolean commit = new AtomicBoolean(false);
        OffsetCommitPolicy policy1 = (num, time, unit) -> commit.get();
        Assertions.assertThat((Object)policy1.and(null)).isSameAs((Object)policy1);
        Assertions.assertThat((Object)policy1.or(null)).isSameAs((Object)policy1);
    }
}

