/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.config;

import io.debezium.operator.api.config.ConfigMappable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class ConfigMapping {
    private final Map<Key, String> config = new HashMap<Key, String>();
    private final String prefix;

    public static ConfigMapping from(Map<String, ?> properties) {
        ConfigMapping config = ConfigMapping.empty();
        config.putAll(properties);
        return config;
    }

    public static ConfigMapping empty() {
        return new ConfigMapping(null);
    }

    public static ConfigMapping prefixed(String prefix) {
        return new ConfigMapping(prefix);
    }

    public ConfigMapping(String prefix) {
        this.prefix = prefix;
    }

    public ConfigMapping asAbsolute() {
        return ConfigMapping.prefixed(this.prefix).putAllAbs(this);
    }

    public ConfigMapping asRelative() {
        return ConfigMapping.prefixed(this.prefix).putAllRel(this);
    }

    public Map<String, String> getAsMapSimple() {
        return this.config.entrySet().stream().collect(Collectors.toMap(e -> ((Key)e.getKey()).name(), Map.Entry::getValue));
    }

    public Map<Key, String> getAsMap() {
        return this.config;
    }

    public String getAsString() {
        return this.config.entrySet().stream().map(e -> String.valueOf(e.getKey()) + "=" + (String)e.getValue()).sorted().collect(Collectors.joining(System.lineSeparator()));
    }

    public ConfigMapping rootValue(Object value) {
        this.putInternal(value, Key.root());
        return this;
    }

    public ConfigMapping put(String key, Object value) {
        this.putInternal(value, Key.rel(key));
        return this;
    }

    public ConfigMapping putAbs(String key, Object value) {
        this.putInternal(value, Key.abs(key));
        return this;
    }

    public ConfigMapping putAll(ConfigMappable resource) {
        return this.putAll(resource.asConfiguration());
    }

    public ConfigMapping putAll(String key, ConfigMappable resource) {
        return this.putAll(key, resource.asConfiguration());
    }

    public ConfigMapping putAll(ConfigMapping config) {
        config.getAsMap().forEach((key, value) -> this.putInternal(value, (Key)key));
        return this;
    }

    public ConfigMapping putAll(String key, ConfigMapping config) {
        config.getAsMap().forEach((subKey, value) -> this.putInternal(value, key, (Key)subKey));
        return this;
    }

    public ConfigMapping putAll(Map<String, ?> props) {
        props.forEach((key, value) -> this.putInternal(value, Key.rel(key)));
        return this;
    }

    public ConfigMapping putAllAbs(ConfigMapping config) {
        config.getAsMap().forEach((key, value) -> this.putInternal(value, key.asAbs()));
        return this;
    }

    public ConfigMapping putAllRel(ConfigMapping config) {
        config.getAsMap().forEach((key, value) -> this.putInternal(value, key.asRel()));
        return this;
    }

    public <T extends ConfigMappable> ConfigMapping putList(String key, List<T> items, String name) {
        if (items.isEmpty()) {
            return this;
        }
        record NamedItem(String name, ConfigMappable item) {
        }
        List<NamedItem> named = IntStream.range(0, items.size()).mapToObj(i -> new NamedItem(name + i, (ConfigMappable)items.get(i))).toList();
        named.stream().map(NamedItem::name).reduce((x, y) -> x + "," + y).ifPresent(names -> this.put(key, names));
        named.forEach(item -> this.putAll(key + "." + item.name, item.item));
        return this;
    }

    public <T extends ConfigMappable> ConfigMapping putMap(String key, Map<String, T> items) {
        items.keySet().stream().reduce((x, y) -> String.join((CharSequence)",", new CharSequence[0])).ifPresent(names -> this.put(key, names));
        items.forEach((name, item) -> this.putAll(key + "." + name, (ConfigMappable)item));
        return this;
    }

    private void putInternal(Object value, Key key) {
        this.putInternal(value, null, key);
    }

    private void putInternal(Object value, String key, Key subKey) {
        if (value == null) {
            return;
        }
        Key combined = this.prefix(key, subKey);
        this.config.put(combined, String.valueOf(value));
    }

    private Key prefix(String key, Key subKey) {
        if (subKey.type == KeyType.ABSOLUTE) {
            return subKey;
        }
        String combined = Stream.concat(Stream.of(this.prefix), Stream.of(key, subKey.name)).filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).collect(Collectors.joining("."));
        return Key.rel(combined);
    }

    public String md5Sum() {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            digest = md.digest(this.getAsString().getBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return this.toHex(digest);
    }

    private String toHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        for (byte b : bytes) {
            hex.append(String.format("%02x", b));
        }
        return hex.toString();
    }

    public String toString() {
        return this.config.toString();
    }

    public record Key(String name, KeyType type) {
        public static Key rel(String key) {
            return new Key(key, KeyType.RELATIVE);
        }

        public static Key abs(String key) {
            return new Key(key, KeyType.ABSOLUTE);
        }

        public static Key root() {
            return new Key(null, null);
        }

        public Key asAbs() {
            return Key.abs(this.name);
        }

        public Key asRel() {
            return Key.rel(this.name);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static enum KeyType {
        RELATIVE,
        ABSOLUTE;

    }
}

