/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model;

import io.debezium.operator.api.model.DebeziumServerSpec;
import io.debezium.operator.api.model.Format;
import io.debezium.operator.api.model.FormatBuilder;
import io.debezium.operator.api.model.FormatFluent;
import io.debezium.operator.api.model.Predicate;
import io.debezium.operator.api.model.Quarkus;
import io.debezium.operator.api.model.QuarkusBuilder;
import io.debezium.operator.api.model.QuarkusFluent;
import io.debezium.operator.api.model.Sink;
import io.debezium.operator.api.model.SinkBuilder;
import io.debezium.operator.api.model.SinkFluent;
import io.debezium.operator.api.model.Transformation;
import io.debezium.operator.api.model.TransformationBuilder;
import io.debezium.operator.api.model.TransformationFluent;
import io.debezium.operator.api.model.runtime.Runtime;
import io.debezium.operator.api.model.runtime.RuntimeBuilder;
import io.debezium.operator.api.model.runtime.RuntimeFluent;
import io.debezium.operator.api.model.source.Source;
import io.debezium.operator.api.model.source.SourceBuilder;
import io.debezium.operator.api.model.source.SourceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DebeziumServerSpecFluent<A extends DebeziumServerSpecFluent<A>>
extends BaseFluent<A> {
    private String image;
    private String version;
    private SinkBuilder sink;
    private SourceBuilder source;
    private FormatBuilder format;
    private QuarkusBuilder quarkus;
    private RuntimeBuilder runtime;
    private ArrayList<TransformationBuilder> transforms = new ArrayList();
    private Map<String, Predicate> predicates;

    public DebeziumServerSpecFluent() {
    }

    public DebeziumServerSpecFluent(DebeziumServerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DebeziumServerSpec instance) {
        DebeziumServerSpec debeziumServerSpec = instance = instance != null ? instance : new DebeziumServerSpec();
        if (instance != null) {
            this.withImage(instance.getImage());
            this.withVersion(instance.getVersion());
            this.withSink(instance.getSink());
            this.withSource(instance.getSource());
            this.withFormat(instance.getFormat());
            this.withQuarkus(instance.getQuarkus());
            this.withRuntime(instance.getRuntime());
            this.withTransforms(instance.getTransforms());
            this.withPredicates(instance.getPredicates());
        }
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public Sink buildSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    public A withSink(Sink sink) {
        this._visitables.remove((Object)"sink");
        if (sink != null) {
            this.sink = new SinkBuilder(sink);
            this._visitables.get((Object)"sink").add(this.sink);
        } else {
            this.sink = null;
            this._visitables.get((Object)"sink").remove((Object)this.sink);
        }
        return (A)((Object)this);
    }

    public boolean hasSink() {
        return this.sink != null;
    }

    public SinkNested<A> withNewSink() {
        return new SinkNested(null);
    }

    public SinkNested<A> withNewSinkLike(Sink item) {
        return new SinkNested(item);
    }

    public SinkNested<A> editSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(null));
    }

    public SinkNested<A> editOrNewSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(new SinkBuilder().build()));
    }

    public SinkNested<A> editOrNewSinkLike(Sink item) {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(item));
    }

    public Source buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(Source source) {
        this._visitables.remove((Object)"source");
        if (source != null) {
            this.source = new SourceBuilder(source);
            this._visitables.get((Object)"source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get((Object)"source").remove((Object)this.source);
        }
        return (A)((Object)this);
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(Source item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new SourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(Source item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    public Format buildFormat() {
        return this.format != null ? this.format.build() : null;
    }

    public A withFormat(Format format) {
        this._visitables.remove((Object)"format");
        if (format != null) {
            this.format = new FormatBuilder(format);
            this._visitables.get((Object)"format").add(this.format);
        } else {
            this.format = null;
            this._visitables.get((Object)"format").remove((Object)this.format);
        }
        return (A)((Object)this);
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    public FormatNested<A> withNewFormat() {
        return new FormatNested(null);
    }

    public FormatNested<A> withNewFormatLike(Format item) {
        return new FormatNested(item);
    }

    public FormatNested<A> editFormat() {
        return this.withNewFormatLike(Optional.ofNullable(this.buildFormat()).orElse(null));
    }

    public FormatNested<A> editOrNewFormat() {
        return this.withNewFormatLike(Optional.ofNullable(this.buildFormat()).orElse(new FormatBuilder().build()));
    }

    public FormatNested<A> editOrNewFormatLike(Format item) {
        return this.withNewFormatLike(Optional.ofNullable(this.buildFormat()).orElse(item));
    }

    public Quarkus buildQuarkus() {
        return this.quarkus != null ? this.quarkus.build() : null;
    }

    public A withQuarkus(Quarkus quarkus) {
        this._visitables.remove((Object)"quarkus");
        if (quarkus != null) {
            this.quarkus = new QuarkusBuilder(quarkus);
            this._visitables.get((Object)"quarkus").add(this.quarkus);
        } else {
            this.quarkus = null;
            this._visitables.get((Object)"quarkus").remove((Object)this.quarkus);
        }
        return (A)((Object)this);
    }

    public boolean hasQuarkus() {
        return this.quarkus != null;
    }

    public QuarkusNested<A> withNewQuarkus() {
        return new QuarkusNested(null);
    }

    public QuarkusNested<A> withNewQuarkusLike(Quarkus item) {
        return new QuarkusNested(item);
    }

    public QuarkusNested<A> editQuarkus() {
        return this.withNewQuarkusLike(Optional.ofNullable(this.buildQuarkus()).orElse(null));
    }

    public QuarkusNested<A> editOrNewQuarkus() {
        return this.withNewQuarkusLike(Optional.ofNullable(this.buildQuarkus()).orElse(new QuarkusBuilder().build()));
    }

    public QuarkusNested<A> editOrNewQuarkusLike(Quarkus item) {
        return this.withNewQuarkusLike(Optional.ofNullable(this.buildQuarkus()).orElse(item));
    }

    public Runtime buildRuntime() {
        return this.runtime != null ? this.runtime.build() : null;
    }

    public A withRuntime(Runtime runtime) {
        this._visitables.remove((Object)"runtime");
        if (runtime != null) {
            this.runtime = new RuntimeBuilder(runtime);
            this._visitables.get((Object)"runtime").add(this.runtime);
        } else {
            this.runtime = null;
            this._visitables.get((Object)"runtime").remove((Object)this.runtime);
        }
        return (A)((Object)this);
    }

    public boolean hasRuntime() {
        return this.runtime != null;
    }

    public RuntimeNested<A> withNewRuntime() {
        return new RuntimeNested(null);
    }

    public RuntimeNested<A> withNewRuntimeLike(Runtime item) {
        return new RuntimeNested(item);
    }

    public RuntimeNested<A> editRuntime() {
        return this.withNewRuntimeLike(Optional.ofNullable(this.buildRuntime()).orElse(null));
    }

    public RuntimeNested<A> editOrNewRuntime() {
        return this.withNewRuntimeLike(Optional.ofNullable(this.buildRuntime()).orElse(new RuntimeBuilder().build()));
    }

    public RuntimeNested<A> editOrNewRuntimeLike(Runtime item) {
        return this.withNewRuntimeLike(Optional.ofNullable(this.buildRuntime()).orElse(item));
    }

    public A addToTransforms(int index, Transformation item) {
        if (this.transforms == null) {
            this.transforms = new ArrayList();
        }
        TransformationBuilder builder = new TransformationBuilder(item);
        if (index < 0 || index >= this.transforms.size()) {
            this._visitables.get((Object)"transforms").add(builder);
            this.transforms.add(builder);
        } else {
            this._visitables.get((Object)"transforms").add(index, builder);
            this.transforms.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTransforms(int index, Transformation item) {
        if (this.transforms == null) {
            this.transforms = new ArrayList();
        }
        TransformationBuilder builder = new TransformationBuilder(item);
        if (index < 0 || index >= this.transforms.size()) {
            this._visitables.get((Object)"transforms").add(builder);
            this.transforms.add(builder);
        } else {
            this._visitables.get((Object)"transforms").set(index, builder);
            this.transforms.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTransforms(Transformation ... items) {
        if (this.transforms == null) {
            this.transforms = new ArrayList();
        }
        for (Transformation item : items) {
            TransformationBuilder builder = new TransformationBuilder(item);
            this._visitables.get((Object)"transforms").add(builder);
            this.transforms.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTransforms(Collection<Transformation> items) {
        if (this.transforms == null) {
            this.transforms = new ArrayList();
        }
        for (Transformation item : items) {
            TransformationBuilder builder = new TransformationBuilder(item);
            this._visitables.get((Object)"transforms").add(builder);
            this.transforms.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTransforms(Transformation ... items) {
        if (this.transforms == null) {
            return (A)((Object)this);
        }
        for (Transformation item : items) {
            TransformationBuilder builder = new TransformationBuilder(item);
            this._visitables.get((Object)"transforms").remove((Object)builder);
            this.transforms.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTransforms(Collection<Transformation> items) {
        if (this.transforms == null) {
            return (A)((Object)this);
        }
        for (Transformation item : items) {
            TransformationBuilder builder = new TransformationBuilder(item);
            this._visitables.get((Object)"transforms").remove((Object)builder);
            this.transforms.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTransforms(java.util.function.Predicate<TransformationBuilder> predicate) {
        if (this.transforms == null) {
            return (A)((Object)this);
        }
        Iterator<TransformationBuilder> each = this.transforms.iterator();
        List visitables = this._visitables.get((Object)"transforms");
        while (each.hasNext()) {
            TransformationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Transformation> buildTransforms() {
        return this.transforms != null ? DebeziumServerSpecFluent.build(this.transforms) : null;
    }

    public Transformation buildTransform(int index) {
        return this.transforms.get(index).build();
    }

    public Transformation buildFirstTransform() {
        return this.transforms.get(0).build();
    }

    public Transformation buildLastTransform() {
        return this.transforms.get(this.transforms.size() - 1).build();
    }

    public Transformation buildMatchingTransform(java.util.function.Predicate<TransformationBuilder> predicate) {
        for (TransformationBuilder item : this.transforms) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTransform(java.util.function.Predicate<TransformationBuilder> predicate) {
        for (TransformationBuilder item : this.transforms) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTransforms(List<Transformation> transforms) {
        if (this.transforms != null) {
            this._visitables.get((Object)"transforms").clear();
        }
        if (transforms != null) {
            this.transforms = new ArrayList();
            for (Transformation item : transforms) {
                this.addToTransforms(item);
            }
        } else {
            this.transforms = null;
        }
        return (A)((Object)this);
    }

    public A withTransforms(Transformation ... transforms) {
        if (this.transforms != null) {
            this.transforms.clear();
            this._visitables.remove((Object)"transforms");
        }
        if (transforms != null) {
            for (Transformation item : transforms) {
                this.addToTransforms(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTransforms() {
        return this.transforms != null && !this.transforms.isEmpty();
    }

    public TransformsNested<A> addNewTransform() {
        return new TransformsNested(-1, null);
    }

    public TransformsNested<A> addNewTransformLike(Transformation item) {
        return new TransformsNested(-1, item);
    }

    public TransformsNested<A> setNewTransformLike(int index, Transformation item) {
        return new TransformsNested(index, item);
    }

    public TransformsNested<A> editTransform(int index) {
        if (this.transforms.size() <= index) {
            throw new RuntimeException("Can't edit transforms. Index exceeds size.");
        }
        return this.setNewTransformLike(index, this.buildTransform(index));
    }

    public TransformsNested<A> editFirstTransform() {
        if (this.transforms.size() == 0) {
            throw new RuntimeException("Can't edit first transforms. The list is empty.");
        }
        return this.setNewTransformLike(0, this.buildTransform(0));
    }

    public TransformsNested<A> editLastTransform() {
        int index = this.transforms.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last transforms. The list is empty.");
        }
        return this.setNewTransformLike(index, this.buildTransform(index));
    }

    public TransformsNested<A> editMatchingTransform(java.util.function.Predicate<TransformationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.transforms.size(); ++i) {
            if (!predicate.test(this.transforms.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching transforms. No match found.");
        }
        return this.setNewTransformLike(index, this.buildTransform(index));
    }

    public A addToPredicates(String key, Predicate value) {
        if (this.predicates == null && key != null && value != null) {
            this.predicates = new LinkedHashMap<String, Predicate>();
        }
        if (key != null && value != null) {
            this.predicates.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPredicates(Map<String, Predicate> map) {
        if (this.predicates == null && map != null) {
            this.predicates = new LinkedHashMap<String, Predicate>();
        }
        if (map != null) {
            this.predicates.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromPredicates(String key) {
        if (this.predicates == null) {
            return (A)((Object)this);
        }
        if (key != null && this.predicates != null) {
            this.predicates.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromPredicates(Map<String, Predicate> map) {
        if (this.predicates == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.predicates == null) continue;
                this.predicates.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Predicate> getPredicates() {
        return this.predicates;
    }

    public <K, V> A withPredicates(Map<String, Predicate> predicates) {
        this.predicates = predicates == null ? null : new LinkedHashMap<String, Predicate>(predicates);
        return (A)((Object)this);
    }

    public boolean hasPredicates() {
        return this.predicates != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DebeziumServerSpecFluent that = (DebeziumServerSpecFluent)((Object)o);
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals((Object)this.sink, (Object)that.sink)) {
            return false;
        }
        if (!Objects.equals((Object)this.source, (Object)that.source)) {
            return false;
        }
        if (!Objects.equals((Object)this.format, (Object)that.format)) {
            return false;
        }
        if (!Objects.equals((Object)this.quarkus, (Object)that.quarkus)) {
            return false;
        }
        if (!Objects.equals((Object)this.runtime, (Object)that.runtime)) {
            return false;
        }
        if (!Objects.equals(this.transforms, that.transforms)) {
            return false;
        }
        return Objects.equals(this.predicates, that.predicates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.image, this.version, this.sink, this.source, this.format, this.quarkus, this.runtime, this.transforms, this.predicates, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append(String.valueOf((Object)this.sink) + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(String.valueOf((Object)this.source) + ",");
        }
        if (this.format != null) {
            sb.append("format:");
            sb.append(String.valueOf((Object)this.format) + ",");
        }
        if (this.quarkus != null) {
            sb.append("quarkus:");
            sb.append(String.valueOf((Object)this.quarkus) + ",");
        }
        if (this.runtime != null) {
            sb.append("runtime:");
            sb.append(String.valueOf((Object)this.runtime) + ",");
        }
        if (this.transforms != null && !this.transforms.isEmpty()) {
            sb.append("transforms:");
            sb.append(String.valueOf(this.transforms) + ",");
        }
        if (this.predicates != null && !this.predicates.isEmpty()) {
            sb.append("predicates:");
            sb.append(this.predicates);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SinkNested<N>
    extends SinkFluent<SinkNested<N>>
    implements Nested<N> {
        SinkBuilder builder;

        SinkNested(Sink item) {
            this.builder = new SinkBuilder(this, item);
        }

        public N and() {
            return (N)DebeziumServerSpecFluent.this.withSink(this.builder.build());
        }

        public N endSink() {
            return this.and();
        }
    }

    public class SourceNested<N>
    extends SourceFluent<SourceNested<N>>
    implements Nested<N> {
        SourceBuilder builder;

        SourceNested(Source item) {
            this.builder = new SourceBuilder(this, item);
        }

        public N and() {
            return (N)DebeziumServerSpecFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }

    public class FormatNested<N>
    extends FormatFluent<FormatNested<N>>
    implements Nested<N> {
        FormatBuilder builder;

        FormatNested(Format item) {
            this.builder = new FormatBuilder(this, item);
        }

        public N and() {
            return (N)DebeziumServerSpecFluent.this.withFormat(this.builder.build());
        }

        public N endFormat() {
            return this.and();
        }
    }

    public class QuarkusNested<N>
    extends QuarkusFluent<QuarkusNested<N>>
    implements Nested<N> {
        QuarkusBuilder builder;

        QuarkusNested(Quarkus item) {
            this.builder = new QuarkusBuilder(this, item);
        }

        public N and() {
            return (N)DebeziumServerSpecFluent.this.withQuarkus(this.builder.build());
        }

        public N endQuarkus() {
            return this.and();
        }
    }

    public class RuntimeNested<N>
    extends RuntimeFluent<RuntimeNested<N>>
    implements Nested<N> {
        RuntimeBuilder builder;

        RuntimeNested(Runtime item) {
            this.builder = new RuntimeBuilder(this, item);
        }

        public N and() {
            return (N)DebeziumServerSpecFluent.this.withRuntime(this.builder.build());
        }

        public N endRuntime() {
            return this.and();
        }
    }

    public class TransformsNested<N>
    extends TransformationFluent<TransformsNested<N>>
    implements Nested<N> {
        TransformationBuilder builder;
        int index;

        TransformsNested(int index, Transformation item) {
            this.index = index;
            this.builder = new TransformationBuilder(this, item);
        }

        public N and() {
            return (N)DebeziumServerSpecFluent.this.setToTransforms(this.index, this.builder.build());
        }

        public N endTransform() {
            return this.and();
        }
    }
}

