/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.runtime;

import io.debezium.operator.api.model.runtime.Runtime;
import io.debezium.operator.api.model.runtime.RuntimeEnvironment;
import io.debezium.operator.api.model.runtime.jmx.JmxConfig;
import io.debezium.operator.api.model.runtime.jmx.JmxConfigBuilder;
import io.debezium.operator.api.model.runtime.jmx.JmxConfigFluent;
import io.debezium.operator.api.model.runtime.metrics.Metrics;
import io.debezium.operator.api.model.runtime.metrics.MetricsBuilder;
import io.debezium.operator.api.model.runtime.metrics.MetricsFluent;
import io.debezium.operator.api.model.runtime.storage.RuntimeStorage;
import io.debezium.operator.api.model.runtime.templates.Templates;
import io.debezium.operator.api.model.runtime.templates.TemplatesBuilder;
import io.debezium.operator.api.model.runtime.templates.TemplatesFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class RuntimeFluent<A extends RuntimeFluent<A>>
extends BaseFluent<A> {
    private RuntimeStorage storage;
    private RuntimeEnvironment environment;
    private JmxConfigBuilder jmx;
    private TemplatesBuilder templates;
    private String serviceAccount;
    private MetricsBuilder metrics;

    public RuntimeFluent() {
    }

    public RuntimeFluent(Runtime instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Runtime instance) {
        Runtime runtime = instance = instance != null ? instance : new Runtime();
        if (instance != null) {
            this.withStorage(instance.getStorage());
            this.withEnvironment(instance.getEnvironment());
            this.withJmx(instance.getJmx());
            this.withTemplates(instance.getTemplates());
            this.withServiceAccount(instance.getServiceAccount());
            this.withMetrics(instance.getMetrics());
        }
    }

    public RuntimeStorage getStorage() {
        return this.storage;
    }

    public A withStorage(RuntimeStorage storage) {
        this.storage = storage;
        return (A)((Object)this);
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public RuntimeEnvironment getEnvironment() {
        return this.environment;
    }

    public A withEnvironment(RuntimeEnvironment environment) {
        this.environment = environment;
        return (A)((Object)this);
    }

    public boolean hasEnvironment() {
        return this.environment != null;
    }

    public JmxConfig buildJmx() {
        return this.jmx != null ? this.jmx.build() : null;
    }

    public A withJmx(JmxConfig jmx) {
        this._visitables.remove((Object)"jmx");
        if (jmx != null) {
            this.jmx = new JmxConfigBuilder(jmx);
            this._visitables.get((Object)"jmx").add(this.jmx);
        } else {
            this.jmx = null;
            this._visitables.get((Object)"jmx").remove((Object)this.jmx);
        }
        return (A)((Object)this);
    }

    public boolean hasJmx() {
        return this.jmx != null;
    }

    public JmxNested<A> withNewJmx() {
        return new JmxNested(null);
    }

    public JmxNested<A> withNewJmxLike(JmxConfig item) {
        return new JmxNested(item);
    }

    public JmxNested<A> editJmx() {
        return this.withNewJmxLike(Optional.ofNullable(this.buildJmx()).orElse(null));
    }

    public JmxNested<A> editOrNewJmx() {
        return this.withNewJmxLike(Optional.ofNullable(this.buildJmx()).orElse(new JmxConfigBuilder().build()));
    }

    public JmxNested<A> editOrNewJmxLike(JmxConfig item) {
        return this.withNewJmxLike(Optional.ofNullable(this.buildJmx()).orElse(item));
    }

    public Templates buildTemplates() {
        return this.templates != null ? this.templates.build() : null;
    }

    public A withTemplates(Templates templates) {
        this._visitables.remove((Object)"templates");
        if (templates != null) {
            this.templates = new TemplatesBuilder(templates);
            this._visitables.get((Object)"templates").add(this.templates);
        } else {
            this.templates = null;
            this._visitables.get((Object)"templates").remove((Object)this.templates);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplates() {
        return this.templates != null;
    }

    public TemplatesNested<A> withNewTemplates() {
        return new TemplatesNested(null);
    }

    public TemplatesNested<A> withNewTemplatesLike(Templates item) {
        return new TemplatesNested(item);
    }

    public TemplatesNested<A> editTemplates() {
        return this.withNewTemplatesLike(Optional.ofNullable(this.buildTemplates()).orElse(null));
    }

    public TemplatesNested<A> editOrNewTemplates() {
        return this.withNewTemplatesLike(Optional.ofNullable(this.buildTemplates()).orElse(new TemplatesBuilder().build()));
    }

    public TemplatesNested<A> editOrNewTemplatesLike(Templates item) {
        return this.withNewTemplatesLike(Optional.ofNullable(this.buildTemplates()).orElse(item));
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public Metrics buildMetrics() {
        return this.metrics != null ? this.metrics.build() : null;
    }

    public A withMetrics(Metrics metrics) {
        this._visitables.remove((Object)"metrics");
        if (metrics != null) {
            this.metrics = new MetricsBuilder(metrics);
            this._visitables.get((Object)"metrics").add(this.metrics);
        } else {
            this.metrics = null;
            this._visitables.get((Object)"metrics").remove((Object)this.metrics);
        }
        return (A)((Object)this);
    }

    public boolean hasMetrics() {
        return this.metrics != null;
    }

    public MetricsNested<A> withNewMetrics() {
        return new MetricsNested(null);
    }

    public MetricsNested<A> withNewMetricsLike(Metrics item) {
        return new MetricsNested(item);
    }

    public MetricsNested<A> editMetrics() {
        return this.withNewMetricsLike(Optional.ofNullable(this.buildMetrics()).orElse(null));
    }

    public MetricsNested<A> editOrNewMetrics() {
        return this.withNewMetricsLike(Optional.ofNullable(this.buildMetrics()).orElse(new MetricsBuilder().build()));
    }

    public MetricsNested<A> editOrNewMetricsLike(Metrics item) {
        return this.withNewMetricsLike(Optional.ofNullable(this.buildMetrics()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuntimeFluent that = (RuntimeFluent)((Object)o);
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.environment, that.environment)) {
            return false;
        }
        if (!Objects.equals((Object)this.jmx, (Object)that.jmx)) {
            return false;
        }
        if (!Objects.equals((Object)this.templates, (Object)that.templates)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        return Objects.equals((Object)this.metrics, (Object)that.metrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.storage, this.environment, this.jmx, this.templates, this.serviceAccount, this.metrics, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(String.valueOf(this.storage) + ",");
        }
        if (this.environment != null) {
            sb.append("environment:");
            sb.append(String.valueOf(this.environment) + ",");
        }
        if (this.jmx != null) {
            sb.append("jmx:");
            sb.append(String.valueOf((Object)this.jmx) + ",");
        }
        if (this.templates != null) {
            sb.append("templates:");
            sb.append(String.valueOf((Object)this.templates) + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.metrics != null) {
            sb.append("metrics:");
            sb.append((Object)this.metrics);
        }
        sb.append("}");
        return sb.toString();
    }

    public class JmxNested<N>
    extends JmxConfigFluent<JmxNested<N>>
    implements Nested<N> {
        JmxConfigBuilder builder;

        JmxNested(JmxConfig item) {
            this.builder = new JmxConfigBuilder(this, item);
        }

        public N and() {
            return (N)RuntimeFluent.this.withJmx(this.builder.build());
        }

        public N endJmx() {
            return this.and();
        }
    }

    public class TemplatesNested<N>
    extends TemplatesFluent<TemplatesNested<N>>
    implements Nested<N> {
        TemplatesBuilder builder;

        TemplatesNested(Templates item) {
            this.builder = new TemplatesBuilder(this, item);
        }

        public N and() {
            return (N)RuntimeFluent.this.withTemplates(this.builder.build());
        }

        public N endTemplates() {
            return this.and();
        }
    }

    public class MetricsNested<N>
    extends MetricsFluent<MetricsNested<N>>
    implements Nested<N> {
        MetricsBuilder builder;

        MetricsNested(Metrics item) {
            this.builder = new MetricsBuilder(this, item);
        }

        public N and() {
            return (N)RuntimeFluent.this.withMetrics(this.builder.build());
        }

        public N endMetrics() {
            return this.and();
        }
    }
}

