/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.debezium.operator.api.config.ConfigMappable;
import io.debezium.operator.api.config.ConfigMapping;
import io.debezium.operator.api.model.source.storage.CustomStore;
import io.debezium.operator.api.model.source.storage.Store;
import io.debezium.operator.api.model.source.storage.offset.FileOffsetStore;
import io.debezium.operator.api.model.source.storage.offset.InMemoryOffsetStore;
import io.debezium.operator.api.model.source.storage.offset.KafkaOffsetStore;
import io.debezium.operator.api.model.source.storage.offset.RedisOffsetStore;
import java.util.Objects;
import java.util.stream.Stream;

public class Offset
implements ConfigMappable {
    @JsonPropertyDescription(value="File backed offset store configuration")
    private FileOffsetStore file;
    @JsonPropertyDescription(value="Memory backed offset store configuration")
    private InMemoryOffsetStore memory;
    @JsonPropertyDescription(value="Redis backed offset store configuration")
    private RedisOffsetStore redis;
    @JsonPropertyDescription(value="Kafka backing store configuration")
    private KafkaOffsetStore kafka;
    @JsonPropertyDescription(value="Arbitrary offset store configuration")
    private CustomStore store;
    @JsonPropertyDescription(value="Interval at which to try commiting offsets")
    @JsonProperty(defaultValue="60000")
    private long flushMs = 60000L;

    public long getFlushMs() {
        return this.flushMs;
    }

    public void setFlushMs(long flushMs) {
        this.flushMs = flushMs;
    }

    public FileOffsetStore getFile() {
        return this.file;
    }

    public void setFile(FileOffsetStore file) {
        this.file = file;
    }

    public InMemoryOffsetStore getMemory() {
        return this.memory;
    }

    public void setMemory(InMemoryOffsetStore memory) {
        this.memory = memory;
    }

    public RedisOffsetStore getRedis() {
        return this.redis;
    }

    public void setRedis(RedisOffsetStore redis) {
        this.redis = redis;
    }

    public KafkaOffsetStore getKafka() {
        return this.kafka;
    }

    public void setKafka(KafkaOffsetStore kafka) {
        this.kafka = kafka;
    }

    public CustomStore getStore() {
        return this.store;
    }

    public void setStore(CustomStore store) {
        this.store = store;
    }

    @JsonIgnore
    public Store getActiveStore() {
        return Stream.of(this.file, this.memory, this.redis, this.kafka, this.store).filter(Objects::nonNull).findFirst().orElseGet(InMemoryOffsetStore::new);
    }

    @Override
    public ConfigMapping asConfiguration() {
        return ConfigMapping.empty().put("flush.interval.ms", this.flushMs).putAll("storage", this.getActiveStore());
    }
}

