/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.debezium.operator.api.config.ConfigMappable;
import io.debezium.operator.api.config.ConfigMapping;
import io.debezium.operator.api.model.ConfigProperties;
import io.debezium.operator.api.model.source.storage.CustomStore;
import io.debezium.operator.api.model.source.storage.Store;
import io.debezium.operator.api.model.source.storage.schema.FileSchemaHistoryStore;
import io.debezium.operator.api.model.source.storage.schema.InMemorySchemaHistoryStore;
import io.debezium.operator.api.model.source.storage.schema.KafkaSchemaHistoryStore;
import io.debezium.operator.api.model.source.storage.schema.RedisSchemaHistoryStore;
import java.util.Objects;
import java.util.stream.Stream;

public class SchemaHistory
implements ConfigMappable {
    @JsonPropertyDescription(value="File backed schema history store configuration")
    private FileSchemaHistoryStore file;
    @JsonPropertyDescription(value="Memory backed schema history store configuration")
    private InMemorySchemaHistoryStore memory;
    @JsonPropertyDescription(value="Redis backed schema history store configuration")
    private RedisSchemaHistoryStore redis;
    @JsonPropertyDescription(value="Kafka backed schema history store configuration")
    private KafkaSchemaHistoryStore kafka;
    @JsonPropertyDescription(value="Arbitrary schema history store configuration")
    private CustomStore store;
    @JsonPropertyDescription(value="Additional common schema history store configuration properties.")
    private ConfigProperties config = new ConfigProperties();

    public FileSchemaHistoryStore getFile() {
        return this.file;
    }

    public void setFile(FileSchemaHistoryStore file) {
        this.file = file;
    }

    public InMemorySchemaHistoryStore getMemory() {
        return this.memory;
    }

    public void setMemory(InMemorySchemaHistoryStore memory) {
        this.memory = memory;
    }

    public RedisSchemaHistoryStore getRedis() {
        return this.redis;
    }

    public void setRedis(RedisSchemaHistoryStore redis) {
        this.redis = redis;
    }

    public KafkaSchemaHistoryStore getKafka() {
        return this.kafka;
    }

    public void setKafka(KafkaSchemaHistoryStore kafka) {
        this.kafka = kafka;
    }

    public CustomStore getStore() {
        return this.store;
    }

    public void setStore(CustomStore store) {
        this.store = store;
    }

    public ConfigProperties getConfig() {
        return this.config;
    }

    public void setConfig(ConfigProperties config) {
        this.config = config;
    }

    @JsonIgnore
    public Store getActiveStore() {
        return Stream.of(this.file, this.memory, this.redis, this.kafka, this.store).filter(Objects::nonNull).findFirst().orElseGet(InMemorySchemaHistoryStore::new);
    }

    @Override
    public ConfigMapping asConfiguration() {
        return ConfigMapping.empty().putAll(this.config).putAll(this.getActiveStore());
    }
}

