/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source;

import io.debezium.operator.api.model.ConfigProperties;
import io.debezium.operator.api.model.source.SchemaHistory;
import io.debezium.operator.api.model.source.storage.CustomStore;
import io.debezium.operator.api.model.source.storage.CustomStoreBuilder;
import io.debezium.operator.api.model.source.storage.CustomStoreFluent;
import io.debezium.operator.api.model.source.storage.schema.FileSchemaHistoryStore;
import io.debezium.operator.api.model.source.storage.schema.FileSchemaHistoryStoreBuilder;
import io.debezium.operator.api.model.source.storage.schema.FileSchemaHistoryStoreFluent;
import io.debezium.operator.api.model.source.storage.schema.InMemorySchemaHistoryStore;
import io.debezium.operator.api.model.source.storage.schema.InMemorySchemaHistoryStoreBuilder;
import io.debezium.operator.api.model.source.storage.schema.InMemorySchemaHistoryStoreFluent;
import io.debezium.operator.api.model.source.storage.schema.KafkaSchemaHistoryStore;
import io.debezium.operator.api.model.source.storage.schema.KafkaSchemaHistoryStoreBuilder;
import io.debezium.operator.api.model.source.storage.schema.KafkaSchemaHistoryStoreFluent;
import io.debezium.operator.api.model.source.storage.schema.RedisSchemaHistoryStore;
import io.debezium.operator.api.model.source.storage.schema.RedisSchemaHistoryStoreBuilder;
import io.debezium.operator.api.model.source.storage.schema.RedisSchemaHistoryStoreFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class SchemaHistoryFluent<A extends SchemaHistoryFluent<A>>
extends BaseFluent<A> {
    private FileSchemaHistoryStoreBuilder file;
    private InMemorySchemaHistoryStoreBuilder memory;
    private RedisSchemaHistoryStoreBuilder redis;
    private KafkaSchemaHistoryStoreBuilder kafka;
    private CustomStoreBuilder store;
    private ConfigProperties config;

    public SchemaHistoryFluent() {
    }

    public SchemaHistoryFluent(SchemaHistory instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SchemaHistory instance) {
        SchemaHistory schemaHistory = instance = instance != null ? instance : new SchemaHistory();
        if (instance != null) {
            this.withFile(instance.getFile());
            this.withMemory(instance.getMemory());
            this.withRedis(instance.getRedis());
            this.withKafka(instance.getKafka());
            this.withStore(instance.getStore());
            this.withConfig(instance.getConfig());
        }
    }

    public FileSchemaHistoryStore buildFile() {
        return this.file != null ? this.file.build() : null;
    }

    public A withFile(FileSchemaHistoryStore file) {
        this._visitables.remove((Object)"file");
        if (file != null) {
            this.file = new FileSchemaHistoryStoreBuilder(file);
            this._visitables.get((Object)"file").add(this.file);
        } else {
            this.file = null;
            this._visitables.get((Object)"file").remove((Object)this.file);
        }
        return (A)((Object)this);
    }

    public boolean hasFile() {
        return this.file != null;
    }

    public FileNested<A> withNewFile() {
        return new FileNested(null);
    }

    public FileNested<A> withNewFileLike(FileSchemaHistoryStore item) {
        return new FileNested(item);
    }

    public FileNested<A> editFile() {
        return this.withNewFileLike(Optional.ofNullable(this.buildFile()).orElse(null));
    }

    public FileNested<A> editOrNewFile() {
        return this.withNewFileLike(Optional.ofNullable(this.buildFile()).orElse(new FileSchemaHistoryStoreBuilder().build()));
    }

    public FileNested<A> editOrNewFileLike(FileSchemaHistoryStore item) {
        return this.withNewFileLike(Optional.ofNullable(this.buildFile()).orElse(item));
    }

    public InMemorySchemaHistoryStore buildMemory() {
        return this.memory != null ? this.memory.build() : null;
    }

    public A withMemory(InMemorySchemaHistoryStore memory) {
        this._visitables.remove((Object)"memory");
        if (memory != null) {
            this.memory = new InMemorySchemaHistoryStoreBuilder(memory);
            this._visitables.get((Object)"memory").add(this.memory);
        } else {
            this.memory = null;
            this._visitables.get((Object)"memory").remove((Object)this.memory);
        }
        return (A)((Object)this);
    }

    public boolean hasMemory() {
        return this.memory != null;
    }

    public MemoryNested<A> withNewMemory() {
        return new MemoryNested(null);
    }

    public MemoryNested<A> withNewMemoryLike(InMemorySchemaHistoryStore item) {
        return new MemoryNested(item);
    }

    public MemoryNested<A> editMemory() {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(null));
    }

    public MemoryNested<A> editOrNewMemory() {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(new InMemorySchemaHistoryStoreBuilder().build()));
    }

    public MemoryNested<A> editOrNewMemoryLike(InMemorySchemaHistoryStore item) {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(item));
    }

    public RedisSchemaHistoryStore buildRedis() {
        return this.redis != null ? this.redis.build() : null;
    }

    public A withRedis(RedisSchemaHistoryStore redis) {
        this._visitables.remove((Object)"redis");
        if (redis != null) {
            this.redis = new RedisSchemaHistoryStoreBuilder(redis);
            this._visitables.get((Object)"redis").add(this.redis);
        } else {
            this.redis = null;
            this._visitables.get((Object)"redis").remove((Object)this.redis);
        }
        return (A)((Object)this);
    }

    public boolean hasRedis() {
        return this.redis != null;
    }

    public RedisNested<A> withNewRedis() {
        return new RedisNested(null);
    }

    public RedisNested<A> withNewRedisLike(RedisSchemaHistoryStore item) {
        return new RedisNested(item);
    }

    public RedisNested<A> editRedis() {
        return this.withNewRedisLike(Optional.ofNullable(this.buildRedis()).orElse(null));
    }

    public RedisNested<A> editOrNewRedis() {
        return this.withNewRedisLike(Optional.ofNullable(this.buildRedis()).orElse(new RedisSchemaHistoryStoreBuilder().build()));
    }

    public RedisNested<A> editOrNewRedisLike(RedisSchemaHistoryStore item) {
        return this.withNewRedisLike(Optional.ofNullable(this.buildRedis()).orElse(item));
    }

    public KafkaSchemaHistoryStore buildKafka() {
        return this.kafka != null ? this.kafka.build() : null;
    }

    public A withKafka(KafkaSchemaHistoryStore kafka) {
        this._visitables.remove((Object)"kafka");
        if (kafka != null) {
            this.kafka = new KafkaSchemaHistoryStoreBuilder(kafka);
            this._visitables.get((Object)"kafka").add(this.kafka);
        } else {
            this.kafka = null;
            this._visitables.get((Object)"kafka").remove((Object)this.kafka);
        }
        return (A)((Object)this);
    }

    public boolean hasKafka() {
        return this.kafka != null;
    }

    public KafkaNested<A> withNewKafka() {
        return new KafkaNested(null);
    }

    public KafkaNested<A> withNewKafkaLike(KafkaSchemaHistoryStore item) {
        return new KafkaNested(item);
    }

    public KafkaNested<A> editKafka() {
        return this.withNewKafkaLike(Optional.ofNullable(this.buildKafka()).orElse(null));
    }

    public KafkaNested<A> editOrNewKafka() {
        return this.withNewKafkaLike(Optional.ofNullable(this.buildKafka()).orElse(new KafkaSchemaHistoryStoreBuilder().build()));
    }

    public KafkaNested<A> editOrNewKafkaLike(KafkaSchemaHistoryStore item) {
        return this.withNewKafkaLike(Optional.ofNullable(this.buildKafka()).orElse(item));
    }

    public CustomStore buildStore() {
        return this.store != null ? this.store.build() : null;
    }

    public A withStore(CustomStore store) {
        this._visitables.remove((Object)"store");
        if (store != null) {
            this.store = new CustomStoreBuilder(store);
            this._visitables.get((Object)"store").add(this.store);
        } else {
            this.store = null;
            this._visitables.get((Object)"store").remove((Object)this.store);
        }
        return (A)((Object)this);
    }

    public boolean hasStore() {
        return this.store != null;
    }

    public StoreNested<A> withNewStore() {
        return new StoreNested(null);
    }

    public StoreNested<A> withNewStoreLike(CustomStore item) {
        return new StoreNested(item);
    }

    public StoreNested<A> editStore() {
        return this.withNewStoreLike(Optional.ofNullable(this.buildStore()).orElse(null));
    }

    public StoreNested<A> editOrNewStore() {
        return this.withNewStoreLike(Optional.ofNullable(this.buildStore()).orElse(new CustomStoreBuilder().build()));
    }

    public StoreNested<A> editOrNewStoreLike(CustomStore item) {
        return this.withNewStoreLike(Optional.ofNullable(this.buildStore()).orElse(item));
    }

    public ConfigProperties getConfig() {
        return this.config;
    }

    public A withConfig(ConfigProperties config) {
        this.config = config;
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchemaHistoryFluent that = (SchemaHistoryFluent)((Object)o);
        if (!Objects.equals((Object)this.file, (Object)that.file)) {
            return false;
        }
        if (!Objects.equals((Object)this.memory, (Object)that.memory)) {
            return false;
        }
        if (!Objects.equals((Object)this.redis, (Object)that.redis)) {
            return false;
        }
        if (!Objects.equals((Object)this.kafka, (Object)that.kafka)) {
            return false;
        }
        if (!Objects.equals((Object)this.store, (Object)that.store)) {
            return false;
        }
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.file, this.memory, this.redis, this.kafka, this.store, this.config, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.file != null) {
            sb.append("file:");
            sb.append(String.valueOf((Object)this.file) + ",");
        }
        if (this.memory != null) {
            sb.append("memory:");
            sb.append(String.valueOf((Object)this.memory) + ",");
        }
        if (this.redis != null) {
            sb.append("redis:");
            sb.append(String.valueOf((Object)this.redis) + ",");
        }
        if (this.kafka != null) {
            sb.append("kafka:");
            sb.append(String.valueOf((Object)this.kafka) + ",");
        }
        if (this.store != null) {
            sb.append("store:");
            sb.append(String.valueOf((Object)this.store) + ",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append(this.config);
        }
        sb.append("}");
        return sb.toString();
    }

    public class FileNested<N>
    extends FileSchemaHistoryStoreFluent<FileNested<N>>
    implements Nested<N> {
        FileSchemaHistoryStoreBuilder builder;

        FileNested(FileSchemaHistoryStore item) {
            this.builder = new FileSchemaHistoryStoreBuilder(this, item);
        }

        public N and() {
            return (N)SchemaHistoryFluent.this.withFile(this.builder.build());
        }

        public N endFile() {
            return this.and();
        }
    }

    public class MemoryNested<N>
    extends InMemorySchemaHistoryStoreFluent<MemoryNested<N>>
    implements Nested<N> {
        InMemorySchemaHistoryStoreBuilder builder;

        MemoryNested(InMemorySchemaHistoryStore item) {
            this.builder = new InMemorySchemaHistoryStoreBuilder(this, item);
        }

        public N and() {
            return (N)SchemaHistoryFluent.this.withMemory(this.builder.build());
        }

        public N endMemory() {
            return this.and();
        }
    }

    public class RedisNested<N>
    extends RedisSchemaHistoryStoreFluent<RedisNested<N>>
    implements Nested<N> {
        RedisSchemaHistoryStoreBuilder builder;

        RedisNested(RedisSchemaHistoryStore item) {
            this.builder = new RedisSchemaHistoryStoreBuilder(this, item);
        }

        public N and() {
            return (N)SchemaHistoryFluent.this.withRedis(this.builder.build());
        }

        public N endRedis() {
            return this.and();
        }
    }

    public class KafkaNested<N>
    extends KafkaSchemaHistoryStoreFluent<KafkaNested<N>>
    implements Nested<N> {
        KafkaSchemaHistoryStoreBuilder builder;

        KafkaNested(KafkaSchemaHistoryStore item) {
            this.builder = new KafkaSchemaHistoryStoreBuilder(this, item);
        }

        public N and() {
            return (N)SchemaHistoryFluent.this.withKafka(this.builder.build());
        }

        public N endKafka() {
            return this.and();
        }
    }

    public class StoreNested<N>
    extends CustomStoreFluent<StoreNested<N>>
    implements Nested<N> {
        CustomStoreBuilder builder;

        StoreNested(CustomStore item) {
            this.builder = new CustomStoreBuilder(this, item);
        }

        public N and() {
            return (N)SchemaHistoryFluent.this.withStore(this.builder.build());
        }

        public N endStore() {
            return this.and();
        }
    }
}

