/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source;

import io.debezium.operator.api.model.ConfigProperties;
import io.debezium.operator.api.model.source.Offset;
import io.debezium.operator.api.model.source.OffsetBuilder;
import io.debezium.operator.api.model.source.OffsetFluent;
import io.debezium.operator.api.model.source.SchemaHistory;
import io.debezium.operator.api.model.source.SchemaHistoryBuilder;
import io.debezium.operator.api.model.source.SchemaHistoryFluent;
import io.debezium.operator.api.model.source.Source;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class SourceFluent<A extends SourceFluent<A>>
extends BaseFluent<A> {
    private String sourceClass;
    private OffsetBuilder offset;
    private SchemaHistoryBuilder schemaHistory;
    private ConfigProperties config;

    public SourceFluent() {
    }

    public SourceFluent(Source instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Source instance) {
        Source source = instance = instance != null ? instance : new Source();
        if (instance != null) {
            this.withSourceClass(instance.getSourceClass());
            this.withOffset(instance.getOffset());
            this.withSchemaHistory(instance.getSchemaHistory());
            this.withConfig(instance.getConfig());
        }
    }

    public String getSourceClass() {
        return this.sourceClass;
    }

    public A withSourceClass(String sourceClass) {
        this.sourceClass = sourceClass;
        return (A)((Object)this);
    }

    public boolean hasSourceClass() {
        return this.sourceClass != null;
    }

    public Offset buildOffset() {
        return this.offset != null ? this.offset.build() : null;
    }

    public A withOffset(Offset offset) {
        this._visitables.remove((Object)"offset");
        if (offset != null) {
            this.offset = new OffsetBuilder(offset);
            this._visitables.get((Object)"offset").add(this.offset);
        } else {
            this.offset = null;
            this._visitables.get((Object)"offset").remove((Object)this.offset);
        }
        return (A)((Object)this);
    }

    public boolean hasOffset() {
        return this.offset != null;
    }

    public OffsetNested<A> withNewOffset() {
        return new OffsetNested(null);
    }

    public OffsetNested<A> withNewOffsetLike(Offset item) {
        return new OffsetNested(item);
    }

    public OffsetNested<A> editOffset() {
        return this.withNewOffsetLike(Optional.ofNullable(this.buildOffset()).orElse(null));
    }

    public OffsetNested<A> editOrNewOffset() {
        return this.withNewOffsetLike(Optional.ofNullable(this.buildOffset()).orElse(new OffsetBuilder().build()));
    }

    public OffsetNested<A> editOrNewOffsetLike(Offset item) {
        return this.withNewOffsetLike(Optional.ofNullable(this.buildOffset()).orElse(item));
    }

    public SchemaHistory buildSchemaHistory() {
        return this.schemaHistory != null ? this.schemaHistory.build() : null;
    }

    public A withSchemaHistory(SchemaHistory schemaHistory) {
        this._visitables.remove((Object)"schemaHistory");
        if (schemaHistory != null) {
            this.schemaHistory = new SchemaHistoryBuilder(schemaHistory);
            this._visitables.get((Object)"schemaHistory").add(this.schemaHistory);
        } else {
            this.schemaHistory = null;
            this._visitables.get((Object)"schemaHistory").remove((Object)this.schemaHistory);
        }
        return (A)((Object)this);
    }

    public boolean hasSchemaHistory() {
        return this.schemaHistory != null;
    }

    public SchemaHistoryNested<A> withNewSchemaHistory() {
        return new SchemaHistoryNested(null);
    }

    public SchemaHistoryNested<A> withNewSchemaHistoryLike(SchemaHistory item) {
        return new SchemaHistoryNested(item);
    }

    public SchemaHistoryNested<A> editSchemaHistory() {
        return this.withNewSchemaHistoryLike(Optional.ofNullable(this.buildSchemaHistory()).orElse(null));
    }

    public SchemaHistoryNested<A> editOrNewSchemaHistory() {
        return this.withNewSchemaHistoryLike(Optional.ofNullable(this.buildSchemaHistory()).orElse(new SchemaHistoryBuilder().build()));
    }

    public SchemaHistoryNested<A> editOrNewSchemaHistoryLike(SchemaHistory item) {
        return this.withNewSchemaHistoryLike(Optional.ofNullable(this.buildSchemaHistory()).orElse(item));
    }

    public ConfigProperties getConfig() {
        return this.config;
    }

    public A withConfig(ConfigProperties config) {
        this.config = config;
        return (A)((Object)this);
    }

    public boolean hasConfig() {
        return this.config != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceFluent that = (SourceFluent)((Object)o);
        if (!Objects.equals(this.sourceClass, that.sourceClass)) {
            return false;
        }
        if (!Objects.equals((Object)this.offset, (Object)that.offset)) {
            return false;
        }
        if (!Objects.equals((Object)this.schemaHistory, (Object)that.schemaHistory)) {
            return false;
        }
        return Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceClass, this.offset, this.schemaHistory, this.config, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceClass != null) {
            sb.append("sourceClass:");
            sb.append(this.sourceClass + ",");
        }
        if (this.offset != null) {
            sb.append("offset:");
            sb.append(String.valueOf((Object)this.offset) + ",");
        }
        if (this.schemaHistory != null) {
            sb.append("schemaHistory:");
            sb.append(String.valueOf((Object)this.schemaHistory) + ",");
        }
        if (this.config != null) {
            sb.append("config:");
            sb.append(this.config);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OffsetNested<N>
    extends OffsetFluent<OffsetNested<N>>
    implements Nested<N> {
        OffsetBuilder builder;

        OffsetNested(Offset item) {
            this.builder = new OffsetBuilder(this, item);
        }

        public N and() {
            return (N)SourceFluent.this.withOffset(this.builder.build());
        }

        public N endOffset() {
            return this.and();
        }
    }

    public class SchemaHistoryNested<N>
    extends SchemaHistoryFluent<SchemaHistoryNested<N>>
    implements Nested<N> {
        SchemaHistoryBuilder builder;

        SchemaHistoryNested(SchemaHistory item) {
            this.builder = new SchemaHistoryBuilder(this, item);
        }

        public N and() {
            return (N)SourceFluent.this.withSchemaHistory(this.builder.build());
        }

        public N endSchemaHistory() {
            return this.and();
        }
    }
}

