/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source.storage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.debezium.operator.api.config.ConfigMapping;
import io.debezium.operator.api.model.ConfigProperties;
import io.debezium.operator.api.model.source.storage.Store;

public abstract class AbstractStore
implements Store {
    @JsonIgnore
    protected final String type;
    @JsonIgnore
    protected final String configPrefix;
    @JsonPropertyDescription(value="Additional store configuration properties.")
    private ConfigProperties config = new ConfigProperties();

    public AbstractStore(String configPrefix, String type) {
        this.configPrefix = configPrefix;
        this.type = type;
    }

    public AbstractStore(String type) {
        this(null, type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public ConfigProperties getConfig() {
        return this.config;
    }

    public void setConfig(ConfigProperties config) {
        this.config = config;
    }

    @Override
    public ConfigMapping asConfiguration() {
        return ConfigMapping.empty().rootValue(this.type).putAll(this.configPrefix, this.config).putAll(this.configPrefix, this.typeConfiguration());
    }

    protected ConfigMapping typeConfiguration() {
        return ConfigMapping.empty();
    }
}

