/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source.storage;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.debezium.operator.api.config.ConfigMapping;
import io.debezium.operator.api.model.source.storage.AbstractStore;

public class KafkaStore
extends AbstractStore {
    @JsonPropertyDescription(value="A list of host/port pairs that the connector uses for establishing an initial connection to the Kafka cluster")
    private String bootstrapServers;
    @JsonPropertyDescription(value="The name of the Kafka topic where offsets are to be stored")
    private String topic;
    @JsonPropertyDescription(value="The number of partitions used when creating the offset storage topic")
    private int partitions;
    @JsonPropertyDescription(value="Replication factor used when creating the offset storage topic")
    private int replicationFactor;

    public KafkaStore(String type) {
        super(type);
    }

    public KafkaStore(String configPrefix, String type) {
        super(configPrefix, type);
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public void setPartitions(int partitions) {
        this.partitions = partitions;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Override
    public ConfigMapping typeConfiguration() {
        return ConfigMapping.empty().put("topic", this.topic).put("partitions", this.partitions).put("replication.factor", this.replicationFactor).putAll(this.kafkaProps());
    }

    protected ConfigMapping kafkaProps() {
        return ConfigMapping.empty().put("bootstrap.servers", this.bootstrapServers);
    }
}

