--
-- Statements recorded by binlog during MySQL 5.6 initialization with Debezium scripts.
--
CREATE DATABASE mysql;

CREATE TABLE IF NOT EXISTS db (   Host char(60) binary DEFAULT '' NOT NULL, Db char(64) binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Event_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, PRIMARY KEY Host (Host,Db,User), KEY User (User) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin comment='Database privileges';

CREATE TABLE IF NOT EXISTS user (   Host char(60) binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Select_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Insert_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Update_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Delete_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Drop_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Reload_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Shutdown_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Process_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, File_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Grant_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, References_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Index_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Alter_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Show_db_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Super_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_tmp_table_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Lock_tables_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Execute_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Repl_slave_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Repl_client_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Show_view_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Alter_routine_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_user_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Event_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Trigger_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, Create_tablespace_priv enum('N','Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, ssl_type enum('','ANY','X509', 'SPECIFIED') COLLATE utf8_general_ci DEFAULT '' NOT NULL, ssl_cipher BLOB NOT NULL, x509_issuer BLOB NOT NULL, x509_subject BLOB NOT NULL, max_questions int(11) unsigned DEFAULT 0  NOT NULL, max_updates int(11) unsigned DEFAULT 0  NOT NULL, max_connections int(11) unsigned DEFAULT 0  NOT NULL, max_user_connections int(11) unsigned DEFAULT 0  NOT NULL, plugin char(64) DEFAULT 'mysql_native_password' NOT NULL, authentication_string TEXT, password_expired ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, password_last_changed timestamp NULL DEFAULT NULL, password_lifetime smallint unsigned NULL DEFAULT NULL, account_locked ENUM('N', 'Y') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, PRIMARY KEY Host (Host,User) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin comment='Users and global privileges';

CREATE TABLE IF NOT EXISTS func (  name char(64) binary DEFAULT '' NOT NULL, ret tinyint(1) DEFAULT '0' NOT NULL, dl char(128) DEFAULT '' NOT NULL, type enum ('function','aggregate') COLLATE utf8_general_ci NOT NULL, PRIMARY KEY (name) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin   comment='User defined functions';

CREATE TABLE IF NOT EXISTS plugin ( name varchar(64) DEFAULT '' NOT NULL, dl varchar(128) DEFAULT '' NOT NULL, PRIMARY KEY (name) ) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 COLLATE utf8_general_ci comment='MySQL plugins';

CREATE TABLE IF NOT EXISTS servers ( Server_name char(64) NOT NULL DEFAULT '', Host char(64) NOT NULL DEFAULT '', Db char(64) NOT NULL DEFAULT '', Username char(64) NOT NULL DEFAULT '', Password char(64) NOT NULL DEFAULT '', Port INT(4) NOT NULL DEFAULT '0', Socket char(64) NOT NULL DEFAULT '', Wrapper char(64) NOT NULL DEFAULT '', Owner char(64) NOT NULL DEFAULT '', PRIMARY KEY (Server_name)) engine=InnoDB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='MySQL Foreign Servers table';

CREATE TABLE IF NOT EXISTS tables_priv ( Host char(60) binary DEFAULT '' NOT NULL, Db char(64) binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Table_name char(64) binary DEFAULT '' NOT NULL, Grantor char(77) DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, Table_priv set('Select','Insert','Update','Delete','Create','Drop','Grant','References','Index','Alter','Create View','Show view','Trigger') COLLATE utf8_general_ci DEFAULT '' NOT NULL, Column_priv set('Select','Insert','Update','References') COLLATE utf8_general_ci DEFAULT '' NOT NULL, PRIMARY KEY (Host,Db,User,Table_name), KEY Grantor (Grantor) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin   comment='Table privileges';

CREATE TABLE IF NOT EXISTS columns_priv ( Host char(60) binary DEFAULT '' NOT NULL, Db char(64) binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Table_name char(64) binary DEFAULT '' NOT NULL, Column_name char(64) binary DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, Column_priv set('Select','Insert','Update','References') COLLATE utf8_general_ci DEFAULT '' NOT NULL, PRIMARY KEY (Host,Db,User,Table_name,Column_name) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin   comment='Column privileges';

CREATE TABLE IF NOT EXISTS help_topic ( help_topic_id int unsigned not null, name char(64) not null, help_category_id smallint unsigned not null, description text not null, example text not null, url text not null, primary key (help_topic_id), unique index (name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='help topics';

CREATE TABLE IF NOT EXISTS help_category ( help_category_id smallint unsigned not null, name  char(64) not null, parent_category_id smallint unsigned null, url text not null, primary key (help_category_id), unique index (name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='help categories';

CREATE TABLE IF NOT EXISTS help_relation ( help_topic_id int unsigned not null, help_keyword_id  int unsigned not null, primary key (help_keyword_id, help_topic_id) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='keyword-topic relation';

CREATE TABLE IF NOT EXISTS help_keyword (   help_keyword_id  int unsigned not null, name char(64) not null, primary key (help_keyword_id), unique index (name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8 comment='help keywords';

CREATE TABLE IF NOT EXISTS time_zone_name (   Name char(64) NOT NULL, Time_zone_id int unsigned NOT NULL, PRIMARY KEY Name (Name) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comment='Time zone names';

CREATE TABLE IF NOT EXISTS time_zone (   Time_zone_id int unsigned NOT NULL auto_increment, Use_leap_seconds enum('Y','N') COLLATE utf8_general_ci DEFAULT 'N' NOT NULL, PRIMARY KEY TzId (Time_zone_id) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comment='Time zones';

CREATE TABLE IF NOT EXISTS time_zone_transition (   Time_zone_id int unsigned NOT NULL, Transition_time bigint signed NOT NULL, Transition_type_id int unsigned NOT NULL, PRIMARY KEY TzIdTranTime (Time_zone_id, Transition_time) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comment='Time zone transitions';

CREATE TABLE IF NOT EXISTS time_zone_transition_type (   Time_zone_id int unsigned NOT NULL, Transition_type_id int unsigned NOT NULL, Offset int signed DEFAULT 0 NOT NULL, Is_DST tinyint unsigned DEFAULT 0 NOT NULL, Abbreviation char(8) DEFAULT '' NOT NULL, PRIMARY KEY TzIdTrTId (Time_zone_id, Transition_type_id) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comment='Time zone transition types';

CREATE TABLE IF NOT EXISTS time_zone_leap_second (   Transition_time bigint signed NOT NULL, Correction int signed NOT NULL, PRIMARY KEY TranTime (Transition_time) ) engine=INNODB STATS_PERSISTENT=0 CHARACTER SET utf8   comment='Leap seconds information for time zones';

CREATE TABLE IF NOT EXISTS proc (db char(64) collate utf8_bin DEFAULT '' NOT NULL, name char(64) DEFAULT '' NOT NULL, type enum('FUNCTION','PROCEDURE') NOT NULL, specific_name char(64) DEFAULT '' NOT NULL, language enum('SQL') DEFAULT 'SQL' NOT NULL, sql_data_access enum( 'CONTAINS_SQL', 'NO_SQL', 'READS_SQL_DATA', 'MODIFIES_SQL_DATA') DEFAULT 'CONTAINS_SQL' NOT NULL, is_deterministic enum('YES','NO') DEFAULT 'NO' NOT NULL, security_type enum('INVOKER','DEFINER') DEFAULT 'DEFINER' NOT NULL, param_list blob NOT NULL, returns longblob DEFAULT '' NOT NULL, body longblob NOT NULL, definer char(77) collate utf8_bin DEFAULT '' NOT NULL, created timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, modified timestamp NOT NULL DEFAULT '0000-00-00 00:00:00', sql_mode set( 'REAL_AS_FLOAT', 'PIPES_AS_CONCAT', 'ANSI_QUOTES', 'IGNORE_SPACE', 'NOT_USED', 'ONLY_FULL_GROUP_BY', 'NO_UNSIGNED_SUBTRACTION', 'NO_DIR_IN_CREATE', 'POSTGRESQL', 'ORACLE', 'MSSQL', 'DB2', 'MAXDB', 'NO_KEY_OPTIONS', 'NO_TABLE_OPTIONS', 'NO_FIELD_OPTIONS', 'MYSQL323', 'MYSQL40', 'ANSI', 'NO_AUTO_VALUE_ON_ZERO', 'NO_BACKSLASH_ESCAPES', 'STRICT_TRANS_TABLES', 'STRICT_ALL_TABLES', 'NO_ZERO_IN_DATE', 'NO_ZERO_DATE', 'INVALID_DATES', 'ERROR_FOR_DIVISION_BY_ZERO', 'TRADITIONAL', 'NO_AUTO_CREATE_USER', 'HIGH_NOT_PRECEDENCE', 'NO_ENGINE_SUBSTITUTION', 'PAD_CHAR_TO_FULL_LENGTH') DEFAULT '' NOT NULL, comment text collate utf8_bin NOT NULL, character_set_client char(32) collate utf8_bin, collation_connection char(32) collate utf8_bin, db_collation char(32) collate utf8_bin, body_utf8 longblob, PRIMARY KEY (db,name,type)) engine=MyISAM character set utf8 comment='Stored Procedures';

CREATE TABLE IF NOT EXISTS procs_priv ( Host char(60) binary DEFAULT '' NOT NULL, Db char(64) binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Routine_name char(64) COLLATE utf8_general_ci DEFAULT '' NOT NULL, Routine_type enum('FUNCTION','PROCEDURE') NOT NULL, Grantor char(77) DEFAULT '' NOT NULL, Proc_priv set('Execute','Alter Routine','Grant') COLLATE utf8_general_ci DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY (Host,Db,User,Routine_name,Routine_type), KEY Grantor (Grantor) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin   comment='Procedure privileges';

CREATE TABLE IF NOT EXISTS general_log (event_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), user_host MEDIUMTEXT NOT NULL, thread_id BIGINT(21) UNSIGNED NOT NULL, server_id INTEGER UNSIGNED NOT NULL, command_type VARCHAR(64) NOT NULL, argument MEDIUMBLOB NOT NULL) engine=CSV CHARACTER SET utf8 comment="General log";

CREATE TABLE IF NOT EXISTS slow_log (start_time TIMESTAMP(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6), user_host MEDIUMTEXT NOT NULL, query_time TIME(6) NOT NULL, lock_time TIME(6) NOT NULL, rows_sent INTEGER NOT NULL, rows_examined INTEGER NOT NULL, db VARCHAR(512) NOT NULL, last_insert_id INTEGER NOT NULL, insert_id INTEGER NOT NULL, server_id INTEGER UNSIGNED NOT NULL, sql_text MEDIUMBLOB NOT NULL, thread_id BIGINT(21) UNSIGNED NOT NULL) engine=CSV CHARACTER SET utf8 comment="Slow log";

CREATE TABLE IF NOT EXISTS event ( db char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL default '', name char(64) CHARACTER SET utf8 NOT NULL default '', body longblob NOT NULL, definer char(77) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL default '', execute_at DATETIME default NULL, interval_value int(11) default NULL, interval_field ENUM('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') default NULL, created TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, modified TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00', last_executed DATETIME default NULL, starts DATETIME default NULL, ends DATETIME default NULL, status ENUM('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL default 'ENABLED', on_completion ENUM('DROP','PRESERVE') NOT NULL default 'DROP', sql_mode  set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','NOT_USED','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH') DEFAULT '' NOT NULL, comment char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL default '', originator INTEGER UNSIGNED NOT NULL, time_zone char(64) CHARACTER SET latin1 NOT NULL DEFAULT 'SYSTEM', character_set_client char(32) collate utf8_bin, collation_connection char(32) collate utf8_bin, db_collation char(32) collate utf8_bin, body_utf8 longblob, PRIMARY KEY (db, name) ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT 'Events';

CREATE TABLE IF NOT EXISTS ndb_binlog_index (Position BIGINT UNSIGNED NOT NULL, File VARCHAR(255) NOT NULL, epoch BIGINT UNSIGNED NOT NULL, inserts INT UNSIGNED NOT NULL, updates INT UNSIGNED NOT NULL, deletes INT UNSIGNED NOT NULL, schemaops INT UNSIGNED NOT NULL, orig_server_id INT UNSIGNED NOT NULL, orig_epoch BIGINT UNSIGNED NOT NULL, gci INT UNSIGNED NOT NULL, next_position BIGINT UNSIGNED NOT NULL, next_file VARCHAR(255) NOT NULL, PRIMARY KEY(epoch, orig_server_id, orig_epoch)) ENGINE=MYISAM;

CREATE TABLE IF NOT EXISTS innodb_table_stats (
	database_name			VARCHAR(64) NOT NULL,
	table_name			VARCHAR(64) NOT NULL,
	last_update			TIMESTAMP NOT NULL NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	n_rows				BIGINT UNSIGNED NOT NULL,
	clustered_index_size		BIGINT UNSIGNED NOT NULL,
	sum_of_other_index_sizes	BIGINT UNSIGNED NOT NULL,
	PRIMARY KEY (database_name, table_name)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin STATS_PERSISTENT=0
CREATE TABLE IF NOT EXISTS innodb_index_stats (
	database_name			VARCHAR(64) NOT NULL,
	table_name			VARCHAR(64) NOT NULL,
	index_name			VARCHAR(64) NOT NULL,
	last_update			TIMESTAMP NOT NULL NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
	/* there are at least:
	stat_name='size'
	stat_name='n_leaf_pages'
	stat_name='n_diff_pfx%' */
	stat_name			VARCHAR(64) NOT NULL,
	stat_value			BIGINT UNSIGNED NOT NULL,
	sample_size			BIGINT UNSIGNED,
	stat_description		VARCHAR(1024) NOT NULL,
	PRIMARY KEY (database_name, table_name, index_name, stat_name)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin STATS_PERSISTENT=0
CREATE TABLE IF NOT EXISTS slave_relay_log_info (
  Number_of_lines INTEGER UNSIGNED NOT NULL COMMENT 'Number of lines in the file or rows in the table. Used to version table definitions.',
  Relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The name of the current relay log file.',
  Relay_log_pos BIGINT UNSIGNED NOT NULL COMMENT 'The relay log position of the last executed event.',
  Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The name of the master binary log file from which the events in the relay log file were read.',
  Master_log_pos BIGINT UNSIGNED NOT NULL COMMENT 'The master log position of the last executed event.',
  Sql_delay INTEGER NOT NULL COMMENT 'The number of seconds that the slave must lag behind the master.',
  Number_of_workers INTEGER UNSIGNED NOT NULL,
  Id INTEGER UNSIGNED NOT NULL COMMENT 'Internal Id that uniquely identifies this record.',
  Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the slave is connected to a source. Used in Multisource Replication',
  PRIMARY KEY(Channel_name)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'Relay Log Information' ENGINE= INNODB
CREATE TABLE IF NOT EXISTS slave_master_info (
  Number_of_lines INTEGER UNSIGNED NOT NULL COMMENT 'Number of lines in the file.',
  Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The name of the master binary log currently being read from the master.',
  Master_log_pos BIGINT UNSIGNED NOT NULL COMMENT 'The master log position of the last read event.',
  Host CHAR(64) CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The host name of the master.',
  User_name TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The user name used to connect to the master.',
  User_password TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The password used to connect to the master.',
  Port INTEGER UNSIGNED NOT NULL COMMENT 'The network port used to connect to the master.',
  Connect_retry INTEGER UNSIGNED NOT NULL COMMENT 'The period (in seconds) that the slave will wait before trying to reconnect to the master.',
  Enabled_ssl BOOLEAN NOT NULL COMMENT 'Indicates whether the server supports SSL connections.',
  Ssl_ca TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Authority (CA) certificate.',
  Ssl_capath TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path to the Certificate Authority (CA) certificates.',
  Ssl_cert TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL certificate file.',
  Ssl_cipher TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the cipher in use for the SSL connection.',
  Ssl_key TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL key file.',
  Ssl_verify_server_cert BOOLEAN NOT NULL COMMENT 'Whether to verify the server certificate.',
  Heartbeat FLOAT NOT NULL COMMENT '',
  Bind TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Displays which interface is employed when connecting to the MySQL server',
  Ignored_server_ids TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The number of server IDs to be ignored, followed by the actual server IDs',
  Uuid TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The master server uuid.',
  Retry_count BIGINT UNSIGNED NOT NULL COMMENT 'Number of reconnect attempts, to the master, before giving up.',
  Ssl_crl TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Revocation List (CRL)',
  Ssl_crlpath TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path used for Certificate Revocation List (CRL) files',
  Enabled_auto_position BOOLEAN NOT NULL COMMENT 'Indicates whether GTIDs will be used to retrieve events from the master.',
  Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the slave is connected to a source. Used in Multisource Replication',
  Tls_version TEXT CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Tls version',
  PRIMARY KEY(Channel_name)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'Master Information' ENGINE= INNODB
CREATE TABLE IF NOT EXISTS slave_worker_info (
  Id INTEGER UNSIGNED NOT NULL,
  Relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  Relay_log_pos BIGINT UNSIGNED NOT NULL,
  Master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  Master_log_pos BIGINT UNSIGNED NOT NULL,
  Checkpoint_relay_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  Checkpoint_relay_log_pos BIGINT UNSIGNED NOT NULL,
  Checkpoint_master_log_name TEXT CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  Checkpoint_master_log_pos BIGINT UNSIGNED NOT NULL,
  Checkpoint_seqno INT UNSIGNED NOT NULL,
  Checkpoint_group_size INTEGER UNSIGNED NOT NULL,
  Checkpoint_group_bitmap BLOB NOT NULL,
  Channel_name CHAR(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'The channel on which the slave is connected to a source. Used in Multisource Replication',
  PRIMARY KEY(Channel_name, Id)) DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT 'Worker Information' ENGINE= INNODB
CREATE TABLE IF NOT EXISTS gtid_executed (
    source_uuid CHAR(36) NOT NULL COMMENT 'uuid of the source where the transaction was originally executed.',
    interval_start BIGINT NOT NULL COMMENT 'First number of interval.',
    interval_end BIGINT NOT NULL COMMENT 'Last number of interval.',
    PRIMARY KEY(source_uuid, interval_start)) ENGINE= INNODB
CREATE TABLE IF NOT EXISTS server_cost (
  cost_name   VARCHAR(64) NOT NULL,
  cost_value  FLOAT DEFAULT NULL,
  last_update TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  comment     VARCHAR(1024) DEFAULT NULL,
  PRIMARY KEY (cost_name)
) ENGINE=InnoDB CHARACTER SET=utf8 COLLATE=utf8_general_ci STATS_PERSISTENT=0;

CREATE TABLE IF NOT EXISTS engine_cost (
  engine_name VARCHAR(64) NOT NULL,
  device_type INTEGER NOT NULL,
  cost_name   VARCHAR(64) NOT NULL,
  cost_value  FLOAT DEFAULT NULL,
  last_update TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  comment     VARCHAR(1024) DEFAULT NULL,
  PRIMARY KEY (cost_name, engine_name, device_type)
) ENGINE=InnoDB CHARACTER SET=utf8 COLLATE=utf8_general_ci STATS_PERSISTENT=0;

DROP DATABASE IF EXISTS performance_schema
CREATE DATABASE performance_schema character set utf8
CREATE TABLE performance_schema.cond_instances(NAME VARCHAR(128) not null,OBJECT_INSTANCE_BEGIN BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_waits_current(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,SPINS INTEGER unsigned,OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(512),INDEX_NAME VARCHAR(64),OBJECT_TYPE VARCHAR(64),OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'),OPERATION VARCHAR(32) not null,NUMBER_OF_BYTES BIGINT,FLAGS INTEGER unsigned)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_waits_history(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,SPINS INTEGER unsigned,OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(512),INDEX_NAME VARCHAR(64),OBJECT_TYPE VARCHAR(64),OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'),OPERATION VARCHAR(32) not null,NUMBER_OF_BYTES BIGINT,FLAGS INTEGER unsigned)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_waits_history_long(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,SPINS INTEGER unsigned,OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(512),INDEX_NAME VARCHAR(64),OBJECT_TYPE VARCHAR(64),OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'),OPERATION VARCHAR(32) not null,NUMBER_OF_BYTES BIGINT,FLAGS INTEGER unsigned)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_waits_summary_by_instance(EVENT_NAME VARCHAR(128) not null,OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_waits_summary_by_host_by_event_name(HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_waits_summary_by_user_by_event_name(USER CHAR(32) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_waits_summary_by_account_by_event_name(USER CHAR(32) collate utf8_bin default null,HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_waits_summary_by_thread_by_event_name(THREAD_ID BIGINT unsigned not null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_waits_summary_global_by_event_name(EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.file_instances(FILE_NAME VARCHAR(512) not null,EVENT_NAME VARCHAR(128) not null,OPEN_COUNT INTEGER unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.file_summary_by_event_name(EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ BIGINT unsigned not null,SUM_TIMER_READ BIGINT unsigned not null,MIN_TIMER_READ BIGINT unsigned not null,AVG_TIMER_READ BIGINT unsigned not null,MAX_TIMER_READ BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_READ BIGINT not null,COUNT_WRITE BIGINT unsigned not null,SUM_TIMER_WRITE BIGINT unsigned not null,MIN_TIMER_WRITE BIGINT unsigned not null,AVG_TIMER_WRITE BIGINT unsigned not null,MAX_TIMER_WRITE BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_WRITE BIGINT not null,COUNT_MISC BIGINT unsigned not null,SUM_TIMER_MISC BIGINT unsigned not null,MIN_TIMER_MISC BIGINT unsigned not null,AVG_TIMER_MISC BIGINT unsigned not null,MAX_TIMER_MISC BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.file_summary_by_instance(FILE_NAME VARCHAR(512) not null,EVENT_NAME VARCHAR(128) not null,OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ BIGINT unsigned not null,SUM_TIMER_READ BIGINT unsigned not null,MIN_TIMER_READ BIGINT unsigned not null,AVG_TIMER_READ BIGINT unsigned not null,MAX_TIMER_READ BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_READ BIGINT not null,COUNT_WRITE BIGINT unsigned not null,SUM_TIMER_WRITE BIGINT unsigned not null,MIN_TIMER_WRITE BIGINT unsigned not null,AVG_TIMER_WRITE BIGINT unsigned not null,MAX_TIMER_WRITE BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_WRITE BIGINT not null,COUNT_MISC BIGINT unsigned not null,SUM_TIMER_MISC BIGINT unsigned not null,MIN_TIMER_MISC BIGINT unsigned not null,AVG_TIMER_MISC BIGINT unsigned not null,MAX_TIMER_MISC BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.socket_instances(EVENT_NAME VARCHAR(128) not null,OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,THREAD_ID BIGINT unsigned,SOCKET_ID INTEGER not null,IP VARCHAR(64) not null,PORT INTEGER not null,STATE ENUM('IDLE','ACTIVE') not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.socket_summary_by_instance(EVENT_NAME VARCHAR(128) not null,OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ BIGINT unsigned not null,SUM_TIMER_READ BIGINT unsigned not null,MIN_TIMER_READ BIGINT unsigned not null,AVG_TIMER_READ BIGINT unsigned not null,MAX_TIMER_READ BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_READ BIGINT unsigned not null,COUNT_WRITE BIGINT unsigned not null,SUM_TIMER_WRITE BIGINT unsigned not null,MIN_TIMER_WRITE BIGINT unsigned not null,AVG_TIMER_WRITE BIGINT unsigned not null,MAX_TIMER_WRITE BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_WRITE BIGINT unsigned not null,COUNT_MISC BIGINT unsigned not null,SUM_TIMER_MISC BIGINT unsigned not null,MIN_TIMER_MISC BIGINT unsigned not null,AVG_TIMER_MISC BIGINT unsigned not null,MAX_TIMER_MISC BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.socket_summary_by_event_name(EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ BIGINT unsigned not null,SUM_TIMER_READ BIGINT unsigned not null,MIN_TIMER_READ BIGINT unsigned not null,AVG_TIMER_READ BIGINT unsigned not null,MAX_TIMER_READ BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_READ BIGINT unsigned not null,COUNT_WRITE BIGINT unsigned not null,SUM_TIMER_WRITE BIGINT unsigned not null,MIN_TIMER_WRITE BIGINT unsigned not null,AVG_TIMER_WRITE BIGINT unsigned not null,MAX_TIMER_WRITE BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_WRITE BIGINT unsigned not null,COUNT_MISC BIGINT unsigned not null,SUM_TIMER_MISC BIGINT unsigned not null,MIN_TIMER_MISC BIGINT unsigned not null,AVG_TIMER_MISC BIGINT unsigned not null,MAX_TIMER_MISC BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.host_cache(IP VARCHAR(64) not null,HOST VARCHAR(255) collate utf8_bin,HOST_VALIDATED ENUM ('YES', 'NO') not null,SUM_CONNECT_ERRORS BIGINT not null,COUNT_HOST_BLOCKED_ERRORS BIGINT not null,COUNT_NAMEINFO_TRANSIENT_ERRORS BIGINT not null,COUNT_NAMEINFO_PERMANENT_ERRORS BIGINT not null,COUNT_FORMAT_ERRORS BIGINT not null,COUNT_ADDRINFO_TRANSIENT_ERRORS BIGINT not null,COUNT_ADDRINFO_PERMANENT_ERRORS BIGINT not null,COUNT_FCRDNS_ERRORS BIGINT not null,COUNT_HOST_ACL_ERRORS BIGINT not null,COUNT_NO_AUTH_PLUGIN_ERRORS BIGINT not null,COUNT_AUTH_PLUGIN_ERRORS BIGINT not null,COUNT_HANDSHAKE_ERRORS BIGINT not null,COUNT_PROXY_USER_ERRORS BIGINT not null,COUNT_PROXY_USER_ACL_ERRORS BIGINT not null,COUNT_AUTHENTICATION_ERRORS BIGINT not null,COUNT_SSL_ERRORS BIGINT not null,COUNT_MAX_USER_CONNECTIONS_ERRORS BIGINT not null,COUNT_MAX_USER_CONNECTIONS_PER_HOUR_ERRORS BIGINT not null,COUNT_DEFAULT_DATABASE_ERRORS BIGINT not null,COUNT_INIT_CONNECT_ERRORS BIGINT not null,COUNT_LOCAL_ERRORS BIGINT not null,COUNT_UNKNOWN_ERRORS BIGINT not null,FIRST_SEEN TIMESTAMP(0) NOT NULL default 0,LAST_SEEN TIMESTAMP(0) NOT NULL default 0,FIRST_ERROR_SEEN TIMESTAMP(0) null default 0,LAST_ERROR_SEEN TIMESTAMP(0) null default 0)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.mutex_instances(NAME VARCHAR(128) not null,OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,LOCKED_BY_THREAD_ID BIGINT unsigned)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.objects_summary_global_by_type(OBJECT_TYPE VARCHAR(64),OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(64),COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.performance_timers(TIMER_NAME ENUM ('CYCLE', 'NANOSECOND', 'MICROSECOND', 'MILLISECOND', 'TICK') not null,TIMER_FREQUENCY BIGINT,TIMER_RESOLUTION BIGINT,TIMER_OVERHEAD BIGINT) ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.rwlock_instances(NAME VARCHAR(128) not null,OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,WRITE_LOCKED_BY_THREAD_ID BIGINT unsigned,READ_LOCKED_BY_COUNT INTEGER unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.setup_actors(HOST CHAR(60) collate utf8_bin default '%' not null,USER CHAR(32) collate utf8_bin default '%' not null,ROLE CHAR(16) collate utf8_bin default '%' not null,ENABLED ENUM ('YES', 'NO') not null default 'YES',HISTORY ENUM ('YES', 'NO') not null default 'YES')ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.setup_consumers(NAME VARCHAR(64) not null,ENABLED ENUM ('YES', 'NO') not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.setup_instruments(NAME VARCHAR(128) not null,ENABLED ENUM ('YES', 'NO') not null,TIMED ENUM ('YES', 'NO') not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.setup_objects(OBJECT_TYPE ENUM ('EVENT', 'FUNCTION', 'PROCEDURE', 'TABLE', 'TRIGGER') not null default 'TABLE',OBJECT_SCHEMA VARCHAR(64) default '%',OBJECT_NAME VARCHAR(64) not null default '%',ENABLED ENUM ('YES', 'NO') not null default 'YES',TIMED ENUM ('YES', 'NO') not null default 'YES')ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.setup_timers(NAME VARCHAR(64) not null,TIMER_NAME ENUM ('CYCLE', 'NANOSECOND', 'MICROSECOND', 'MILLISECOND', 'TICK') not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.table_io_waits_summary_by_index_usage(OBJECT_TYPE VARCHAR(64),OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(64),INDEX_NAME VARCHAR(64),COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ BIGINT unsigned not null,SUM_TIMER_READ BIGINT unsigned not null,MIN_TIMER_READ BIGINT unsigned not null,AVG_TIMER_READ BIGINT unsigned not null,MAX_TIMER_READ BIGINT unsigned not null,COUNT_WRITE BIGINT unsigned not null,SUM_TIMER_WRITE BIGINT unsigned not null,MIN_TIMER_WRITE BIGINT unsigned not null,AVG_TIMER_WRITE BIGINT unsigned not null,MAX_TIMER_WRITE BIGINT unsigned not null,COUNT_FETCH BIGINT unsigned not null,SUM_TIMER_FETCH BIGINT unsigned not null,MIN_TIMER_FETCH BIGINT unsigned not null,AVG_TIMER_FETCH BIGINT unsigned not null,MAX_TIMER_FETCH BIGINT unsigned not null,COUNT_INSERT BIGINT unsigned not null,SUM_TIMER_INSERT BIGINT unsigned not null,MIN_TIMER_INSERT BIGINT unsigned not null,AVG_TIMER_INSERT BIGINT unsigned not null,MAX_TIMER_INSERT BIGINT unsigned not null,COUNT_UPDATE BIGINT unsigned not null,SUM_TIMER_UPDATE BIGINT unsigned not null,MIN_TIMER_UPDATE BIGINT unsigned not null,AVG_TIMER_UPDATE BIGINT unsigned not null,MAX_TIMER_UPDATE BIGINT unsigned not null,COUNT_DELETE BIGINT unsigned not null,SUM_TIMER_DELETE BIGINT unsigned not null,MIN_TIMER_DELETE BIGINT unsigned not null,AVG_TIMER_DELETE BIGINT unsigned not null,MAX_TIMER_DELETE BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.table_io_waits_summary_by_table(OBJECT_TYPE VARCHAR(64),OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(64),COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ BIGINT unsigned not null,SUM_TIMER_READ BIGINT unsigned not null,MIN_TIMER_READ BIGINT unsigned not null,AVG_TIMER_READ BIGINT unsigned not null,MAX_TIMER_READ BIGINT unsigned not null,COUNT_WRITE BIGINT unsigned not null,SUM_TIMER_WRITE BIGINT unsigned not null,MIN_TIMER_WRITE BIGINT unsigned not null,AVG_TIMER_WRITE BIGINT unsigned not null,MAX_TIMER_WRITE BIGINT unsigned not null,COUNT_FETCH BIGINT unsigned not null,SUM_TIMER_FETCH BIGINT unsigned not null,MIN_TIMER_FETCH BIGINT unsigned not null,AVG_TIMER_FETCH BIGINT unsigned not null,MAX_TIMER_FETCH BIGINT unsigned not null,COUNT_INSERT BIGINT unsigned not null,SUM_TIMER_INSERT BIGINT unsigned not null,MIN_TIMER_INSERT BIGINT unsigned not null,AVG_TIMER_INSERT BIGINT unsigned not null,MAX_TIMER_INSERT BIGINT unsigned not null,COUNT_UPDATE BIGINT unsigned not null,SUM_TIMER_UPDATE BIGINT unsigned not null,MIN_TIMER_UPDATE BIGINT unsigned not null,AVG_TIMER_UPDATE BIGINT unsigned not null,MAX_TIMER_UPDATE BIGINT unsigned not null,COUNT_DELETE BIGINT unsigned not null,SUM_TIMER_DELETE BIGINT unsigned not null,MIN_TIMER_DELETE BIGINT unsigned not null,AVG_TIMER_DELETE BIGINT unsigned not null,MAX_TIMER_DELETE BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.table_lock_waits_summary_by_table(OBJECT_TYPE VARCHAR(64),OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(64),COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ BIGINT unsigned not null,SUM_TIMER_READ BIGINT unsigned not null,MIN_TIMER_READ BIGINT unsigned not null,AVG_TIMER_READ BIGINT unsigned not null,MAX_TIMER_READ BIGINT unsigned not null,COUNT_WRITE BIGINT unsigned not null,SUM_TIMER_WRITE BIGINT unsigned not null,MIN_TIMER_WRITE BIGINT unsigned not null,AVG_TIMER_WRITE BIGINT unsigned not null,MAX_TIMER_WRITE BIGINT unsigned not null,COUNT_READ_NORMAL BIGINT unsigned not null,SUM_TIMER_READ_NORMAL BIGINT unsigned not null,MIN_TIMER_READ_NORMAL BIGINT unsigned not null,AVG_TIMER_READ_NORMAL BIGINT unsigned not null,MAX_TIMER_READ_NORMAL BIGINT unsigned not null,COUNT_READ_WITH_SHARED_LOCKS BIGINT unsigned not null,SUM_TIMER_READ_WITH_SHARED_LOCKS BIGINT unsigned not null,MIN_TIMER_READ_WITH_SHARED_LOCKS BIGINT unsigned not null,AVG_TIMER_READ_WITH_SHARED_LOCKS BIGINT unsigned not null,MAX_TIMER_READ_WITH_SHARED_LOCKS BIGINT unsigned not null,COUNT_READ_HIGH_PRIORITY BIGINT unsigned not null,SUM_TIMER_READ_HIGH_PRIORITY BIGINT unsigned not null,MIN_TIMER_READ_HIGH_PRIORITY BIGINT unsigned not null,AVG_TIMER_READ_HIGH_PRIORITY BIGINT unsigned not null,MAX_TIMER_READ_HIGH_PRIORITY BIGINT unsigned not null,COUNT_READ_NO_INSERT BIGINT unsigned not null,SUM_TIMER_READ_NO_INSERT BIGINT unsigned not null,MIN_TIMER_READ_NO_INSERT BIGINT unsigned not null,AVG_TIMER_READ_NO_INSERT BIGINT unsigned not null,MAX_TIMER_READ_NO_INSERT BIGINT unsigned not null,COUNT_READ_EXTERNAL BIGINT unsigned not null,SUM_TIMER_READ_EXTERNAL BIGINT unsigned not null,MIN_TIMER_READ_EXTERNAL BIGINT unsigned not null,AVG_TIMER_READ_EXTERNAL BIGINT unsigned not null,MAX_TIMER_READ_EXTERNAL BIGINT unsigned not null,COUNT_WRITE_ALLOW_WRITE BIGINT unsigned not null,SUM_TIMER_WRITE_ALLOW_WRITE BIGINT unsigned not null,MIN_TIMER_WRITE_ALLOW_WRITE BIGINT unsigned not null,AVG_TIMER_WRITE_ALLOW_WRITE BIGINT unsigned not null,MAX_TIMER_WRITE_ALLOW_WRITE BIGINT unsigned not null,COUNT_WRITE_CONCURRENT_INSERT BIGINT unsigned not null,SUM_TIMER_WRITE_CONCURRENT_INSERT BIGINT unsigned not null,MIN_TIMER_WRITE_CONCURRENT_INSERT BIGINT unsigned not null,AVG_TIMER_WRITE_CONCURRENT_INSERT BIGINT unsigned not null,MAX_TIMER_WRITE_CONCURRENT_INSERT BIGINT unsigned not null,COUNT_WRITE_LOW_PRIORITY BIGINT unsigned not null,SUM_TIMER_WRITE_LOW_PRIORITY BIGINT unsigned not null,MIN_TIMER_WRITE_LOW_PRIORITY BIGINT unsigned not null,AVG_TIMER_WRITE_LOW_PRIORITY BIGINT unsigned not null,MAX_TIMER_WRITE_LOW_PRIORITY BIGINT unsigned not null,COUNT_WRITE_NORMAL BIGINT unsigned not null,SUM_TIMER_WRITE_NORMAL BIGINT unsigned not null,MIN_TIMER_WRITE_NORMAL BIGINT unsigned not null,AVG_TIMER_WRITE_NORMAL BIGINT unsigned not null,MAX_TIMER_WRITE_NORMAL BIGINT unsigned not null,COUNT_WRITE_EXTERNAL BIGINT unsigned not null,SUM_TIMER_WRITE_EXTERNAL BIGINT unsigned not null,MIN_TIMER_WRITE_EXTERNAL BIGINT unsigned not null,AVG_TIMER_WRITE_EXTERNAL BIGINT unsigned not null,MAX_TIMER_WRITE_EXTERNAL BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.threads(THREAD_ID BIGINT unsigned not null,NAME VARCHAR(128) not null,TYPE VARCHAR(10) not null,PROCESSLIST_ID BIGINT unsigned,PROCESSLIST_USER VARCHAR(32),PROCESSLIST_HOST VARCHAR(60),PROCESSLIST_DB VARCHAR(64),PROCESSLIST_COMMAND VARCHAR(16),PROCESSLIST_TIME BIGINT,PROCESSLIST_STATE VARCHAR(64),PROCESSLIST_INFO LONGTEXT,PARENT_THREAD_ID BIGINT unsigned,ROLE VARCHAR(64),INSTRUMENTED ENUM ('YES', 'NO') not null,HISTORY ENUM ('YES', 'NO') not null,CONNECTION_TYPE VARCHAR(16),THREAD_OS_ID BIGINT unsigned)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_stages_current(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,WORK_COMPLETED BIGINT unsigned,WORK_ESTIMATED BIGINT unsigned,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_stages_history(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,WORK_COMPLETED BIGINT unsigned,WORK_ESTIMATED BIGINT unsigned,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_stages_history_long(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,WORK_COMPLETED BIGINT unsigned,WORK_ESTIMATED BIGINT unsigned,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_stages_summary_by_thread_by_event_name(THREAD_ID BIGINT unsigned not null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_stages_summary_by_host_by_event_name(HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_stages_summary_by_user_by_event_name(USER CHAR(32) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_stages_summary_by_account_by_event_name(USER CHAR(32) collate utf8_bin default null,HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_stages_summary_global_by_event_name(EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_current(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,LOCK_TIME bigint unsigned not null,SQL_TEXT LONGTEXT,DIGEST VARCHAR(32),DIGEST_TEXT LONGTEXT,CURRENT_SCHEMA VARCHAR(64),OBJECT_TYPE VARCHAR(64),OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(64),OBJECT_INSTANCE_BEGIN BIGINT unsigned,MYSQL_ERRNO INTEGER,RETURNED_SQLSTATE VARCHAR(5),MESSAGE_TEXT VARCHAR(128),ERRORS BIGINT unsigned not null,WARNINGS BIGINT unsigned not null,ROWS_AFFECTED BIGINT unsigned not null,ROWS_SENT BIGINT unsigned not null,ROWS_EXAMINED BIGINT unsigned not null,CREATED_TMP_DISK_TABLES BIGINT unsigned not null,CREATED_TMP_TABLES BIGINT unsigned not null,SELECT_FULL_JOIN BIGINT unsigned not null,SELECT_FULL_RANGE_JOIN BIGINT unsigned not null,SELECT_RANGE BIGINT unsigned not null,SELECT_RANGE_CHECK BIGINT unsigned not null,SELECT_SCAN BIGINT unsigned not null,SORT_MERGE_PASSES BIGINT unsigned not null,SORT_RANGE BIGINT unsigned not null,SORT_ROWS BIGINT unsigned not null,SORT_SCAN BIGINT unsigned not null,NO_INDEX_USED BIGINT unsigned not null,NO_GOOD_INDEX_USED BIGINT unsigned not null,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'),NESTING_EVENT_LEVEL INTEGER)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_history(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,LOCK_TIME bigint unsigned not null,SQL_TEXT LONGTEXT,DIGEST VARCHAR(32),DIGEST_TEXT LONGTEXT,CURRENT_SCHEMA VARCHAR(64),OBJECT_TYPE VARCHAR(64),OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(64),OBJECT_INSTANCE_BEGIN BIGINT unsigned,MYSQL_ERRNO INTEGER,RETURNED_SQLSTATE VARCHAR(5),MESSAGE_TEXT VARCHAR(128),ERRORS BIGINT unsigned not null,WARNINGS BIGINT unsigned not null,ROWS_AFFECTED BIGINT unsigned not null,ROWS_SENT BIGINT unsigned not null,ROWS_EXAMINED BIGINT unsigned not null,CREATED_TMP_DISK_TABLES BIGINT unsigned not null,CREATED_TMP_TABLES BIGINT unsigned not null,SELECT_FULL_JOIN BIGINT unsigned not null,SELECT_FULL_RANGE_JOIN BIGINT unsigned not null,SELECT_RANGE BIGINT unsigned not null,SELECT_RANGE_CHECK BIGINT unsigned not null,SELECT_SCAN BIGINT unsigned not null,SORT_MERGE_PASSES BIGINT unsigned not null,SORT_RANGE BIGINT unsigned not null,SORT_ROWS BIGINT unsigned not null,SORT_SCAN BIGINT unsigned not null,NO_INDEX_USED BIGINT unsigned not null,NO_GOOD_INDEX_USED BIGINT unsigned not null,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'),NESTING_EVENT_LEVEL INTEGER)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_history_long(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,LOCK_TIME bigint unsigned not null,SQL_TEXT LONGTEXT,DIGEST VARCHAR(32),DIGEST_TEXT LONGTEXT,CURRENT_SCHEMA VARCHAR(64),OBJECT_TYPE VARCHAR(64),OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(64),OBJECT_INSTANCE_BEGIN BIGINT unsigned,MYSQL_ERRNO INTEGER,RETURNED_SQLSTATE VARCHAR(5),MESSAGE_TEXT VARCHAR(128),ERRORS BIGINT unsigned not null,WARNINGS BIGINT unsigned not null,ROWS_AFFECTED BIGINT unsigned not null,ROWS_SENT BIGINT unsigned not null,ROWS_EXAMINED BIGINT unsigned not null,CREATED_TMP_DISK_TABLES BIGINT unsigned not null,CREATED_TMP_TABLES BIGINT unsigned not null,SELECT_FULL_JOIN BIGINT unsigned not null,SELECT_FULL_RANGE_JOIN BIGINT unsigned not null,SELECT_RANGE BIGINT unsigned not null,SELECT_RANGE_CHECK BIGINT unsigned not null,SELECT_SCAN BIGINT unsigned not null,SORT_MERGE_PASSES BIGINT unsigned not null,SORT_RANGE BIGINT unsigned not null,SORT_ROWS BIGINT unsigned not null,SORT_SCAN BIGINT unsigned not null,NO_INDEX_USED BIGINT unsigned not null,NO_GOOD_INDEX_USED BIGINT unsigned not null,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'),NESTING_EVENT_LEVEL INTEGER)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_summary_by_thread_by_event_name(THREAD_ID BIGINT unsigned not null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,SUM_LOCK_TIME BIGINT unsigned not null,SUM_ERRORS BIGINT unsigned not null,SUM_WARNINGS BIGINT unsigned not null,SUM_ROWS_AFFECTED BIGINT unsigned not null,SUM_ROWS_SENT BIGINT unsigned not null,SUM_ROWS_EXAMINED BIGINT unsigned not null,SUM_CREATED_TMP_DISK_TABLES BIGINT unsigned not null,SUM_CREATED_TMP_TABLES BIGINT unsigned not null,SUM_SELECT_FULL_JOIN BIGINT unsigned not null,SUM_SELECT_FULL_RANGE_JOIN BIGINT unsigned not null,SUM_SELECT_RANGE BIGINT unsigned not null,SUM_SELECT_RANGE_CHECK BIGINT unsigned not null,SUM_SELECT_SCAN BIGINT unsigned not null,SUM_SORT_MERGE_PASSES BIGINT unsigned not null,SUM_SORT_RANGE BIGINT unsigned not null,SUM_SORT_ROWS BIGINT unsigned not null,SUM_SORT_SCAN BIGINT unsigned not null,SUM_NO_INDEX_USED BIGINT unsigned not null,SUM_NO_GOOD_INDEX_USED BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_summary_by_host_by_event_name(HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,SUM_LOCK_TIME BIGINT unsigned not null,SUM_ERRORS BIGINT unsigned not null,SUM_WARNINGS BIGINT unsigned not null,SUM_ROWS_AFFECTED BIGINT unsigned not null,SUM_ROWS_SENT BIGINT unsigned not null,SUM_ROWS_EXAMINED BIGINT unsigned not null,SUM_CREATED_TMP_DISK_TABLES BIGINT unsigned not null,SUM_CREATED_TMP_TABLES BIGINT unsigned not null,SUM_SELECT_FULL_JOIN BIGINT unsigned not null,SUM_SELECT_FULL_RANGE_JOIN BIGINT unsigned not null,SUM_SELECT_RANGE BIGINT unsigned not null,SUM_SELECT_RANGE_CHECK BIGINT unsigned not null,SUM_SELECT_SCAN BIGINT unsigned not null,SUM_SORT_MERGE_PASSES BIGINT unsigned not null,SUM_SORT_RANGE BIGINT unsigned not null,SUM_SORT_ROWS BIGINT unsigned not null,SUM_SORT_SCAN BIGINT unsigned not null,SUM_NO_INDEX_USED BIGINT unsigned not null,SUM_NO_GOOD_INDEX_USED BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_summary_by_user_by_event_name(USER CHAR(32) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,SUM_LOCK_TIME BIGINT unsigned not null,SUM_ERRORS BIGINT unsigned not null,SUM_WARNINGS BIGINT unsigned not null,SUM_ROWS_AFFECTED BIGINT unsigned not null,SUM_ROWS_SENT BIGINT unsigned not null,SUM_ROWS_EXAMINED BIGINT unsigned not null,SUM_CREATED_TMP_DISK_TABLES BIGINT unsigned not null,SUM_CREATED_TMP_TABLES BIGINT unsigned not null,SUM_SELECT_FULL_JOIN BIGINT unsigned not null,SUM_SELECT_FULL_RANGE_JOIN BIGINT unsigned not null,SUM_SELECT_RANGE BIGINT unsigned not null,SUM_SELECT_RANGE_CHECK BIGINT unsigned not null,SUM_SELECT_SCAN BIGINT unsigned not null,SUM_SORT_MERGE_PASSES BIGINT unsigned not null,SUM_SORT_RANGE BIGINT unsigned not null,SUM_SORT_ROWS BIGINT unsigned not null,SUM_SORT_SCAN BIGINT unsigned not null,SUM_NO_INDEX_USED BIGINT unsigned not null,SUM_NO_GOOD_INDEX_USED BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_summary_by_account_by_event_name(USER CHAR(32) collate utf8_bin default null,HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,SUM_LOCK_TIME BIGINT unsigned not null,SUM_ERRORS BIGINT unsigned not null,SUM_WARNINGS BIGINT unsigned not null,SUM_ROWS_AFFECTED BIGINT unsigned not null,SUM_ROWS_SENT BIGINT unsigned not null,SUM_ROWS_EXAMINED BIGINT unsigned not null,SUM_CREATED_TMP_DISK_TABLES BIGINT unsigned not null,SUM_CREATED_TMP_TABLES BIGINT unsigned not null,SUM_SELECT_FULL_JOIN BIGINT unsigned not null,SUM_SELECT_FULL_RANGE_JOIN BIGINT unsigned not null,SUM_SELECT_RANGE BIGINT unsigned not null,SUM_SELECT_RANGE_CHECK BIGINT unsigned not null,SUM_SELECT_SCAN BIGINT unsigned not null,SUM_SORT_MERGE_PASSES BIGINT unsigned not null,SUM_SORT_RANGE BIGINT unsigned not null,SUM_SORT_ROWS BIGINT unsigned not null,SUM_SORT_SCAN BIGINT unsigned not null,SUM_NO_INDEX_USED BIGINT unsigned not null,SUM_NO_GOOD_INDEX_USED BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_summary_global_by_event_name(EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,SUM_LOCK_TIME BIGINT unsigned not null,SUM_ERRORS BIGINT unsigned not null,SUM_WARNINGS BIGINT unsigned not null,SUM_ROWS_AFFECTED BIGINT unsigned not null,SUM_ROWS_SENT BIGINT unsigned not null,SUM_ROWS_EXAMINED BIGINT unsigned not null,SUM_CREATED_TMP_DISK_TABLES BIGINT unsigned not null,SUM_CREATED_TMP_TABLES BIGINT unsigned not null,SUM_SELECT_FULL_JOIN BIGINT unsigned not null,SUM_SELECT_FULL_RANGE_JOIN BIGINT unsigned not null,SUM_SELECT_RANGE BIGINT unsigned not null,SUM_SELECT_RANGE_CHECK BIGINT unsigned not null,SUM_SELECT_SCAN BIGINT unsigned not null,SUM_SORT_MERGE_PASSES BIGINT unsigned not null,SUM_SORT_RANGE BIGINT unsigned not null,SUM_SORT_ROWS BIGINT unsigned not null,SUM_SORT_SCAN BIGINT unsigned not null,SUM_NO_INDEX_USED BIGINT unsigned not null,SUM_NO_GOOD_INDEX_USED BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_transactions_current(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,STATE ENUM('ACTIVE', 'COMMITTED', 'ROLLED BACK'),TRX_ID BIGINT unsigned,GTID VARCHAR(64),XID_FORMAT_ID INTEGER,XID_GTRID VARCHAR(130),XID_BQUAL VARCHAR(130),XA_STATE VARCHAR(64),SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,ACCESS_MODE ENUM('READ ONLY', 'READ WRITE'),ISOLATION_LEVEL VARCHAR(64),AUTOCOMMIT ENUM('YES','NO') not null,NUMBER_OF_SAVEPOINTS BIGINT unsigned,NUMBER_OF_ROLLBACK_TO_SAVEPOINT BIGINT unsigned,NUMBER_OF_RELEASE_SAVEPOINT BIGINT unsigned,OBJECT_INSTANCE_BEGIN BIGINT unsigned,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_transactions_history(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,STATE ENUM('ACTIVE', 'COMMITTED', 'ROLLED BACK'),TRX_ID BIGINT unsigned,GTID VARCHAR(64),XID_FORMAT_ID INTEGER,XID_GTRID VARCHAR(130),XID_BQUAL VARCHAR(130),XA_STATE VARCHAR(64),SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,ACCESS_MODE ENUM('READ ONLY', 'READ WRITE'),ISOLATION_LEVEL VARCHAR(64),AUTOCOMMIT ENUM('YES','NO') not null,NUMBER_OF_SAVEPOINTS BIGINT unsigned,NUMBER_OF_ROLLBACK_TO_SAVEPOINT BIGINT unsigned,NUMBER_OF_RELEASE_SAVEPOINT BIGINT unsigned,OBJECT_INSTANCE_BEGIN BIGINT unsigned,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_transactions_history_long(THREAD_ID BIGINT unsigned not null,EVENT_ID BIGINT unsigned not null,END_EVENT_ID BIGINT unsigned,EVENT_NAME VARCHAR(128) not null,STATE ENUM('ACTIVE', 'COMMITTED', 'ROLLED BACK'),TRX_ID BIGINT unsigned,GTID VARCHAR(64),XID_FORMAT_ID INTEGER,XID_GTRID VARCHAR(130),XID_BQUAL VARCHAR(130),XA_STATE VARCHAR(64),SOURCE VARCHAR(64),TIMER_START BIGINT unsigned,TIMER_END BIGINT unsigned,TIMER_WAIT BIGINT unsigned,ACCESS_MODE ENUM('READ ONLY', 'READ WRITE'),ISOLATION_LEVEL VARCHAR(64),AUTOCOMMIT ENUM('YES','NO') not null,NUMBER_OF_SAVEPOINTS BIGINT unsigned,NUMBER_OF_ROLLBACK_TO_SAVEPOINT BIGINT unsigned,NUMBER_OF_RELEASE_SAVEPOINT BIGINT unsigned,OBJECT_INSTANCE_BEGIN BIGINT unsigned,NESTING_EVENT_ID BIGINT unsigned,NESTING_EVENT_TYPE ENUM('TRANSACTION', 'STATEMENT', 'STAGE', 'WAIT'))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_transactions_summary_by_thread_by_event_name(THREAD_ID BIGINT unsigned not null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ_WRITE BIGINT unsigned not null,SUM_TIMER_READ_WRITE BIGINT unsigned not null,MIN_TIMER_READ_WRITE BIGINT unsigned not null,AVG_TIMER_READ_WRITE BIGINT unsigned not null,MAX_TIMER_READ_WRITE BIGINT unsigned not null,COUNT_READ_ONLY BIGINT unsigned not null,SUM_TIMER_READ_ONLY BIGINT unsigned not null,MIN_TIMER_READ_ONLY BIGINT unsigned not null,AVG_TIMER_READ_ONLY BIGINT unsigned not null,MAX_TIMER_READ_ONLY BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_transactions_summary_by_host_by_event_name(HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ_WRITE BIGINT unsigned not null,SUM_TIMER_READ_WRITE BIGINT unsigned not null,MIN_TIMER_READ_WRITE BIGINT unsigned not null,AVG_TIMER_READ_WRITE BIGINT unsigned not null,MAX_TIMER_READ_WRITE BIGINT unsigned not null,COUNT_READ_ONLY BIGINT unsigned not null,SUM_TIMER_READ_ONLY BIGINT unsigned not null,MIN_TIMER_READ_ONLY BIGINT unsigned not null,AVG_TIMER_READ_ONLY BIGINT unsigned not null,MAX_TIMER_READ_ONLY BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_transactions_summary_by_user_by_event_name(USER CHAR(32) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ_WRITE BIGINT unsigned not null,SUM_TIMER_READ_WRITE BIGINT unsigned not null,MIN_TIMER_READ_WRITE BIGINT unsigned not null,AVG_TIMER_READ_WRITE BIGINT unsigned not null,MAX_TIMER_READ_WRITE BIGINT unsigned not null,COUNT_READ_ONLY BIGINT unsigned not null,SUM_TIMER_READ_ONLY BIGINT unsigned not null,MIN_TIMER_READ_ONLY BIGINT unsigned not null,AVG_TIMER_READ_ONLY BIGINT unsigned not null,MAX_TIMER_READ_ONLY BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_transactions_summary_by_account_by_event_name(USER CHAR(32) collate utf8_bin default null,HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ_WRITE BIGINT unsigned not null,SUM_TIMER_READ_WRITE BIGINT unsigned not null,MIN_TIMER_READ_WRITE BIGINT unsigned not null,AVG_TIMER_READ_WRITE BIGINT unsigned not null,MAX_TIMER_READ_WRITE BIGINT unsigned not null,COUNT_READ_ONLY BIGINT unsigned not null,SUM_TIMER_READ_ONLY BIGINT unsigned not null,MIN_TIMER_READ_ONLY BIGINT unsigned not null,AVG_TIMER_READ_ONLY BIGINT unsigned not null,MAX_TIMER_READ_ONLY BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_transactions_summary_global_by_event_name(EVENT_NAME VARCHAR(128) not null,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,COUNT_READ_WRITE BIGINT unsigned not null,SUM_TIMER_READ_WRITE BIGINT unsigned not null,MIN_TIMER_READ_WRITE BIGINT unsigned not null,AVG_TIMER_READ_WRITE BIGINT unsigned not null,MAX_TIMER_READ_WRITE BIGINT unsigned not null,COUNT_READ_ONLY BIGINT unsigned not null,SUM_TIMER_READ_ONLY BIGINT unsigned not null,MIN_TIMER_READ_ONLY BIGINT unsigned not null,AVG_TIMER_READ_ONLY BIGINT unsigned not null,MAX_TIMER_READ_ONLY BIGINT unsigned not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.hosts(HOST CHAR(60) collate utf8_bin default null,CURRENT_CONNECTIONS bigint not null,TOTAL_CONNECTIONS bigint not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.users(USER CHAR(32) collate utf8_bin default null,CURRENT_CONNECTIONS bigint not null,TOTAL_CONNECTIONS bigint not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.accounts(USER CHAR(32) collate utf8_bin default null,HOST CHAR(60) collate utf8_bin default null,CURRENT_CONNECTIONS bigint not null,TOTAL_CONNECTIONS bigint not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.memory_summary_global_by_event_name(EVENT_NAME VARCHAR(128) not null,COUNT_ALLOC BIGINT unsigned not null,COUNT_FREE BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_ALLOC BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_FREE BIGINT unsigned not null,LOW_COUNT_USED BIGINT not null,CURRENT_COUNT_USED BIGINT not null,HIGH_COUNT_USED BIGINT not null,LOW_NUMBER_OF_BYTES_USED BIGINT not null,CURRENT_NUMBER_OF_BYTES_USED BIGINT not null,HIGH_NUMBER_OF_BYTES_USED BIGINT not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.memory_summary_by_thread_by_event_name(THREAD_ID BIGINT unsigned not null,EVENT_NAME VARCHAR(128) not null,COUNT_ALLOC BIGINT unsigned not null,COUNT_FREE BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_ALLOC BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_FREE BIGINT unsigned not null,LOW_COUNT_USED BIGINT not null,CURRENT_COUNT_USED BIGINT not null,HIGH_COUNT_USED BIGINT not null,LOW_NUMBER_OF_BYTES_USED BIGINT not null,CURRENT_NUMBER_OF_BYTES_USED BIGINT not null,HIGH_NUMBER_OF_BYTES_USED BIGINT not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.memory_summary_by_account_by_event_name(USER CHAR(32) collate utf8_bin default null,HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_ALLOC BIGINT unsigned not null,COUNT_FREE BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_ALLOC BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_FREE BIGINT unsigned not null,LOW_COUNT_USED BIGINT not null,CURRENT_COUNT_USED BIGINT not null,HIGH_COUNT_USED BIGINT not null,LOW_NUMBER_OF_BYTES_USED BIGINT not null,CURRENT_NUMBER_OF_BYTES_USED BIGINT not null,HIGH_NUMBER_OF_BYTES_USED BIGINT not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.memory_summary_by_host_by_event_name(HOST CHAR(60) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_ALLOC BIGINT unsigned not null,COUNT_FREE BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_ALLOC BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_FREE BIGINT unsigned not null,LOW_COUNT_USED BIGINT not null,CURRENT_COUNT_USED BIGINT not null,HIGH_COUNT_USED BIGINT not null,LOW_NUMBER_OF_BYTES_USED BIGINT not null,CURRENT_NUMBER_OF_BYTES_USED BIGINT not null,HIGH_NUMBER_OF_BYTES_USED BIGINT not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.memory_summary_by_user_by_event_name(USER CHAR(32) collate utf8_bin default null,EVENT_NAME VARCHAR(128) not null,COUNT_ALLOC BIGINT unsigned not null,COUNT_FREE BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_ALLOC BIGINT unsigned not null,SUM_NUMBER_OF_BYTES_FREE BIGINT unsigned not null,LOW_COUNT_USED BIGINT not null,CURRENT_COUNT_USED BIGINT not null,HIGH_COUNT_USED BIGINT not null,LOW_NUMBER_OF_BYTES_USED BIGINT not null,CURRENT_NUMBER_OF_BYTES_USED BIGINT not null,HIGH_NUMBER_OF_BYTES_USED BIGINT not null)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_summary_by_digest(SCHEMA_NAME VARCHAR(64),DIGEST VARCHAR(32),DIGEST_TEXT LONGTEXT,COUNT_STAR BIGINT unsigned not null,SUM_TIMER_WAIT BIGINT unsigned not null,MIN_TIMER_WAIT BIGINT unsigned not null,AVG_TIMER_WAIT BIGINT unsigned not null,MAX_TIMER_WAIT BIGINT unsigned not null,SUM_LOCK_TIME BIGINT unsigned not null,SUM_ERRORS BIGINT unsigned not null,SUM_WARNINGS BIGINT unsigned not null,SUM_ROWS_AFFECTED BIGINT unsigned not null,SUM_ROWS_SENT BIGINT unsigned not null,SUM_ROWS_EXAMINED BIGINT unsigned not null,SUM_CREATED_TMP_DISK_TABLES BIGINT unsigned not null,SUM_CREATED_TMP_TABLES BIGINT unsigned not null,SUM_SELECT_FULL_JOIN BIGINT unsigned not null,SUM_SELECT_FULL_RANGE_JOIN BIGINT unsigned not null,SUM_SELECT_RANGE BIGINT unsigned not null,SUM_SELECT_RANGE_CHECK BIGINT unsigned not null,SUM_SELECT_SCAN BIGINT unsigned not null,SUM_SORT_MERGE_PASSES BIGINT unsigned not null,SUM_SORT_RANGE BIGINT unsigned not null,SUM_SORT_ROWS BIGINT unsigned not null,SUM_SORT_SCAN BIGINT unsigned not null,SUM_NO_INDEX_USED BIGINT unsigned not null,SUM_NO_GOOD_INDEX_USED BIGINT unsigned not null,FIRST_SEEN TIMESTAMP(0) NOT NULL default 0,LAST_SEEN TIMESTAMP(0) NOT NULL default 0)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.events_statements_summary_by_program(OBJECT_TYPE enum('EVENT', 'FUNCTION', 'PROCEDURE', 'TABLE', 'TRIGGER'),OBJECT_SCHEMA varchar(64) NOT NULL,OBJECT_NAME varchar(64) NOT NULL,COUNT_STAR bigint(20) unsigned NOT NULL,SUM_TIMER_WAIT bigint(20) unsigned NOT NULL,MIN_TIMER_WAIT bigint(20) unsigned NOT NULL,AVG_TIMER_WAIT bigint(20) unsigned NOT NULL,MAX_TIMER_WAIT bigint(20) unsigned NOT NULL,COUNT_STATEMENTS bigint(20) unsigned NOT NULL,SUM_STATEMENTS_WAIT bigint(20) unsigned NOT NULL,MIN_STATEMENTS_WAIT bigint(20) unsigned NOT NULL,AVG_STATEMENTS_WAIT bigint(20) unsigned NOT NULL,MAX_STATEMENTS_WAIT bigint(20) unsigned NOT NULL,SUM_LOCK_TIME bigint(20) unsigned NOT NULL,SUM_ERRORS bigint(20) unsigned NOT NULL,SUM_WARNINGS bigint(20) unsigned NOT NULL,SUM_ROWS_AFFECTED bigint(20) unsigned NOT NULL,SUM_ROWS_SENT bigint(20) unsigned NOT NULL,SUM_ROWS_EXAMINED bigint(20) unsigned NOT NULL,SUM_CREATED_TMP_DISK_TABLES bigint(20) unsigned NOT NULL,SUM_CREATED_TMP_TABLES bigint(20) unsigned NOT NULL,SUM_SELECT_FULL_JOIN bigint(20) unsigned NOT NULL,SUM_SELECT_FULL_RANGE_JOIN bigint(20) unsigned NOT NULL,SUM_SELECT_RANGE bigint(20) unsigned NOT NULL,SUM_SELECT_RANGE_CHECK bigint(20) unsigned NOT NULL,SUM_SELECT_SCAN bigint(20) unsigned NOT NULL,SUM_SORT_MERGE_PASSES bigint(20) unsigned NOT NULL,SUM_SORT_RANGE bigint(20) unsigned NOT NULL,SUM_SORT_ROWS bigint(20) unsigned NOT NULL,SUM_SORT_SCAN bigint(20) unsigned NOT NULL,SUM_NO_INDEX_USED bigint(20) unsigned NOT NULL,SUM_NO_GOOD_INDEX_USED bigint(20) unsigned NOT NULL)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.prepared_statements_instances(OBJECT_INSTANCE_BEGIN bigint(20) unsigned NOT NULL,STATEMENT_ID bigint(20) unsigned NOT NULL,STATEMENT_NAME varchar(64) default NULL,SQL_TEXT longtext NOT NULL,OWNER_THREAD_ID bigint(20) unsigned NOT NULL,OWNER_EVENT_ID bigint(20) unsigned NOT NULL,OWNER_OBJECT_TYPE enum('EVENT','FUNCTION','PROCEDURE','TABLE','TRIGGER') DEFAULT NULL,OWNER_OBJECT_SCHEMA varchar(64) DEFAULT NULL,OWNER_OBJECT_NAME varchar(64) DEFAULT NULL,TIMER_PREPARE bigint(20) unsigned NOT NULL,COUNT_REPREPARE bigint(20) unsigned NOT NULL,COUNT_EXECUTE bigint(20) unsigned NOT NULL,SUM_TIMER_EXECUTE bigint(20) unsigned NOT NULL,MIN_TIMER_EXECUTE bigint(20) unsigned NOT NULL,AVG_TIMER_EXECUTE bigint(20) unsigned NOT NULL,MAX_TIMER_EXECUTE bigint(20) unsigned NOT NULL,SUM_LOCK_TIME bigint(20) unsigned NOT NULL,SUM_ERRORS bigint(20) unsigned NOT NULL,SUM_WARNINGS bigint(20) unsigned NOT NULL,SUM_ROWS_AFFECTED bigint(20) unsigned NOT NULL,SUM_ROWS_SENT bigint(20) unsigned NOT NULL,SUM_ROWS_EXAMINED bigint(20) unsigned NOT NULL,SUM_CREATED_TMP_DISK_TABLES bigint(20) unsigned NOT NULL,SUM_CREATED_TMP_TABLES bigint(20) unsigned NOT NULL,SUM_SELECT_FULL_JOIN bigint(20) unsigned NOT NULL,SUM_SELECT_FULL_RANGE_JOIN bigint(20) unsigned NOT NULL,SUM_SELECT_RANGE bigint(20) unsigned NOT NULL,SUM_SELECT_RANGE_CHECK bigint(20) unsigned NOT NULL,SUM_SELECT_SCAN bigint(20) unsigned NOT NULL,SUM_SORT_MERGE_PASSES bigint(20) unsigned NOT NULL,SUM_SORT_RANGE bigint(20) unsigned NOT NULL,SUM_SORT_ROWS bigint(20) unsigned NOT NULL,SUM_SORT_SCAN bigint(20) unsigned NOT NULL,SUM_NO_INDEX_USED bigint(20) unsigned NOT NULL,SUM_NO_GOOD_INDEX_USED bigint(20) unsigned NOT NULL)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.replication_connection_configuration(CHANNEL_NAME CHAR(64) collate utf8_general_ci not null,HOST CHAR(60) collate utf8_bin not null,PORT INTEGER not null,USER CHAR(32) collate utf8_bin not null,NETWORK_INTERFACE CHAR(60) collate utf8_bin not null,AUTO_POSITION ENUM('1','0') not null,SSL_ALLOWED ENUM('YES','NO','IGNORED') not null,SSL_CA_FILE VARCHAR(512) not null,SSL_CA_PATH VARCHAR(512) not null,SSL_CERTIFICATE VARCHAR(512) not null,SSL_CIPHER VARCHAR(512) not null,SSL_KEY VARCHAR(512) not null,SSL_VERIFY_SERVER_CERTIFICATE ENUM('YES','NO') not null,SSL_CRL_FILE VARCHAR(255) not null,SSL_CRL_PATH VARCHAR(255) not null,CONNECTION_RETRY_INTERVAL INTEGER not null,CONNECTION_RETRY_COUNT BIGINT unsigned not null,HEARTBEAT_INTERVAL DOUBLE(10,3) unsigned not null COMMENT 'Number of seconds after which a heartbeat will be sent .',TLS_VERSION VARCHAR(255) not null) ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.replication_group_member_stats(CHANNEL_NAME CHAR(64) collate utf8_general_ci not null,VIEW_ID CHAR(60) collate utf8_bin not null,MEMBER_ID CHAR(36) collate utf8_bin not null,COUNT_TRANSACTIONS_IN_QUEUE BIGINT unsigned not null,COUNT_TRANSACTIONS_CHECKED BIGINT unsigned not null,COUNT_CONFLICTS_DETECTED BIGINT unsigned not null,COUNT_TRANSACTIONS_VALIDATING BIGINT unsigned not null,TRANSACTIONS_COMMITTED_ALL_MEMBERS LONGTEXT not null,LAST_CONFLICT_FREE_TRANSACTION TEXT not null) ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.replication_group_members(CHANNEL_NAME CHAR(64) collate utf8_general_ci not null,MEMBER_ID CHAR(36) collate utf8_bin not null,MEMBER_HOST CHAR(60) collate utf8_bin not null,MEMBER_PORT INTEGER,MEMBER_STATE CHAR(64) collate utf8_bin not null) ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.replication_connection_status(CHANNEL_NAME CHAR(64) collate utf8_general_ci not null,GROUP_NAME CHAR(36) collate utf8_bin not null,SOURCE_UUID CHAR(36) collate utf8_bin not null,THREAD_ID BIGINT unsigned,SERVICE_STATE ENUM('ON','OFF','CONNECTING') not null,COUNT_RECEIVED_HEARTBEATS bigint unsigned NOT NULL DEFAULT 0,LAST_HEARTBEAT_TIMESTAMP TIMESTAMP(0) not null COMMENT 'Shows when the most recent heartbeat signal was received.',RECEIVED_TRANSACTION_SET TEXT not null,LAST_ERROR_NUMBER INTEGER not null,LAST_ERROR_MESSAGE VARCHAR(1024) not null,LAST_ERROR_TIMESTAMP TIMESTAMP(0) not null) ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.replication_applier_configuration(CHANNEL_NAME CHAR(64) collate utf8_general_ci not null,DESIRED_DELAY INTEGER not null) ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.replication_applier_status(CHANNEL_NAME CHAR(64) collate utf8_general_ci not null,SERVICE_STATE ENUM('ON','OFF') not null,REMAINING_DELAY INTEGER unsigned,COUNT_TRANSACTIONS_RETRIES BIGINT unsigned not null) ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.replication_applier_status_by_coordinator(CHANNEL_NAME CHAR(64) collate utf8_general_ci not null,THREAD_ID BIGINT UNSIGNED,SERVICE_STATE ENUM('ON','OFF') not null,LAST_ERROR_NUMBER INTEGER not null,LAST_ERROR_MESSAGE VARCHAR(1024) not null,LAST_ERROR_TIMESTAMP TIMESTAMP(0) not null) ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.replication_applier_status_by_worker(CHANNEL_NAME CHAR(64) collate utf8_general_ci not null,WORKER_ID BIGINT UNSIGNED not null,THREAD_ID BIGINT UNSIGNED,SERVICE_STATE ENUM('ON','OFF') not null,LAST_SEEN_TRANSACTION CHAR(57) not null,LAST_ERROR_NUMBER INTEGER not null,LAST_ERROR_MESSAGE VARCHAR(1024) not null,LAST_ERROR_TIMESTAMP TIMESTAMP(0) not null) ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.session_connect_attrs(PROCESSLIST_ID INT NOT NULL,ATTR_NAME VARCHAR(32) NOT NULL,ATTR_VALUE VARCHAR(1024),ORDINAL_POSITION INT)ENGINE=PERFORMANCE_SCHEMA CHARACTER SET utf8 COLLATE utf8_bin
CREATE TABLE performance_schema.session_account_connect_attrs  LIKE performance_schema.session_connect_attrs
CREATE TABLE performance_schema.table_handles(OBJECT_TYPE VARCHAR(64) not null,OBJECT_SCHEMA VARCHAR(64) not null,OBJECT_NAME VARCHAR(64) not null,OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,OWNER_THREAD_ID BIGINT unsigned,OWNER_EVENT_ID BIGINT unsigned,INTERNAL_LOCK VARCHAR(64),EXTERNAL_LOCK VARCHAR(64))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.metadata_locks(OBJECT_TYPE VARCHAR(64) not null,OBJECT_SCHEMA VARCHAR(64),OBJECT_NAME VARCHAR(64),OBJECT_INSTANCE_BEGIN BIGINT unsigned not null,LOCK_TYPE VARCHAR(32) not null,LOCK_DURATION VARCHAR(32) not null,LOCK_STATUS VARCHAR(32) not null,SOURCE VARCHAR(64),OWNER_THREAD_ID BIGINT unsigned,OWNER_EVENT_ID BIGINT unsigned)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.user_variables_by_thread(THREAD_ID BIGINT unsigned not null,VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE LONGBLOB)ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.variables_by_thread(THREAD_ID BIGINT unsigned not null,VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE VARCHAR(1024))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.global_variables(VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE VARCHAR(1024))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.session_variables(VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE VARCHAR(1024))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.status_by_thread(THREAD_ID BIGINT unsigned not null,VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE VARCHAR(1024))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.status_by_user(USER CHAR(32) collate utf8_bin default null,VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE VARCHAR(1024))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.status_by_host(HOST CHAR(60) collate utf8_bin default null,VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE VARCHAR(1024))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.status_by_account(USER CHAR(32) collate utf8_bin default null,HOST CHAR(60) collate utf8_bin default null,VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE VARCHAR(1024))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.global_status(VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE VARCHAR(1024))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE performance_schema.session_status(VARIABLE_NAME VARCHAR(64) not null,VARIABLE_VALUE VARCHAR(1024))ENGINE=PERFORMANCE_SCHEMA
CREATE TABLE IF NOT EXISTS proxies_priv (Host char(60) binary DEFAULT '' NOT NULL, User char(32) binary DEFAULT '' NOT NULL, Proxied_host char(60) binary DEFAULT '' NOT NULL, Proxied_user char(32) binary DEFAULT '' NOT NULL, With_grant BOOL DEFAULT 0 NOT NULL, Grantor char(77) DEFAULT '' NOT NULL, Timestamp timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, PRIMARY KEY Host (Host,User,Proxied_host,Proxied_user), KEY Grantor (Grantor) ) engine=MyISAM CHARACTER SET utf8 COLLATE utf8_bin comment='User proxy privileges';

FLUSH PRIVILEGES
CREATE USER 'root'@'localhost' IDENTIFIED WITH 'mysql_native_password'
GRANT ALL PRIVILEGES ON *.* TO 'root'@'localhost' WITH GRANT OPTION
GRANT USAGE ON *.* TO ''@'','root'@'localhost' WITH GRANT OPTION
TRUNCATE TABLE time_zone
TRUNCATE TABLE time_zone_name
TRUNCATE TABLE time_zone_transition
TRUNCATE TABLE time_zone_transition_type
CREATE DATABASE IF NOT EXISTS `mysql`
CREATE USER 'mysqluser'@'%' IDENTIFIED WITH 'mysql_native_password' AS '*FBC02A898D66B9181D6F8826C045C11FD2B364A4'
GRANT ALL PRIVILEGES ON `mysql`.* TO 'mysqluser'@'%'
FLUSH PRIVILEGES
GRANT REPLICATION SLAVE, REPLICATION CLIENT ON *.* TO 'replicator'@'%' IDENTIFIED WITH 'mysql_native_password' AS '*D98280F03D0F78162EBDBB9C883FC01395DEA2BF'
CREATE DATABASE connector_test
GRANT ALL PRIVILEGES ON `connector_test`.* TO 'mysqluser'@'%'
CREATE TABLE products (
  id INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(255) NOT NULL,
  description VARCHAR(512),
  weight FLOAT
)
ALTER TABLE products AUTO_INCREMENT = 101
CREATE TABLE products_on_hand (
  product_id INTEGER NOT NULL PRIMARY KEY,
  quantity INTEGER NOT NULL,
  FOREIGN KEY (product_id) REFERENCES products(id)
)
CREATE TABLE customers (
  id INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
  first_name VARCHAR(255) NOT NULL,
  last_name VARCHAR(255) NOT NULL,
  email VARCHAR(255) NOT NULL UNIQUE KEY
) AUTO_INCREMENT=1001
CREATE TABLE orders (
  order_number INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY,
  order_date DATE NOT NULL,
  purchaser INTEGER NOT NULL,
  quantity INTEGER NOT NULL,
  product_id INTEGER NOT NULL,
  FOREIGN KEY order_customer (purchaser) REFERENCES customers(id),
  FOREIGN KEY ordered_product (product_id) REFERENCES products(id)
) AUTO_INCREMENT = 10001
CREATE DATABASE emptydb
GRANT ALL PRIVILEGES ON `emptydb`.* TO 'mysqluser'@'%'
GRANT REPLICATION SLAVE, REPLICATION CLIENT ON *.* TO 'replicator'@'%' IDENTIFIED WITH 'mysql_native_password' AS '*D98280F03D0F78162EBDBB9C883FC01395DEA2BF'
CREATE DATABASE readbinlog_test
GRANT ALL PRIVILEGES ON `readbinlog_test`.* TO 'mysqluser'@'%'
DROP TABLE IF EXISTS `person` /* generated by server */
CREATE TABLE person (  name VARCHAR(255) primary key,  age INTEGER NULL DEFAULT 10,  createdAt DATETIME NULL DEFAULT CURRENT_TIMESTAMP,  updatedAt DATETIME NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP)
