/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io.serialization;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import io.pravega.common.io.BoundedInputStream;
import io.pravega.common.io.SerializationException;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutputStream;
import io.pravega.common.util.BitConverter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class RevisionDataInputStream
extends DataInputStream
implements RevisionDataInput {
    private RevisionDataInputStream(BoundedInputStream inputStream) {
        super(inputStream);
    }

    static RevisionDataInputStream wrap(InputStream inputStream) throws IOException {
        int bound = BitConverter.readInt(inputStream);
        return new RevisionDataInputStream(new BoundedInputStream(inputStream, bound));
    }

    @Override
    public InputStream getBaseStream() {
        return this;
    }

    @VisibleForTesting
    int getLength() {
        return ((BoundedInputStream)this.in).getBound();
    }

    @Override
    public long readCompactLong() throws IOException {
        long b1 = this.readUnsignedByte();
        byte header = (byte)(b1 >>> 6);
        b1 &= 0x3FL;
        switch (header) {
            case 0: {
                return b1;
            }
            case 1: {
                return (b1 << 8) + (long)this.readUnsignedByte();
            }
            case 2: {
                return (b1 << 24) + ((long)this.readUnsignedByte() << 16) + (long)this.readUnsignedShort();
            }
            case 3: {
                return (b1 << 56) + ((long)this.readUnsignedByte() << 48) + ((long)this.readUnsignedShort() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
            }
        }
        throw new SerializationException(String.format("Unable to deserialize compact long. Unrecognized header value %d.", header));
    }

    @Override
    public long readCompactSignedLong() throws IOException {
        long value;
        boolean negative;
        long b1 = this.readUnsignedByte();
        int header = (int)(b1 >>> 5);
        b1 &= 0x1FL;
        boolean bl = negative = (header & 4) == 4;
        if (negative) {
            header &= 3;
        }
        switch (header) {
            case 0: {
                value = b1;
                break;
            }
            case 1: {
                value = (b1 << 8) + (long)this.readUnsignedByte();
                break;
            }
            case 2: {
                value = (b1 << 24) + ((long)this.readUnsignedByte() << 16) + (long)this.readUnsignedShort();
                break;
            }
            case 3: {
                value = (b1 << 56) + ((long)this.readUnsignedByte() << 48) + ((long)this.readUnsignedShort() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
                break;
            }
            default: {
                throw new SerializationException(String.format("Unable to deserialize compact signed long. Unrecognized header value %d.", header));
            }
        }
        if (value > 0x1FFFFFFFFFFFFFFEL) {
            throw new SerializationException(String.format("Unable to deserialize compact signed long. Resulting value (%d) is outside of permissible bounds.", negative ? RevisionDataOutputStream.negateSignedNumber(value) : value));
        }
        return negative ? RevisionDataOutputStream.negateSignedNumber(value) : value;
    }

    @Override
    public int readCompactInt() throws IOException {
        int b1 = this.readUnsignedByte();
        if (b1 >>> 7 == 0) {
            return b1;
        }
        if ((b1 >>> 6 & 1) == 0) {
            return ((b1 & 0x3F) << 8) + this.readUnsignedByte();
        }
        return ((b1 & 0x3F) << 24) + (this.readUnsignedByte() << 16) + this.readUnsignedShort();
    }

    @Override
    public UUID readUUID() throws IOException {
        return new UUID(this.readLong(), this.readLong());
    }

    @Override
    public <T> Collection<T> readCollection(RevisionDataInput.ElementDeserializer<T> elementDeserializer) throws IOException {
        return this.readCollection(elementDeserializer, ArrayList::new);
    }

    @Override
    public <T, C extends Collection<T>> C readCollection(RevisionDataInput.ElementDeserializer<T> elementDeserializer, Supplier<C> newCollection) throws IOException {
        Collection result = (Collection)newCollection.get();
        int count = this.readCompactInt();
        for (int i = 0; i < count; ++i) {
            result.add(elementDeserializer.apply(this));
        }
        return (C)result;
    }

    @Override
    public <T, C extends ImmutableCollection<T>> void readCollection(RevisionDataInput.ElementDeserializer<T> elementDeserializer, ImmutableCollection.Builder<T> builder) throws IOException {
        int count = this.readCompactInt();
        for (int i = 0; i < count; ++i) {
            builder.add(elementDeserializer.apply(this));
        }
    }

    @Override
    public <T> T[] readArray(RevisionDataInput.ElementDeserializer<T> elementDeserializer, IntFunction<T[]> arrayCreator) throws IOException {
        int count = this.readCompactInt();
        T[] result = arrayCreator.apply(count);
        for (int i = 0; i < count; ++i) {
            result[i] = elementDeserializer.apply(this);
        }
        return result;
    }

    @Override
    public byte[] readArray() throws IOException {
        int count = this.readCompactInt();
        byte[] result = new byte[count];
        this.readFully(result);
        return result;
    }

    @Override
    public <K, V> Map<K, V> readMap(RevisionDataInput.ElementDeserializer<K> keyDeserializer, RevisionDataInput.ElementDeserializer<V> valueDeserializer) throws IOException {
        return this.readMap(keyDeserializer, valueDeserializer, HashMap::new);
    }

    @Override
    public <K, V, M extends Map<K, V>> M readMap(RevisionDataInput.ElementDeserializer<K> keyDeserializer, RevisionDataInput.ElementDeserializer<V> valueDeserializer, Supplier<M> newMap) throws IOException {
        Map result = (Map)newMap.get();
        int count = this.readCompactInt();
        for (int i = 0; i < count; ++i) {
            result.put(keyDeserializer.apply(this), valueDeserializer.apply(this));
        }
        return (M)result;
    }

    @Override
    public <K, V, M extends ImmutableMap<K, V>> void readMap(RevisionDataInput.ElementDeserializer<K> keyDeserializer, RevisionDataInput.ElementDeserializer<V> valueDeserializer, ImmutableMap.Builder<K, V> builder) throws IOException {
        int count = this.readCompactInt();
        for (int i = 0; i < count; ++i) {
            builder.put(keyDeserializer.apply(this), valueDeserializer.apply(this));
        }
    }
}

