/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

@Provider
@Priority(value=5001)
public class AuthenticationFailedExceptionMapper
implements ExceptionMapper<AuthenticationFailedException> {
    private static final Logger log = Logger.getLogger((String)AuthenticationFailedExceptionMapper.class.getName());
    private volatile CurrentVertxRequest currentVertxRequest;

    CurrentVertxRequest currentVertxRequest() {
        if (this.currentVertxRequest == null) {
            this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        }
        return this.currentVertxRequest;
    }

    public Response toResponse(AuthenticationFailedException exception) {
        RoutingContext context = this.currentVertxRequest().getCurrent();
        if (context != null) {
            HttpAuthenticator authenticator = (HttpAuthenticator)context.get(HttpAuthenticator.class.getName());
            if (authenticator != null) {
                ChallengeData challengeData = (ChallengeData)authenticator.getChallenge(context).await().indefinitely();
                Response.ResponseBuilder status = Response.status((int)challengeData.status);
                if (challengeData.headerName != null) {
                    status.header(challengeData.headerName.toString(), (Object)challengeData.headerContent);
                }
                log.debugf("Returning an authentication challenge, status code: %d", challengeData.status);
                return status.build();
            }
            log.error((Object)"HttpAuthenticator is not found, returning HTTP status 401");
        } else {
            log.error((Object)"RoutingContext is not found, returning HTTP status 401");
        }
        return Response.status((int)401).entity((Object)"Not Authenticated").build();
    }
}

