/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Status;

public class Error {
    public static final int NOT_SET = -1;
    private final String json;
    private final int code;
    private final int apiErrorCode;
    private final String desc;
    public static final Error JsBadRequestErr = new Error(400, 10003, "bad request");
    public static final Error JsNoMessageFoundErr = new Error(404, 10037, "no message found");

    static Error optionalInstance(String json) {
        String errorJson = JsonUtils.getJsonObject("error", json, null);
        return errorJson == null ? null : new Error(errorJson);
    }

    Error(String json) {
        this.json = json;
        this.code = JsonUtils.readInt(json, ApiConstants.CODE_RE, -1);
        this.apiErrorCode = JsonUtils.readInt(json, ApiConstants.ERR_CODE_RE, -1);
        this.desc = JsonUtils.readString(json, ApiConstants.DESCRIPTION_RE, "Unknown JetStream Error");
    }

    Error(int code, int apiErrorCode, String desc) {
        this.json = null;
        this.code = code;
        this.apiErrorCode = apiErrorCode;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public int getApiErrorCode() {
        return this.apiErrorCode;
    }

    public String getDescription() {
        return this.desc;
    }

    public String toString() {
        if (this.apiErrorCode == -1) {
            if (this.code == -1) {
                return this.desc;
            }
            return this.desc + " (" + this.code + ")";
        }
        if (this.code == -1) {
            return this.desc;
        }
        return this.desc + " [" + this.apiErrorCode + "]";
    }

    public static Error convert(Status status) {
        switch (status.getCode()) {
            case 404: {
                return JsNoMessageFoundErr;
            }
            case 408: {
                return JsBadRequestErr;
            }
        }
        return new Error(status.getCode(), -1, status.getMessage());
    }
}

