/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamSubscription;
import io.nats.client.MessageHandler;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.Watcher;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsFeatureBase;
import io.nats.client.impl.NatsJetStream;
import java.io.IOException;

public class NatsWatchSubscription<T>
implements AutoCloseable {
    private static final Object dispatcherLock = new Object();
    private static NatsDispatcher dispatcher;
    private final JetStream js;
    private JetStreamSubscription sub;

    public NatsWatchSubscription(JetStream js) {
        this.js = js;
    }

    protected void finishInit(NatsFeatureBase fb, String subscribeSubject, DeliverPolicy deliverPolicy, boolean headersOnly, WatchMessageHandler<T> handler) throws IOException, JetStreamApiException {
        long pending;
        if (deliverPolicy == DeliverPolicy.New || fb._getLast(subscribeSubject) == null) {
            handler.sendEndOfData();
        }
        PushSubscribeOptions pso = ((PushSubscribeOptions.Builder)((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().stream(fb.getStreamName())).ordered(true).configuration(ConsumerConfiguration.builder().ackPolicy(AckPolicy.None).deliverPolicy(deliverPolicy).headersOnly(headersOnly).filterSubject(subscribeSubject).build())).build();
        this.sub = this.js.subscribe(subscribeSubject, NatsWatchSubscription.getDispatcher(this.js), handler, false, pso);
        if (!handler.endOfDataSent && (pending = this.sub.getConsumerInfo().getCalculatedPending()) == 0L) {
            handler.sendEndOfData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dispatcher getDispatcher(JetStream js) {
        Object object = dispatcherLock;
        synchronized (object) {
            if (dispatcher == null) {
                dispatcher = (NatsDispatcher)((NatsJetStream)js).conn.createDispatcher();
            }
            return dispatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        Object object = dispatcherLock;
        synchronized (object) {
            dispatcher.unsubscribe(this.sub);
            if (dispatcher.getSubscriptionHandlers().size() == 0) {
                NatsWatchSubscription.dispatcher.connection.closeDispatcher(dispatcher);
                dispatcher = null;
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.unsubscribe();
    }

    protected static abstract class WatchMessageHandler<T>
    implements MessageHandler {
        private final Watcher<T> watcher;
        boolean endOfDataSent;

        protected WatchMessageHandler(Watcher<T> watcher) {
            this.watcher = watcher;
        }

        public void sendEndOfData() {
            this.endOfDataSent = true;
            this.watcher.endOfData();
        }
    }
}

