/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.ConditionFuture;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class StateTransferLockImpl
implements StateTransferLock {
    private static final Log log = LogFactory.getLog(StateTransferLockImpl.class);
    private static final int TOPOLOGY_ID_STOPPED = Integer.MAX_VALUE;
    private final StampedLock ownershipLock = new StampedLock();
    private final Lock writeLock = this.ownershipLock.asWriteLock();
    private final Lock readLock = this.ownershipLock.asReadLock();
    private volatile int topologyId = -1;
    private ConditionFuture<StateTransferLockImpl> topologyFuture;
    private volatile int transactionDataTopologyId = -1;
    private ConditionFuture<StateTransferLockImpl> transactionDataFuture;
    private long stateTransferTimeout;
    private long remoteTimeout;

    @Inject
    void inject(@ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService timeoutExecutor, Configuration configuration) {
        this.topologyFuture = new ConditionFuture(timeoutExecutor);
        this.transactionDataFuture = new ConditionFuture(timeoutExecutor);
        this.stateTransferTimeout = configuration.clustering().stateTransfer().timeout();
        this.remoteTimeout = configuration.clustering().remoteTimeout();
        configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).addListener((a, ignored) -> {
            this.remoteTimeout = (Long)a.get();
        });
    }

    @Stop
    void stop() {
        this.notifyTopologyInstalled(Integer.MAX_VALUE);
        this.notifyTransactionDataReceived(Integer.MAX_VALUE);
    }

    @Override
    public void acquireExclusiveTopologyLock() {
        if (log.isTraceEnabled()) {
            log.tracef("Acquire exclusive state transfer lock, readers = %d", this.ownershipLock.getReadLockCount());
        }
        this.writeLock.lock();
    }

    @Override
    public void releaseExclusiveTopologyLock() {
        if (log.isTraceEnabled()) {
            log.tracef("Release exclusive state transfer lock", new Object[0]);
        }
        this.writeLock.unlock();
    }

    @Override
    public void acquireSharedTopologyLock() {
        this.readLock.lock();
    }

    @Override
    public void releaseSharedTopologyLock() {
        this.readLock.unlock();
    }

    @Override
    public void notifyTransactionDataReceived(int topologyId) {
        if (topologyId < this.transactionDataTopologyId) {
            log.debugf("Trying to set a topology id (%d) that is lower than the current one (%d)", topologyId, this.topologyId);
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Signalling transaction data received for topology %d", topologyId);
        }
        this.transactionDataTopologyId = topologyId;
        this.transactionDataFuture.update(this);
    }

    @Override
    public CompletionStage<Void> transactionDataFuture(int expectedTopologyId) {
        if (this.topologyId == Integer.MAX_VALUE) {
            return CompletableFutures.completedExceptionFuture((Throwable)new IllegalLifecycleStateException());
        }
        if (this.transactionDataTopologyId >= expectedTopologyId) {
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Waiting for transaction data for topology %d, current topology is %d", expectedTopologyId, this.transactionDataTopologyId);
        }
        return this.transactionDataFuture.newConditionStage(stli -> stli.transactionDataTopologyId >= expectedTopologyId, () -> this.transactionDataTimeoutException(expectedTopologyId), this.remoteTimeout, TimeUnit.MILLISECONDS);
    }

    private TimeoutException transactionDataTimeoutException(int expectedTopologyId) {
        int currentTopologyId = this.topologyId;
        if (expectedTopologyId > currentTopologyId) {
            return Log.CLUSTER.transactionDataTimeout(expectedTopologyId);
        }
        return Log.CLUSTER.topologyTimeout(expectedTopologyId, currentTopologyId);
    }

    @Override
    public boolean transactionDataReceived(int expectedTopologyId) {
        if (log.isTraceEnabled()) {
            log.tracef("Checking if transaction data was received for topology %s, current topology is %s", expectedTopologyId, this.transactionDataTopologyId);
        }
        return this.transactionDataTopologyId >= expectedTopologyId;
    }

    @Override
    public void notifyTopologyInstalled(int topologyId) {
        if (topologyId < this.topologyId) {
            log.debugf("Trying to set a topology id (%d) that is lower than the current one (%d)", topologyId, this.topologyId);
            return;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Signalling topology %d is installed", topologyId);
        }
        this.topologyId = topologyId;
        this.topologyFuture.update(this);
    }

    @Override
    public CompletionStage<Void> topologyFuture(int expectedTopologyId) {
        if (this.topologyId == Integer.MAX_VALUE) {
            return CompletableFutures.completedExceptionFuture((Throwable)new IllegalLifecycleStateException());
        }
        if (this.topologyId >= expectedTopologyId) {
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Waiting for topology %d to be installed, current topology is %d", expectedTopologyId, this.topologyId);
        }
        return this.topologyFuture.newConditionStage(stli -> stli.topologyId >= expectedTopologyId, () -> Log.CLUSTER.topologyTimeout(expectedTopologyId, this.topologyId), this.stateTransferTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean topologyReceived(int expectedTopologyId) {
        return this.topologyId >= expectedTopologyId;
    }
}

