/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.netty.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncaughtExceptions {
    private static final Logger LOG = LoggerFactory.getLogger(UncaughtExceptions.class);

    public static <T> void log(Future<T> future) {
        if (!future.isSuccess() && !future.isCancelled()) {
            Loggers.warnWithException(LOG, "Uncaught exception in scheduled task", future.cause());
        }
    }

    public static <T> T log(Throwable t) {
        Loggers.warnWithException(LOG, "Uncaught exception in scheduled task", t);
        return null;
    }
}

